#
# Copyright (c) 2015-2021 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

"""PyAMS_*** module

"""

from zope.annotation import IAttributeAnnotatable
from zope.container.constraints import containers, contains
from zope.interface import Interface
from zope.schema import Bool, Choice, TextLine

from pyams_content.component.paragraph import IBaseParagraph
from pyams_content.interfaces.container import IOrderedContainer
from pyams_file.schema import ThumbnailImageField
from pyams_i18n.schema import I18nTextField, I18nTextLineField

__docformat__ = 'restructuredtext'

from pyams_content import _


VERBATIM_CONTAINER_KEY = 'pyams_content.verbatims'


class IVerbatimBase(IAttributeAnnotatable):
    """Base verbatim interface"""

    quote = I18nTextField(title=_("Quoted text"),
                          description=_("Quotation marks will be added automatically by "
                                        "presentation template"),
                          required=True)

    author = TextLine(title=_("Author"),
                      description=_("Name of the quote author"),
                      required=False)

    charge = I18nTextLineField(title=_("In charge of"),
                               description=_("Label of author function"),
                               required=False)


class IVerbatim(IVerbatimBase):
    """Verbatim interface"""

    containers('.IVerbatimContainer')

    visible = Bool(title=_("Visible?"),
                   description=_("Is this key number visible in front-office?"),
                   required=True,
                   default=True)

    illustration = ThumbnailImageField(title=_("Illustration"),
                                       description=_("This is an illustration associated with "
                                                     "this verbatim"),
                                       required=False)


VERBATIM_HIDDEN_FIELDS = ('__parent__', '__name__', 'visible')


class IVerbatimContainer(IOrderedContainer):
    """Verbatim container interface"""

    contains(IVerbatim)

    def append(self, value, notify=True):
        """Append given verbatim to container"""

    def get_visible_items(self):
        """Get list of visible verbatims"""


class IVerbatimContainerTarget(Interface):
    """Verbatim container target marker interface"""


#
# Verbatim paragraph
#

VERBATIM_PARAGRAPH_TYPE = 'Verbatim'
VERBATIM_PARAGRAPH_NAME = _("Verbatim")
VERBATIM_PARAGRAPH_RENDERERS = 'PyAMS.paragraph.verbatim.renderers'


class IVerbatimParagraph(IVerbatimBase, IBaseParagraph):
    """Verbatim paragraph interface"""

    renderer = Choice(title=_("Verbatim template"),
                      description=_("Presentation template used for this paragraph"),
                      vocabulary=VERBATIM_PARAGRAPH_RENDERERS,
                      default='default')
