#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'


# import standard library

# import interfaces
from pyams_content.component.theme.interfaces import IPortletTagsSettingsTarget, IPortletThemesSettingsTarget, \
    IPortletCollectionsSettingsTarget, IPortletTagsSettings, IPortletThemesSettings, IPortletCollectionsSettings
from pyams_form.interfaces.form import IInnerTabForm
from pyams_skin.layer import IPyAMSLayer

# import packages
from pyams_portal.zmi.portlet import PortletSettingsEditor
from pyams_utils.adapter import adapter_config
from pyams_zmi.form import InnerAdminEditForm
from z3c.form import field

from pyams_content import _


@adapter_config(name='tags', context=(IPortletTagsSettingsTarget, IPyAMSLayer, PortletSettingsEditor),
                provides=IInnerTabForm)
class PortletSettingsTagsEditor(InnerAdminEditForm):
    """Portlet settings for tags"""

    prefix = 'tags_form.'

    tab_label = _("Tags")
    legend = None

    fields = field.Fields(IPortletTagsSettings)

    weight = 50


@adapter_config(name='themes', context=(IPortletThemesSettingsTarget, IPyAMSLayer, PortletSettingsEditor),
                provides=IInnerTabForm)
class PortletSettingsThemesEditor(InnerAdminEditForm):
    """Portlet settings for themes"""

    prefix = 'themes_form.'

    tab_label = _("Themes")
    legend = None

    fields = field.Fields(IPortletThemesSettings)

    weight = 52


@adapter_config(name='collections', context=(IPortletCollectionsSettingsTarget, IPyAMSLayer, PortletSettingsEditor),
                provides=IInnerTabForm)
class PortletSettingsCollectionsEditor(InnerAdminEditForm):
    """Portlet settings for collections"""

    prefix = 'collections_form.'

    tab_label = _("Collections")
    legend = None

    fields = field.Fields(IPortletCollectionsSettings)

    weight = 54
