#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

from persistent import Persistent
from zope.container.contained import Contained
from zope.schema.fieldproperty import FieldProperty
from zope.traversing.interfaces import ITraversable

from pyams_content.component.theme.interfaces import IPortletCollectionsSettings, IPortletCollectionsSettingsTarget, \
    IPortletTagsSettings, IPortletTagsSettingsTarget, IPortletThemesSettings, IPortletThemesSettingsTarget, \
    PORTLET_SETTINGS_COLLECTIONS_KEY, PORTLET_SETTINGS_TAGS_KEY, PORTLET_SETTINGS_THEMES_KEY
from pyams_utils.adapter import ContextAdapter, adapter_config, get_annotation_adapter
from pyams_utils.factory import factory_config


#
# Portlets tags management
#

@factory_config(IPortletTagsSettings)
class PortletTagsSettings(Persistent, Contained):
    """Portlet tags settings"""

    tags = FieldProperty(IPortletTagsSettings['tags'])


@adapter_config(context=IPortletTagsSettingsTarget, provides=IPortletTagsSettings)
def portlet_tags_settings_factory(context):
    """Portlet tags settings adapter"""
    return get_annotation_adapter(context, PORTLET_SETTINGS_TAGS_KEY, IPortletTagsSettings,
                                  name='++tags++')


@adapter_config(name='tags', context=IPortletTagsSettingsTarget, provides=ITraversable)
class TagsPortletsSettingsTraverser(ContextAdapter):
    """++tags++ portlet settings adapter"""

    def traverse(self, name, furtherpath=None):
        return IPortletTagsSettings(self.context)


#
# Portlets themes management
#

@factory_config(IPortletThemesSettings)
class PortletThemesSettings(Persistent, Contained):
    """Portlet themes settings"""

    themes = FieldProperty(IPortletThemesSettings['themes'])


@adapter_config(context=IPortletThemesSettingsTarget, provides=IPortletThemesSettings)
def portlet_themes_settings_factory(context):
    """Portlet themes settings adapter"""
    return get_annotation_adapter(context, PORTLET_SETTINGS_THEMES_KEY, IPortletThemesSettings,
                                  name='++themes++')


@adapter_config(name='themes', context=IPortletThemesSettingsTarget, provides=ITraversable)
class ThemesPortletsSettingsTraverser(ContextAdapter):
    """++themes++ portlet settings adapter"""

    def traverse(self, name, furtherpath=None):
        return IPortletThemesSettings(self.context)


#
# Portlets collections management
#

@factory_config(IPortletCollectionsSettings)
class PortletCollectionsSettings(Persistent, Contained):
    """Portlet collections settings"""

    collections = FieldProperty(IPortletCollectionsSettings['collections'])


@adapter_config(context=IPortletCollectionsSettingsTarget, provides=IPortletCollectionsSettings)
def portlet_collections_settings_factory(context):
    """Portlet collections settings adapter"""
    return get_annotation_adapter(context, PORTLET_SETTINGS_COLLECTIONS_KEY, IPortletCollectionsSettings,
                                  name='++collections++')


@adapter_config(name='collections', context=IPortletCollectionsSettingsTarget, provides=ITraversable)
class CollectionsPortletsSettingsTraverser(ContextAdapter):
    """++collections++ portlet settings adapter"""

    def traverse(self, name, furtherpath=None):
        return IPortletCollectionsSettings(self.context)
