#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

from zope.interface import Interface, Invalid, invariant
from zope.schema import Bool, Choice

from pyams_thesaurus.interfaces.thesaurus import IThesaurusContextManager, \
    IThesaurusContextManagerTarget
from pyams_thesaurus.schema import ThesaurusTermsListField
from pyams_utils.interfaces.inherit import IInheritInfo


__docformat__ = 'restructuredtext'

from pyams_content import _


#
# Tags management
#

TAGS_MANAGER_KEY = 'pyams_content.tags.manager'
TAGS_INFO_KEY = 'pyams_content.tags.info'


class ITagsManager(IThesaurusContextManager):
    """Tags manager interface"""

    enable_glossary = Bool(title=_("Enable glossary?"),
                           description=_(""),
                           required=True,
                           default=False)

    glossary_thesaurus_name = Choice(title=_("Glossary thesaurus name"),
                                     vocabulary='PyAMS thesaurus names',
                                     required=False)

    @invariant
    def check_glossary_thesaurus(self):
        if self.enable_glossary and not self.glossary_thesaurus_name:
            raise Invalid(_("You must specify a glossary thesaurus to activate it!"))


class ITagsManagerTarget(IThesaurusContextManagerTarget):
    """Marker interface for tags manager"""


class ITagsInfo(Interface):
    """Tags information interface"""

    tags = ThesaurusTermsListField(title=_("Tags"),
                                   required=False)


class ITagsTarget(Interface):
    """Tags target interface"""


PORTLET_SETTINGS_TAGS_KEY = 'pyams_content.portlet.tags.settings'


class IPortletTagsSettings(Interface):
    """Interface for portlet settings managing tags"""

    tags = ThesaurusTermsListField(title=_("Tags"),
                                   required=False)


class IPortletTagsSettingsTarget(Interface):
    """Marker interface for portlet settings managing tags"""


#
# Themes management
#

THEMES_MANAGER_KEY = 'pyams_content.themes.manager'
THEMES_INFO_KEY = 'pyams_content.themes.info'


class IThemesManager(IThesaurusContextManager):
    """Themes manager interface"""


class IThemesManagerTarget(IThesaurusContextManagerTarget):
    """Marker interface for tools managing themes"""


class IThemesInfo(IInheritInfo):
    """Themes information interface"""

    themes = ThesaurusTermsListField(title=_("Themes"),
                                     required=False)


class IThemesTarget(Interface):
    """Themes target interface"""


PORTLET_SETTINGS_THEMES_KEY = 'pyams_content.portlet.themes.settings'


class IPortletThemesSettings(Interface):
    """Interface for portlet settings managing themes"""

    themes = ThesaurusTermsListField(title=_("Themes"),
                                     required=False)


class IPortletThemesSettingsTarget(Interface):
    """Marker interface for portlet settings managing themes"""


#
# Collections management
#

COLLECTIONS_MANAGER_KEY = 'pyams_content.collections.manager'
COLLECTIONS_INFO_KEY = 'pyams_content.collections.info'


class ICollectionsManager(IThesaurusContextManager):
    """Collections manager interface"""


class ICollectionsManagerTarget(IThesaurusContextManagerTarget):
    """Marker interface for tools managing collections"""


class ICollectionsInfo(Interface):
    """Collections information interface"""

    collections = ThesaurusTermsListField(title=_("Collections"),
                                          required=False)


class ICollectionsTarget(Interface):
    """Collections target interface"""


PORTLET_SETTINGS_COLLECTIONS_KEY = 'pyams_content.portlet.collections.settings'


class IPortletCollectionsSettings(Interface):
    """Interface for portlet settings managing collections"""

    collections = ThesaurusTermsListField(title=_("Collections"),
                                          required=False)


class IPortletCollectionsSettingsTarget(Interface):
    """Marker interface for portlet settings managing collections"""
