#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'


# import standard library

from zope.schema import TextLine, Choice

from pyams_content import _
# import interfaces
from pyams_content.component.paragraph.interfaces import IBaseParagraph
# import packages
from pyams_file.schema import VideoField
from pyams_i18n.schema import I18nTextField, I18nTextLineField

#
# HTML paragraph
#

VIDEO_PARAGRAPH_TYPE = 'Video'
VIDEO_PARAGRAPH_NAME = _("Video")
VIDEO_PARAGRAPH_RENDERERS = 'PyAMS.paragraph.video.renderers'


class IVideoParagraph(IBaseParagraph):
    """Video paragraph"""

    data = VideoField(title=_("Video data"),
                      description=_("Video file content"),
                      required=True)

    title = I18nTextLineField(title=_("Legend"),
                              required=False)

    author = TextLine(title=_("Author"),
                      description=_("Name of document's author"),
                      required=True)

    description = I18nTextField(title=_("Associated text"),
                                description=_("Video description displayed by front-office template"),
                                required=False)

    renderer = Choice(title=_("Video template"),
                      description=_("Presentation template used for this video"),
                      vocabulary=VIDEO_PARAGRAPH_RENDERERS,
                      default='default')
