#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'


# import standard library

# import interfaces
from pyams_content.component.paragraph.interfaces import IBaseParagraph

# import packages
from pyams_i18n.schema import I18nTextField
from zope.schema import Choice

from pyams_content import _


#
# Keypoints paragraph
#

KEYPOINTS_PARAGRAPH_TYPE = 'Keypoints'
KEYPOINTS_PARAGRAPH_NAME = _("Key points")
KEYPOINTS_PARAGRAPH_RENDERERS = 'PyAMS.paragraph.keypoint.renderers'


class IKeypointsParagraph(IBaseParagraph):
    """Key points paragraph"""

    body = I18nTextField(title=_("Key points"),
                         description=_("Enter one key point by line, without hyphen or prefix"),
                         required=False)

    renderer = Choice(title=_("Presentation template"),
                      description=_("Presentation template used for this paragraph"),
                      vocabulary=KEYPOINTS_PARAGRAPH_RENDERERS,
                      default='default')
