#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'


# import standard library

# import interfaces
from pyams_content.component.paragraph.interfaces import IBaseParagraph

# import packages
from pyams_i18n.schema import I18nTextField
from zope.schema import Choice

from pyams_content import _


#
# Header paragraph
#

HEADER_PARAGRAPH_TYPE = 'Header'
HEADER_PARAGRAPH_NAME = _("Header")
HEADER_PARAGRAPH_RENDERERS = 'PyAMS.paragraph.header.renderers'


class IHeaderParagraph(IBaseParagraph):
    """Header paragraph"""

    header = I18nTextField(title=_("Header"),
                           required=False)

    renderer = Choice(title=_("Header template"),
                      description=_("Presentation template used for this header"),
                      vocabulary=HEADER_PARAGRAPH_RENDERERS,
                      default='default')
