#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

from zope.schema import Choice, Text, TextLine

from pyams_content.component.paragraph import IBaseParagraph
from pyams_content.shared.form.interfaces import FORM_CONTENT_TYPE
from pyams_file.schema import ImageField
from pyams_i18n.schema import I18nTextLineField
from pyams_sequence.schema import InternalReferenceField
from pyams_utils.schema import MailAddressField


try:
    from pyams_gis.schema import GeoPointField
except ImportError:
    GeoPointField = None
    have_gis = False
else:
    have_gis = True

from pyams_content import _


#
# Contact paragraph
#

CONTACT_PARAGRAPH_TYPE = 'Contact'
CONTACT_PARAGRAPH_NAME = _("Contact card")
CONTACT_PARAGRAPH_RENDERERS = 'PyAMS.paragraph.contact.renderers'


class IContactParagraph(IBaseParagraph):
    """Contact paragraph interface"""

    name = TextLine(title=_("Contact identity"),
                    description=_("Name of the contact"),
                    required=False)

    charge = I18nTextLineField(title=_("In charge of"),
                               description=_("Label of contact function"),
                               required=False)

    company = TextLine(title=_("Company"),
                       description=_("Business name of the employer"),
                       required=False)

    contact_email = MailAddressField(title=_("Email address"),
                                     description=_("Contact email address"),
                                     required=False)

    contact_form = InternalReferenceField(title=_("Contact form"),
                                          description=_("Reference of contact form"),
                                          required=False,
                                          content_type=FORM_CONTENT_TYPE)

    phone_number = TextLine(title=_('Phone number'),
                            description=_('Phone number in international format.\n E.g. +33 ....'),
                            required=False, )

    photo = ImageField(title=_("Photo"),
                       description=_("Use 'browse' button to select contact picture"),
                       required=False)

    if have_gis:
        gps_location = GeoPointField(title=_("GPS location"),
                                     description=_("GPS coordinates used to locate contact"),
                                     required=False)

    address = Text(title=_("Address"),
                   required=False)

    renderer = Choice(title=_("Contact template"),
                      description=_("Presentation template used for this contact"),
                      vocabulary=CONTACT_PARAGRAPH_RENDERERS,
                      default='default')
