#
# Copyright (c) 2015-2023 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

"""PyAMS_*** module

"""

__docformat__ = 'restructuredtext'

from colander import Boolean, MappingSchema, SchemaNode, SequenceSchema, String, drop

from pyams_content.component.illustration.api.schema import IllustrationInfo


class ParagraphInfo(MappingSchema):
    """Paragraph base information schema"""
    factory = SchemaNode(String(),
                         description="Paragraph factory name")
    title = SchemaNode(String(),
                       description="Paragraph title",
                       missing=drop)
    is_anchor = SchemaNode(Boolean(),
                           description="True if paragraph is a navigation anchor",
                           missing=False)
    illustration = IllustrationInfo(description="Illustration information",
                                    missing=drop)


class ParagraphsListInfo(SequenceSchema):
    """Paragraphs list information schema"""
    paragraph = ParagraphInfo()
