#
# Copyright (c) 2015-2022 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

"""PyAMS_*** module

"""

__docformat__ = 'restructuredtext'


from pyams_content.component.map.interfaces import have_gis
if have_gis:

    from zope.schema.fieldproperty import FieldProperty

    from pyams_content.component.map import BaseMapSettings
    from pyams_content.component.map.interfaces import IMapParagraph, MAP_PARAGRAPH_NAME, \
        MAP_PARAGRAPH_RENDERERS, MAP_PARAGRAPH_TYPE
    from pyams_content.component.paragraph import BaseParagraph, BaseParagraphFactory
    from pyams_content.component.paragraph.api import JSONParagraphConverter
    from pyams_content.component.paragraph.interfaces import IParagraphFactory
    from pyams_content.features.json.interfaces import IJSONConverter
    from pyams_content.features.renderer import RenderersVocabulary
    from pyams_gis.interfaces import WGS84
    from pyams_skin.layer import IPyAMSLayer
    from pyams_utils.adapter import adapter_config
    from pyams_utils.factory import factory_config
    from pyams_utils.registry import utility_config
    from pyams_utils.vocabulary import vocabulary_config


    @factory_config(provided=IMapParagraph)
    class MapParagraph(BaseParagraph, BaseMapSettings):
        """Map paragraph"""

        factory_name = MAP_PARAGRAPH_TYPE
        icon_class = 'fa-map-marker'
        icon_hint = MAP_PARAGRAPH_NAME

        renderer = FieldProperty(IMapParagraph['renderer'])


    @utility_config(name=MAP_PARAGRAPH_TYPE, provides=IParagraphFactory)
    class MapParagraphFactory(BaseParagraphFactory):
        """Map paragraph factory"""

        name = MAP_PARAGRAPH_NAME
        content_type = MapParagraph
        secondary_menu = True


    @vocabulary_config(name=MAP_PARAGRAPH_RENDERERS)
    class MapParagraphRenderersVocabulary(RenderersVocabulary):
        """Map paragraph renderers vocabulary"""

        content_interface = IMapParagraph


    @adapter_config(required=(IMapParagraph, IPyAMSLayer),
                    provides=IJSONConverter)
    class JSONMapParagraphConverter(JSONParagraphConverter):
        """JSON map paragraph converter"""

        def convert_content(self, params):
            result = super().convert_content(params)
            location = self.context.gps_location
            if location:
                srid = params.get('srid', WGS84)
                try:
                    coords = location.get_coordinates(srid)
                    result['gps_location'] = {
                        'longitude': float(coords[0]),
                        'latitude': float(coords[1]),
                        'srid': srid
                    }
                except NotImplementedError:
                    pass
            return result
