#
# Copyright (c) 2008-2018 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

from zope.interface import implementer
from zope.schema.fieldproperty import FieldProperty

from pyams_content.component.association.interfaces import ASSOCIATION_CONTAINER_KEY
from pyams_content.component.keynumber.interfaces import IKeyNumberContainer, IKeyNumberContainerTarget
from pyams_content.component.keynumber.portlet.interfaces import IKeyNumberPortletMenu, IKeyNumberPortletSettings
from pyams_content.features.menu.interfaces import IMenu, IMenuLinksContainer, IMenuLinksContainerTarget
from pyams_portal.portlet import Portlet, PortletSettings, portlet_config
from pyams_utils.adapter import adapter_config, get_annotation_adapter
from pyams_utils.factory import factory_config
from pyams_utils.interfaces import VIEW_PERMISSION

from pyams_content import _


KEYNUMBER_PORTLET_NAME = "pyams_portal.portlet.keynumber"

KEYNUMBER_PORTLET_LINKS_NAME = 'links'
KEYNUMBER_PORTLET_LINKS_KEY = '{0}::{1}'.format(ASSOCIATION_CONTAINER_KEY, KEYNUMBER_PORTLET_LINKS_NAME)


@factory_config(provided=IKeyNumberPortletSettings)
@implementer(IKeyNumberContainerTarget, IMenuLinksContainerTarget)
class KeyNumberPortletSettings(PortletSettings):
    """Key Number portlet settings"""

    title = FieldProperty(IKeyNumberPortletSettings['title'])
    teaser = FieldProperty(IKeyNumberPortletSettings['teaser'])

    @property
    def keynumbers(self):
        return IKeyNumberContainer(self)

    @property
    def links(self):
        return get_annotation_adapter(self, KEYNUMBER_PORTLET_LINKS_KEY, IMenu,
                                      markers=IKeyNumberPortletMenu,
                                      name='++ass++' + KEYNUMBER_PORTLET_LINKS_NAME)


@adapter_config(name=KEYNUMBER_PORTLET_LINKS_NAME, context=IKeyNumberPortletSettings, provides=IMenuLinksContainer)
def keynumber_links_adapter(context):
    """Key number settings links factory"""
    return context.links


@portlet_config(permission=VIEW_PERMISSION)
class KeyNumberPortlet(Portlet):
    """Key number portlet"""

    name = KEYNUMBER_PORTLET_NAME
    label = _("Key Numbers")

    toolbar_image = None
    toolbar_css_class = 'fa fa-fw fa-2x fa-dashboard'

    settings_factory = IKeyNumberPortletSettings
