#
# Copyright (c) 2015-2022 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

"""PyAMS_*** module

"""
from collections import OrderedDict

from zope.interface import Interface
from zope.schema import Choice
from zope.schema.vocabulary import SimpleTerm, SimpleVocabulary

from pyams_portal.interfaces import IPortletSettings


__docformat__ = 'restructuredtext'

from pyams_content import _


ILLUSTRATION_DISPLAY = OrderedDict((
    ('', _("Responsive selection")),
    ('portrait', _("Portrait selection")),
    ('square', _("Square selection")),
    ('pano', _("Panoramic selection")),
    ('banner', _("Banner"))
))

ILLUSTRATION_DISPLAY_VOCABULARY = SimpleVocabulary([
    SimpleTerm(v, title=t)
    for v, t in ILLUSTRATION_DISPLAY.items()
])


class IIllustrationPortletSettings(IPortletSettings):
    """Illustration portlet settings"""

    display = Choice(title=_("Selected display"),
                     vocabulary=ILLUSTRATION_DISPLAY_VOCABULARY,
                     required=False,
                     default='')


class IIllustrationPortletContent(Interface):
    """Illustration portlet content getter interface"""
