#
# Copyright (c) 2015-2022 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

"""PyAMS_*** module

"""

from zope.schema.fieldproperty import FieldProperty

from pyams_content.component.illustration.portlet.interfaces import IIllustrationPortletSettings
from pyams_portal.portlet import Portlet, PortletSettings, portlet_config
from pyams_utils.factory import factory_config
from pyams_utils.interfaces import VIEW_PERMISSION


__docformat__ = 'restructuredtext'

from pyams_content import _


ILLUSTRATION_PORTLET_NAME = 'pyams_content.portlet.illustration'


@factory_config(provided=IIllustrationPortletSettings)
class IllustrationPortletSettings(PortletSettings):
    """Illustration portlet persistent settings"""

    display = FieldProperty(IIllustrationPortletSettings['display'])


@portlet_config(permission=VIEW_PERMISSION)
class IllustrationPortlet(Portlet):
    """Illustration portlet"""

    name = ILLUSTRATION_PORTLET_NAME
    label = _("Illustration")

    toolbar_css_class = 'fa fa-fw fa-2x fa-file-image-o'

    settings_factory = IIllustrationPortletSettings
