#
# Copyright (c) 2008-2018 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

from z3c.form import field

from pyams_content.component.extfile.interfaces import IExtFileManagerInfo
from pyams_content.interfaces import MANAGE_SITE_ROOT_PERMISSION
from pyams_content.root import ISiteRoot
from pyams_form.form import ajax_config
from pyams_pagelet.pagelet import pagelet_config
from pyams_skin.layer import IPyAMSLayer
from pyams_skin.viewlet.menu import MenuItem
from pyams_viewlet.viewlet import viewlet_config
from pyams_zmi.form import AdminDialogEditForm
from pyams_zmi.interfaces.menu import IPropertiesMenu
from pyams_zmi.layer import IAdminLayer

from pyams_content import _


@viewlet_config(name='extfiles-manager.menu', context=ISiteRoot, layer=IAdminLayer,
                manager=IPropertiesMenu, permission=MANAGE_SITE_ROOT_PERMISSION, weight=770)
class ExtFileManagerMenu(MenuItem):
    """External files manager menu"""

    label = _("External files...")
    icon_class = 'fa-file-o'
    url = 'extfiles-manager.html'
    modal_target = True


@pagelet_config(name='extfiles-manager.html', context=ISiteRoot, layer=IPyAMSLayer,
                permission=MANAGE_SITE_ROOT_PERMISSION)
@ajax_config(name='extfiles-manager.json', context=ISiteRoot, layer=IPyAMSLayer)
class ExtFileManagerInfoEditForm(AdminDialogEditForm):
    """External files manager properties edit form"""

    prefix = 'extfiles_manager_info.'

    legend = _("External files properties")

    fields = field.Fields(IExtFileManagerInfo)
    edit_permission = MANAGE_SITE_ROOT_PERMISSION

    def getContent(self):
        return IExtFileManagerInfo(self.context)
