#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'


# import standard library

# import interfaces
from pyams_content.component.association.interfaces import IAssociationContainerTarget, IAssociationContainer, \
    IAssociationInfo
from pyams_content.component.extfile.interfaces import IExtFile, IExtImage
from pyams_i18n.interfaces import II18n
from pyams_skin.layer import IPyAMSLayer

# import packages
from pyams_utils.traversing import get_parent
from pyams_utils.url import absolute_url
from pyramid.view import view_config
from zope.interface import Interface


#
# External files container views
#

@view_config(name='get-files-list.json', context=Interface, request_type=IPyAMSLayer,
             renderer='json', xhr=True)
def get_files_list(request):
    """Get container files in JSON format for TinyMCE editor"""
    result = []
    target = get_parent(request.context, IAssociationContainerTarget)
    if target is not None:
        container = IAssociationContainer(target)
        result.extend([{'title': IAssociationInfo(item).user_title,
                        'value': absolute_url(II18n(item).query_attribute('data', request=request),
                                              request=request)}
                       for item in container.values() if IExtFile.providedBy(item)])
    return sorted(result, key=lambda x: x['title'])


@view_config(name='get-images-list.json', context=Interface, request_type=IPyAMSLayer,
             renderer='json', xhr=True)
def get_images_list(request):
    """Get container images in JSON format for TinyMCE editor"""
    result = []
    target = get_parent(request.context, IAssociationContainerTarget)
    if target is not None:
        container = IAssociationContainer(target)
        result.extend([{'title': IAssociationInfo(item).user_title,
                        'value': absolute_url(II18n(item).query_attribute('data', request=request),
                                              request=request)}
                       for item in container.values() if IExtImage.providedBy(item)])
    return sorted(result, key=lambda x: x['title'])
