#
# Copyright (c) 2015-2023 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

"""PyAMS_*** module

"""

from zope.interface import implementer
from zope.schema import Datetime, List
from zope.schema.interfaces import IList


__docformat__ = 'restructuredtext'


class IDatetimesField(IList):
    """Datetimes field interface"""


@implementer(IDatetimesField)
class DatetimesField(List):
    """Datetimes schema field"""

    def __init__(self, **kwargs):
        kwargs.pop('value_type', None)
        super().__init__(value_type=Datetime(),
                         **kwargs)
