#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'


from pyramid.i18n import TranslationStringFactory
_ = TranslationStringFactory('pyams_content')


def includeme(config):
    """Pyramid include"""

    from .include import include_package
    include_package(config)

    from pyams_content.interfaces import MANAGE_SITE_ROOT_PERMISSION, MANAGE_SITE_PERMISSION, \
        MANAGE_TOOL_PERMISSION, CREATE_CONTENT_PERMISSION, MANAGE_CONTENT_PERMISSION, \
        CREATE_VERSION_PERMISSION, COMMENT_CONTENT_PERMISSION, PUBLISH_CONTENT_PERMISSION, \
        USE_PUBLIC_API_PERMISSION
    from pyams_content.interfaces import WEBMASTER_ROLE, PILOT_ROLE, MANAGER_ROLE, OWNER_ROLE, \
        CONTRIBUTOR_ROLE, READER_ROLE, OPERATOR_ROLE, GUEST_ROLE, API_ROLE
    from pyams_security.interfaces import ADMIN_USER_ID, SYSTEM_ADMIN_ROLE
    from pyams_thesaurus.interfaces import CREATE_THESAURUS_PERMISSION, ADMIN_THESAURUS_PERMISSION
    from pyams_utils.interfaces import PUBLIC_PERMISSION, VIEW_PERMISSION, MANAGE_PERMISSION, \
        VIEW_SYSTEM_PERMISSION, MANAGE_ROLES_PERMISSION, MANAGE_SKIN_PERMISSION

    # register custom permissions
    config.register_permission({'id': MANAGE_SITE_ROOT_PERMISSION,
                                'title': _("Manage site root")})
    config.register_permission({'id': MANAGE_SITE_PERMISSION,
                                'title': _("Manage site")})
    config.register_permission({'id': MANAGE_TOOL_PERMISSION,
                                'title': _("Manage tool")})
    config.register_permission({'id': CREATE_CONTENT_PERMISSION,
                                'title': _("Create content")})
    config.register_permission({'id': MANAGE_CONTENT_PERMISSION,
                                'title': _("Manage content")})
    config.register_permission({'id': CREATE_VERSION_PERMISSION,
                                'title': _("Create version")})
    config.register_permission({'id': COMMENT_CONTENT_PERMISSION,
                                'title': _("Comment content")})
    config.register_permission({'id': PUBLISH_CONTENT_PERMISSION,
                                'title': _("Publish content")})
    config.register_permission({'id': USE_PUBLIC_API_PERMISSION,
                                'title': _("Use public API")})

    # update system administrator permissions
    config.register_role({
        'id': SYSTEM_ADMIN_ROLE,
        'title': _("System manager (role)"),
        'permissions': {CREATE_THESAURUS_PERMISSION, ADMIN_THESAURUS_PERMISSION,
                        MANAGE_SITE_ROOT_PERMISSION, MANAGE_SITE_PERMISSION,
                        MANAGE_TOOL_PERMISSION, MANAGE_SKIN_PERMISSION,
                        USE_PUBLIC_API_PERMISSION}
    })

    # register custom roles
    config.register_role({
        'id': WEBMASTER_ROLE,
        'title': _("Webmaster (role)"),
        'permissions': {PUBLIC_PERMISSION, VIEW_PERMISSION, MANAGE_PERMISSION,
                        VIEW_SYSTEM_PERMISSION, MANAGE_ROLES_PERMISSION,
                        CREATE_THESAURUS_PERMISSION, ADMIN_THESAURUS_PERMISSION,
                        MANAGE_SITE_ROOT_PERMISSION, MANAGE_SITE_PERMISSION,
                        MANAGE_TOOL_PERMISSION, CREATE_CONTENT_PERMISSION,
                        MANAGE_CONTENT_PERMISSION, CREATE_VERSION_PERMISSION,
                        MANAGE_SKIN_PERMISSION, COMMENT_CONTENT_PERMISSION,
                        PUBLISH_CONTENT_PERMISSION, USE_PUBLIC_API_PERMISSION},
        'managers': {ADMIN_USER_ID,
                     'role:{}'.format(SYSTEM_ADMIN_ROLE),
                     'role:{}'.format(WEBMASTER_ROLE)}
    })

    config.register_role({
        'id': PILOT_ROLE,
        'title': _("Pilot (role)"),
        'permissions': {PUBLIC_PERMISSION, VIEW_PERMISSION, MANAGE_PERMISSION,
                        VIEW_SYSTEM_PERMISSION, MANAGE_ROLES_PERMISSION,
                        MANAGE_SITE_PERMISSION, MANAGE_TOOL_PERMISSION,
                        MANAGE_CONTENT_PERMISSION, COMMENT_CONTENT_PERMISSION,
                        PUBLISH_CONTENT_PERMISSION},
        'managers': {ADMIN_USER_ID,
                     'role:{}'.format(SYSTEM_ADMIN_ROLE),
                     'role:{}'.format(WEBMASTER_ROLE)}
    })

    config.register_role({
        'id': MANAGER_ROLE,
        'title': _("Manager (role)"),
        'permissions': {PUBLIC_PERMISSION, VIEW_PERMISSION, MANAGE_PERMISSION,
                        VIEW_SYSTEM_PERMISSION, MANAGE_CONTENT_PERMISSION,
                        CREATE_VERSION_PERMISSION, COMMENT_CONTENT_PERMISSION,
                        PUBLISH_CONTENT_PERMISSION},
        'managers': {ADMIN_USER_ID,
                     'role:{}'.format(SYSTEM_ADMIN_ROLE),
                     'role:{}'.format(WEBMASTER_ROLE),
                     'role:{}'.format(PILOT_ROLE)}
    })

    config.register_role({
        'id': OWNER_ROLE,
        'title': _("Owner (role)"),
        'permissions': {PUBLIC_PERMISSION, VIEW_PERMISSION, MANAGE_PERMISSION,
                        VIEW_SYSTEM_PERMISSION, MANAGE_ROLES_PERMISSION,
                        MANAGE_CONTENT_PERMISSION, CREATE_VERSION_PERMISSION,
                        COMMENT_CONTENT_PERMISSION}
    })

    config.register_role({
        'id': CONTRIBUTOR_ROLE,
        'title': _("Contributor (role)"),
        'permissions': {PUBLIC_PERMISSION, VIEW_PERMISSION, MANAGE_PERMISSION,
                        VIEW_SYSTEM_PERMISSION,
                        CREATE_CONTENT_PERMISSION, MANAGE_CONTENT_PERMISSION,
                        CREATE_VERSION_PERMISSION, COMMENT_CONTENT_PERMISSION},
        'managers': {ADMIN_USER_ID,
                     'role:{}'.format(SYSTEM_ADMIN_ROLE),
                     'role:{}'.format(WEBMASTER_ROLE),
                     'role:{}'.format(PILOT_ROLE),
                     'role:{}'.format(OWNER_ROLE)}
    })

    config.register_role({
        'id': READER_ROLE,
        'title': _("Reader (role)"),
        'permissions': {PUBLIC_PERMISSION, VIEW_PERMISSION, MANAGE_PERMISSION,
                        VIEW_SYSTEM_PERMISSION, COMMENT_CONTENT_PERMISSION},
        'managers': {ADMIN_USER_ID,
                     'role:{}'.format(SYSTEM_ADMIN_ROLE),
                     'role:{}'.format(WEBMASTER_ROLE),
                     'role:{}'.format(PILOT_ROLE),
                     'role:{}'.format(MANAGER_ROLE),
                     'role:{}'.format(CONTRIBUTOR_ROLE)}
    })

    config.register_role({
        'id': OPERATOR_ROLE,
        'title': _("Operator (role)"),
        'permissions': {PUBLIC_PERMISSION, VIEW_PERMISSION, VIEW_SYSTEM_PERMISSION},
        'managers': {ADMIN_USER_ID,
                     'role:{0}'.format(SYSTEM_ADMIN_ROLE)}
    })

    config.register_role({
        'id': GUEST_ROLE,
        'title': _("Guest user (role)"),
        'permissions': {PUBLIC_PERMISSION, VIEW_PERMISSION},
        'managers': {ADMIN_USER_ID,
                     'role:{}'.format(SYSTEM_ADMIN_ROLE),
                     'role:{}'.format(WEBMASTER_ROLE),
                     'role:{}'.format(PILOT_ROLE),
                     'role:{}'.format(MANAGER_ROLE),
                     'role:{}'.format(CONTRIBUTOR_ROLE)}
    })

    config.register_role({
        'id': API_ROLE,
        'title': _("API client (role)"),
        'permissions': {PUBLIC_PERMISSION, VIEW_PERMISSION,
                        USE_PUBLIC_API_PERMISSION},
        'managers': {ADMIN_USER_ID,
                     'role:{}'.format(SYSTEM_ADMIN_ROLE)}
    })
