#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

"""
This module contains pyams_content package
"""
import os

from setuptools import find_packages, setup


DOCS = os.path.join(os.path.dirname(__file__),
                    'docs')

README = os.path.join(DOCS, 'README.txt')
HISTORY = os.path.join(DOCS, 'HISTORY.txt')

version = '0.2.6'
long_description = open(README).read() + '\n\n' + open(HISTORY).read()

tests_require = []

setup(name='pyams_content',
      version=version,
      description="PyAMS base content interfaces and classes",
      long_description=long_description,
      classifiers=[
          "License :: OSI Approved :: Zope Public License",
          "Development Status :: 4 - Beta",
          "Programming Language :: Python",
          "Framework :: Pyramid",
          "Topic :: Software Development :: Libraries :: Python Modules",
      ],
      keywords='Pyramid PyAMS',
      author='Thierry Florac',
      author_email='tflorac@ulthar.net',
      url='http://hg.ztfy.org/pyams/pyams_content',
      license='ZPL',
      packages=find_packages('src'),
      package_dir={'': 'src'},
      namespace_packages=[],
      include_package_data=True,
      package_data={'': ['*.zcml', '*.txt', '*.pt', '*.pot', '*.po', '*.mo',
                         '*.png', '*.gif', '*.jpeg', '*.jpg', '*.css', '*.js']},
      zip_safe=False,
      # uncomment this to be able to run tests with setup.py
      test_suite="pyams_content.tests.test_utilsdocs.test_suite",
      tests_require=tests_require,
      extras_require=dict(test=tests_require),
      install_requires=[
          'setuptools',
          # -*- Extra requirements: -*-
          'fanstatic',
          'hypatia',
          'myams >= 0.1.59',
          'persistent',
          'pyams_catalog',
          'pyams_file >= 0.1.29',
          'pyams_form >= 0.1.28',
          'pyams_i18n',
          'pyams_mail',
          'pyams_pagelet',
          'pyams_portal',
          'pyams_security',
          'pyams_sequence',
          'pyams_skin',
          'pyams_template',
          'pyams_thesaurus',
          'pyams_utils >= 0.1.15',
          'pyams_viewlet',
          'pyams_workflow',
          'pyams_zmi',
          'pyquery',
          'pyramid',
          'pyramid_chameleon',
          'pyramid_mailer',
          'qrcode',
          'transaction',
          'tinycss2',
          'z3c.form',
          'z3c.table',
          'zodbupdate',
          'zope.annotation',
          'zope.component',
          'zope.container',
          'zope.contentprovider',
          'zope.copy',
          'zope.dublincore',
          'zope.interface',
          'zope.intid',
          'zope.lifecycleevent',
          'zope.location',
          'zope.schema',
          'zope.site',
          'zope.traversing'
      ],
      entry_points={
          'console_scripts': [
              'pyams_index = pyams_content.scripts.index:index_site'
          ],
          'fanstatic.libraries': [
              'pyams_content = pyams_content.zmi:library'
          ],
          'zodbupdate': [
              'renames = pyams_content.generations:RENAMED_CLASSES'
          ]
      })
