#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

from pyams_content.component.paragraph.zmi import IParagraphContainerView
from pyams_content.features.preview.zmi import PreviewForm
from pyams_form.interfaces.form import IForm, IFormToolbarViewletsManager, IWidgetForm
from pyams_skin.interfaces.viewlet import IToolbarViewletManager
from pyams_template.template import template_config
from pyams_utils.adapter import NullAdapter
from pyams_viewlet.viewlet import Viewlet, viewlet_config
from pyams_zmi.layer import IAdminLayer


# import standard library


@viewlet_config(name='onf-characters', view=IForm, layer=IAdminLayer, manager=IFormToolbarViewletsManager,
                weight=1999)
@viewlet_config(name='onf-characters', view=IWidgetForm, layer=IAdminLayer, manager=IToolbarViewletManager,
                weight=1999)
@viewlet_config(name='onf-characters', view=IParagraphContainerView, layer=IAdminLayer, manager=IToolbarViewletManager,
                weight=1999)
@template_config(template='templates/characters.pt', layer=IAdminLayer)
class CustomCharactersViewlet(Viewlet):
    """Custom characters viewlet"""


@viewlet_config(name='onf-characters', view=PreviewForm, layer=IAdminLayer, manager=IFormToolbarViewletsManager)
class PreviewFormCharactersViewlet(NullAdapter):
    """Disable custom characters viewlet in preview form"""
