#
# Copyright (c) 2008-2018 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

from pyramid.decorator import reify
from zope.interface import Interface

from onf_website.features.header.interfaces import IDefaultHeaderRendererSettings
from onf_website.skin.public.layer import IONFBaseLayer
from onf_website.skin.public.root import IONFRootLayer
from pyams_content.features.header.interfaces import IHeaderSettings, IHeaderTarget
from pyams_content.root.interfaces import ISiteRoot
from pyams_content.shared.site.interfaces import ISiteManager
from pyams_default_theme.interfaces import IContentBannerIllustration
from pyams_i18n.interfaces import II18n
from pyams_template.template import template_config
from pyams_utils.traversing import get_parent
from pyams_viewlet.viewlet import ViewContentProvider, contentprovider_config


@contentprovider_config(name='pyams.banner', layer=IONFBaseLayer, view=Interface)
@template_config(template='templates/banner.pt', layer=IONFBaseLayer)
class Banner(ViewContentProvider):
    """Banner content provider"""

    @reify
    def settings(self):
        target = get_parent(self.context, IHeaderTarget)
        settings = IHeaderSettings(target)
        while settings.inherit:
            settings = IHeaderSettings(settings.parent)
        return IDefaultHeaderRendererSettings(settings.settings, None)

    @property
    def illustration(self):
        settings = self.settings
        if settings is not None:
            if settings.use_context_illustration:
                registry = self.request.registry
                illustration = registry.queryMultiAdapter((self.context, self.request),
                                                          IContentBannerIllustration)
                if (illustration is not None) and illustration.has_data():
                    data = II18n(illustration).query_attribute('data', request=self.request)
                    if data.content_type.startswith('video'):
                        return data, 'video'
                    else:
                        return illustration, 'illustration'
            else:
                background = settings.background
                if background:
                    if background.content_type.startswith('video'):
                        return background, 'video'
                    else:
                        return background, 'image'
        return None, None


@contentprovider_config(name='pyams.banner', context=ISiteRoot,
                        layer=IONFBaseLayer, view=Interface)
@contentprovider_config(name='pyams.banner', context=ISiteManager,
                        layer=IONFRootLayer, view=Interface)
@template_config(template='templates/siteroot-banner.pt', layer=IONFBaseLayer)
class SiteRootBanner(Banner):
    """Site root banner content provider"""

    @property
    def heading(self):
        settings = self.settings
        if settings is not None:
            return II18n(settings).query_attribute('heading', request=self.request)
