#
# Copyright (c) 2015-2021 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

"""PyAMS_*** module

"""

from persistent.cPersistence import Persistent
from zope.interface import Interface
from zope.location import Location

from onf_website.skin.public.satellite.live.viewlet.image.interfaces import \
    ILiveHomeBackgroundImagePortletSettings
from pyams_file.property import FileProperty
from pyams_portal.interfaces import IPortalContext, IPortletRenderer
from pyams_portal.portlets.image import IImagePortletSettings
from pyams_portal.portlets.image.skin import ImagePortletRenderer
from pyams_skin.layer import IPyAMSLayer
from pyams_template.template import template_config
from pyams_utils.adapter import adapter_config
from pyams_utils.factory import factory_config

__docformat__ = 'restructuredtext'

from onf_website import _


@factory_config(provided=ILiveHomeBackgroundImagePortletSettings)
class LiveHomeBackgroundImagePortletSettings(Persistent, Location):
    """Live home background image portlet settings"""

    foreground_image = FileProperty(ILiveHomeBackgroundImagePortletSettings['foreground_image'])
    overlay_image = FileProperty(ILiveHomeBackgroundImagePortletSettings['overlay_image'])


@adapter_config(name='ONF::live-home-background-image',
                context=(IPortalContext, IPyAMSLayer, Interface, IImagePortletSettings),
                provides=IPortletRenderer)
@template_config(template='templates/live-home-background.pt', layer=IPyAMSLayer)
class LiveHomeBackgroundImagePortletRenderer(ImagePortletRenderer):
    """Live home background image portlet renderer"""

    label = _("ONF: live skin home background image")
    weight = 10

    settings_interface = ILiveHomeBackgroundImagePortletSettings
