#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'


# import standard library

# import interfaces
from onf_website.skin.public.layer import IONFBaseLayer
from pyams_skin.interfaces import ISkin

# import packages
from pyams_utils.registry import utility_config

from onf_website import _


class IONFRootLayer(IONFBaseLayer):
    """ONF root skin layer"""


@utility_config(name='ONF root skin', provides=ISkin)
class ONFRootSkin(object):
    """ONF root skin"""

    label = _("ONF: root skin")
    layer = IONFRootLayer
