/**
 * onf v1.0.0 (http://proto.smartagence.com/onf/)
 * Copyright 2004-2022 Smart Agence <gilles@smartagence.com>
 */
/* ========================================================================
 * Bootstrap: collapse.js v3.4.1
 * https://getbootstrap.com/docs/3.4/javascript/#collapse
 * ========================================================================
 * Copyright 2011-2019 Twitter, Inc.
 * Licensed under MIT (https://github.com/twbs/bootstrap/blob/master/LICENSE)
 * ======================================================================== */

/* jshint latedef: false */

+function ($) {
  'use strict';

  // COLLAPSE PUBLIC CLASS DEFINITION
  // ================================

  var Collapse = function (element, options) {
    this.$element      = $(element)
    this.options       = $.extend({}, Collapse.DEFAULTS, options)
    this.$trigger      = $('[data-toggle="collapse"][href="#' + element.id + '"],' +
                           '[data-toggle="collapse"][data-target="#' + element.id + '"]')
    this.transitioning = null

    if (this.options.parent) {
      this.$parent = this.getParent()
    } else {
      this.addAriaAndCollapsedClass(this.$element, this.$trigger)
    }

    if (this.options.toggle) this.toggle()
  }

  Collapse.VERSION  = '3.4.1'

  Collapse.TRANSITION_DURATION = 350

  Collapse.DEFAULTS = {
    toggle: true
  }

  Collapse.prototype.dimension = function () {
    var hasWidth = this.$element.hasClass('width')
    return hasWidth ? 'width' : 'height'
  }

  Collapse.prototype.show = function () {
    if (this.transitioning || this.$element.hasClass('in')) return

    var activesData
    var actives = this.$parent && this.$parent.children('.panel').children('.in, .collapsing')

    if (actives && actives.length) {
      activesData = actives.data('bs.collapse')
      if (activesData && activesData.transitioning) return
    }

    var startEvent = $.Event('show.bs.collapse')
    this.$element.trigger(startEvent)
    if (startEvent.isDefaultPrevented()) return

    if (actives && actives.length) {
      Plugin.call(actives, 'hide')
      activesData || actives.data('bs.collapse', null)
    }

    var dimension = this.dimension()

    this.$element
      .removeClass('collapse')
      .addClass('collapsing')[dimension](0)
      .attr('aria-expanded', true)

    this.$trigger
      .removeClass('collapsed')
      .attr('aria-expanded', true)

    this.transitioning = 1

    var complete = function () {
      this.$element
        .removeClass('collapsing')
        .addClass('collapse in')[dimension]('')
      this.transitioning = 0
      this.$element
        .trigger('shown.bs.collapse')
    }

    if (!$.support.transition) return complete.call(this)

    var scrollSize = $.camelCase(['scroll', dimension].join('-'))

    this.$element
      .one('bsTransitionEnd', $.proxy(complete, this))
      .emulateTransitionEnd(Collapse.TRANSITION_DURATION)[dimension](this.$element[0][scrollSize])
  }

  Collapse.prototype.hide = function () {
    if (this.transitioning || !this.$element.hasClass('in')) return

    var startEvent = $.Event('hide.bs.collapse')
    this.$element.trigger(startEvent)
    if (startEvent.isDefaultPrevented()) return

    var dimension = this.dimension()

    this.$element[dimension](this.$element[dimension]())[0].offsetHeight

    this.$element
      .addClass('collapsing')
      .removeClass('collapse in')
      .attr('aria-expanded', false)

    this.$trigger
      .addClass('collapsed')
      .attr('aria-expanded', false)

    this.transitioning = 1

    var complete = function () {
      this.transitioning = 0
      this.$element
        .removeClass('collapsing')
        .addClass('collapse')
        .trigger('hidden.bs.collapse')
    }

    if (!$.support.transition) return complete.call(this)

    this.$element
      [dimension](0)
      .one('bsTransitionEnd', $.proxy(complete, this))
      .emulateTransitionEnd(Collapse.TRANSITION_DURATION)
  }

  Collapse.prototype.toggle = function () {
    this[this.$element.hasClass('in') ? 'hide' : 'show']()
  }

  Collapse.prototype.getParent = function () {
    return $(document).find(this.options.parent)
      .find('[data-toggle="collapse"][data-parent="' + this.options.parent + '"]')
      .each($.proxy(function (i, element) {
        var $element = $(element)
        this.addAriaAndCollapsedClass(getTargetFromTrigger($element), $element)
      }, this))
      .end()
  }

  Collapse.prototype.addAriaAndCollapsedClass = function ($element, $trigger) {
    var isOpen = $element.hasClass('in')

    $element.attr('aria-expanded', isOpen)
    $trigger
      .toggleClass('collapsed', !isOpen)
      .attr('aria-expanded', isOpen)
  }

  function getTargetFromTrigger($trigger) {
    var href
    var target = $trigger.attr('data-target')
      || (href = $trigger.attr('href')) && href.replace(/.*(?=#[^\s]+$)/, '') // strip for ie7

    return $(document).find(target)
  }


  // COLLAPSE PLUGIN DEFINITION
  // ==========================

  function Plugin(option) {
    return this.each(function () {
      var $this   = $(this)
      var data    = $this.data('bs.collapse')
      var options = $.extend({}, Collapse.DEFAULTS, $this.data(), typeof option == 'object' && option)

      if (!data && options.toggle && /show|hide/.test(option)) options.toggle = false
      if (!data) $this.data('bs.collapse', (data = new Collapse(this, options)))
      if (typeof option == 'string') data[option]()
    })
  }

  var old = $.fn.collapse

  $.fn.collapse             = Plugin
  $.fn.collapse.Constructor = Collapse


  // COLLAPSE NO CONFLICT
  // ====================

  $.fn.collapse.noConflict = function () {
    $.fn.collapse = old
    return this
  }


  // COLLAPSE DATA-API
  // =================

  $(document).on('click.bs.collapse.data-api', '[data-toggle="collapse"]', function (e) {
    var $this   = $(this)

    if (!$this.attr('data-target')) e.preventDefault()

    var $target = getTargetFromTrigger($this)
    var data    = $target.data('bs.collapse')
    var option  = data ? 'toggle' : $this.data()

    Plugin.call($target, option)
  })

}(jQuery);

/* ========================================================================
 * Bootstrap: dropdown.js v3.4.1
 * https://getbootstrap.com/docs/3.4/javascript/#dropdowns
 * ========================================================================
 * Copyright 2011-2019 Twitter, Inc.
 * Licensed under MIT (https://github.com/twbs/bootstrap/blob/master/LICENSE)
 * ======================================================================== */


+function ($) {
  'use strict';

  // DROPDOWN CLASS DEFINITION
  // =========================

  var backdrop = '.dropdown-backdrop'
  var toggle   = '[data-toggle="dropdown"]'
  var Dropdown = function (element) {
    $(element).on('click.bs.dropdown', this.toggle)
  }

  Dropdown.VERSION = '3.4.1'

  function getParent($this) {
    var selector = $this.attr('data-target')

    if (!selector) {
      selector = $this.attr('href')
      selector = selector && /#[A-Za-z]/.test(selector) && selector.replace(/.*(?=#[^\s]*$)/, '') // strip for ie7
    }

    var $parent = selector !== '#' ? $(document).find(selector) : null

    return $parent && $parent.length ? $parent : $this.parent()
  }

  function clearMenus(e) {
    if (e && e.which === 3) return
    $(backdrop).remove()
    $(toggle).each(function () {
      var $this         = $(this)
      var $parent       = getParent($this)
      var relatedTarget = { relatedTarget: this }

      if (!$parent.hasClass('open')) return

      if (e && e.type == 'click' && /input|textarea/i.test(e.target.tagName) && $.contains($parent[0], e.target)) return

      $parent.trigger(e = $.Event('hide.bs.dropdown', relatedTarget))

      if (e.isDefaultPrevented()) return

      $this.attr('aria-expanded', 'false')
      $parent.removeClass('open').trigger($.Event('hidden.bs.dropdown', relatedTarget))
    })
  }

  Dropdown.prototype.toggle = function (e) {
    var $this = $(this)

    if ($this.is('.disabled, :disabled')) return

    var $parent  = getParent($this)
    var isActive = $parent.hasClass('open')

    clearMenus()

    if (!isActive) {
      if ('ontouchstart' in document.documentElement && !$parent.closest('.navbar-nav').length) {
        // if mobile we use a backdrop because click events don't delegate
        $(document.createElement('div'))
          .addClass('dropdown-backdrop')
          .insertAfter($(this))
          .on('click', clearMenus)
      }

      var relatedTarget = { relatedTarget: this }
      $parent.trigger(e = $.Event('show.bs.dropdown', relatedTarget))

      if (e.isDefaultPrevented()) return

      $this
        .trigger('focus')
        .attr('aria-expanded', 'true')

      $parent
        .toggleClass('open')
        .trigger($.Event('shown.bs.dropdown', relatedTarget))
    }

    return false
  }

  Dropdown.prototype.keydown = function (e) {
    if (!/(38|40|27|32)/.test(e.which) || /input|textarea/i.test(e.target.tagName)) return

    var $this = $(this)

    e.preventDefault()
    e.stopPropagation()

    if ($this.is('.disabled, :disabled')) return

    var $parent  = getParent($this)
    var isActive = $parent.hasClass('open')

    if (!isActive && e.which != 27 || isActive && e.which == 27) {
      if (e.which == 27) $parent.find(toggle).trigger('focus')
      return $this.trigger('click')
    }

    var desc = ' li:not(.disabled):visible a'
    var $items = $parent.find('.dropdown-menu' + desc)

    if (!$items.length) return

    var index = $items.index(e.target)

    if (e.which == 38 && index > 0)                 index--         // up
    if (e.which == 40 && index < $items.length - 1) index++         // down
    if (!~index)                                    index = 0

    $items.eq(index).trigger('focus')
  }


  // DROPDOWN PLUGIN DEFINITION
  // ==========================

  function Plugin(option) {
    return this.each(function () {
      var $this = $(this)
      var data  = $this.data('bs.dropdown')

      if (!data) $this.data('bs.dropdown', (data = new Dropdown(this)))
      if (typeof option == 'string') data[option].call($this)
    })
  }

  var old = $.fn.dropdown

  $.fn.dropdown             = Plugin
  $.fn.dropdown.Constructor = Dropdown


  // DROPDOWN NO CONFLICT
  // ====================

  $.fn.dropdown.noConflict = function () {
    $.fn.dropdown = old
    return this
  }


  // APPLY TO STANDARD DROPDOWN ELEMENTS
  // ===================================

  $(document)
    .on('click.bs.dropdown.data-api', clearMenus)
    .on('click.bs.dropdown.data-api', '.dropdown form', function (e) { e.stopPropagation() })
    .on('click.bs.dropdown.data-api', toggle, Dropdown.prototype.toggle)
    .on('keydown.bs.dropdown.data-api', toggle, Dropdown.prototype.keydown)
    .on('keydown.bs.dropdown.data-api', '.dropdown-menu', Dropdown.prototype.keydown)

}(jQuery);

/* ========================================================================
 * Bootstrap: transition.js v3.4.1
 * https://getbootstrap.com/docs/3.4/javascript/#transitions
 * ========================================================================
 * Copyright 2011-2019 Twitter, Inc.
 * Licensed under MIT (https://github.com/twbs/bootstrap/blob/master/LICENSE)
 * ======================================================================== */


+function ($) {
  'use strict';

  // CSS TRANSITION SUPPORT (Shoutout: https://modernizr.com/)
  // ============================================================

  function transitionEnd() {
    var el = document.createElement('bootstrap')

    var transEndEventNames = {
      WebkitTransition : 'webkitTransitionEnd',
      MozTransition    : 'transitionend',
      OTransition      : 'oTransitionEnd otransitionend',
      transition       : 'transitionend'
    }

    for (var name in transEndEventNames) {
      if (el.style[name] !== undefined) {
        return { end: transEndEventNames[name] }
      }
    }

    return false // explicit for ie8 (  ._.)
  }

  // https://blog.alexmaccaw.com/css-transitions
  $.fn.emulateTransitionEnd = function (duration) {
    var called = false
    var $el = this
    $(this).one('bsTransitionEnd', function () { called = true })
    var callback = function () { if (!called) $($el).trigger($.support.transition.end) }
    setTimeout(callback, duration)
    return this
  }

  $(function () {
    $.support.transition = transitionEnd()

    if (!$.support.transition) return

    $.event.special.bsTransitionEnd = {
      bindType: $.support.transition.end,
      delegateType: $.support.transition.end,
      handle: function (e) {
        if ($(e.target).is(this)) return e.handleObj.handler.apply(this, arguments)
      }
    }
  })

}(jQuery);

/*!
 * Responsive Bootstrap Toolkit
 * Author:    Maciej Gurban
 * License:   MIT
 * Version:   2.6.3 (2016-06-21)
 * Origin:    https://github.com/maciej-gurban/responsive-bootstrap-toolkit
 */
var ResponsiveBootstrapToolkit=function(i){var e={detectionDivs:{bootstrap:{xs:i('<div class="device-xs visible-xs visible-xs-block"></div>'),sm:i('<div class="device-sm visible-sm visible-sm-block"></div>'),md:i('<div class="device-md visible-md visible-md-block"></div>'),lg:i('<div class="device-lg visible-lg visible-lg-block"></div>')},foundation:{small:i('<div class="device-xs show-for-small-only"></div>'),medium:i('<div class="device-sm show-for-medium-only"></div>'),large:i('<div class="device-md show-for-large-only"></div>'),xlarge:i('<div class="device-lg show-for-xlarge-only"></div>')}},applyDetectionDivs:function(){i(document).ready(function(){i.each(o.breakpoints,function(i){o.breakpoints[i].appendTo(".responsive-bootstrap-toolkit")})})},isAnExpression:function(i){return"<"==i.charAt(0)||">"==i.charAt(0)},splitExpression:function(i){var e=i.charAt(0),o="="==i.charAt(1),s=1+(o?1:0),n=i.slice(s);return{operator:e,orEqual:o,breakpointName:n}},isAnyActive:function(e){var s=!1;return i.each(e,function(i,e){return o.breakpoints[e].is(":visible")?(s=!0,!1):void 0}),s},isMatchingExpression:function(i){var s=e.splitExpression(i),n=Object.keys(o.breakpoints),r=n.indexOf(s.breakpointName);if(-1!==r){var t=0,a=0;"<"==s.operator&&(t=0,a=s.orEqual?++r:r),">"==s.operator&&(t=s.orEqual?r:++r,a=void 0);var l=n.slice(t,a);return e.isAnyActive(l)}}},o={interval:300,framework:null,breakpoints:null,is:function(i){return e.isAnExpression(i)?e.isMatchingExpression(i):o.breakpoints[i]&&o.breakpoints[i].is(":visible")},use:function(i,s){o.framework=i.toLowerCase(),"bootstrap"===o.framework||"foundation"===o.framework?o.breakpoints=e.detectionDivs[o.framework]:o.breakpoints=s,e.applyDetectionDivs()},current:function(){var e="unrecognized";return i.each(o.breakpoints,function(i){o.is(i)&&(e=i)}),e},changed:function(i,e){var s;return function(){clearTimeout(s),s=setTimeout(function(){i()},e||o.interval)}}};return i(document).ready(function(){i('<div class="responsive-bootstrap-toolkit"></div>').appendTo("body")}),null===o.framework&&o.use("bootstrap"),o}(jQuery);"undefined"!=typeof module&&module.exports&&(module.exports=ResponsiveBootstrapToolkit);
jQuery(document).ready(function($) {

    /*
     * jQuery simple and accessible hide-show system (collapsible regions), using ARIA
     * @version v1.9.1   
     * Website: https://a11y.nicolas-hoffmann.net/hide-show/
     * License MIT: https://github.com/nico3333fr/jquery-accessible-hide-show-aria/blob/master/LICENSE
     */
    // loading expand paragraphs
    // these are recommended settings by a11y experts. You may update to fulfill your needs, but be sure of what you’re doing.
    var attr_control = 'data-controls',
        attr_expanded = 'aria-expanded',
        attr_labelledby = 'data-labelledby',
        attr_hidden = 'data-hidden',
        $expandmore = $('.js-expandmore'),
        $body = $('body'),
        delay = 1500,
        hash = window.location.hash.replace("#", ""),
        multiexpandable = true,
        expand_all_text = 'Expand All',
        collapse_all_text = 'Collapse All';


    if ($expandmore.length) { // if there are at least one :)
        $expandmore.each(function(index_to_expand) {
            var $this = $(this),
                index_lisible = index_to_expand + 1,
                options = $this.data(),
                $hideshow_prefix_classes = typeof options.hideshowPrefixClass !== 'undefined' ? options.hideshowPrefixClass + '-' : '',
                not_all_expands = typeof options.notAllExpands !== 'undefined' ? true : false,
                $to_expand = $this.next(".js-to_expand"),
                $expandmore_text = $this.html();

            $this.html('<button type="button" class="' + $hideshow_prefix_classes + 'expandmore__button js-expandmore-button"' + ( not_all_expands ? 'data-not-all-expands="true"' : '' ) + '><span class="' + $hideshow_prefix_classes + 'expandmore__symbol" aria-hidden="true"></span>' + $expandmore_text + '</button>');
            var $button = $this.children('.js-expandmore-button');

            $to_expand.addClass($hideshow_prefix_classes + 'expandmore__to_expand').stop().delay(delay).queue(function() {
                var $this = $(this);
                if ($this.hasClass('js-first_load')) {
                    $this.removeClass('js-first_load');
                }
            });

            $button.attr('id', 'label_expand_' + index_lisible);
            $button.attr(attr_control, 'expand_' + index_lisible);
            $button.attr(attr_expanded, 'false');

            $to_expand.attr('id', 'expand_' + index_lisible);
            $to_expand.attr(attr_hidden, 'true');
            $to_expand.attr(attr_labelledby, 'label_expand_' + index_lisible);
            
            if (not_all_expands) {
               $to_expand.attr('data-not-all-expands', 'true');
            }

            // quick tip to open (if it has class is-opened or if hash is in expand)
            if ($to_expand.hasClass('is-opened') || (hash !== "" && $to_expand.find($("#" + hash)).length)) {
                $button.addClass('is-opened').attr(attr_expanded, 'true');
                $to_expand.removeClass('is-opened').removeAttr(attr_hidden);
            }


        });


    }


    $body.on('click', '.js-expandmore-button', function(event) {
        var $this = $(this),
            $destination = $('#' + $this.attr(attr_control));

        if ($this.attr(attr_expanded) === 'false') {

            if (multiexpandable === false) {
                $('.js-expandmore-button').removeClass('is-opened').attr(attr_expanded, 'false');
                $('.js-to_expand').attr(attr_hidden, 'true');
            }

            $this.addClass('is-opened').attr(attr_expanded, 'true');
            $destination.removeAttr(attr_hidden);
        } else {
            $this.removeClass('is-opened').attr(attr_expanded, 'false');
            $destination.attr(attr_hidden, 'true');
        }

        event.preventDefault();

    });

    $body.on('click keydown', '.js-expandmore', function(event) {
        var $this = $(this),
            $target = $(event.target),
            $button_in = $this.find('.js-expandmore-button');

        if (!$target.is($button_in) && !$target.closest($button_in).length) {

            if (event.type === 'click') {
                $button_in.trigger('click');
                return false;
            }
            if (event.type === 'keydown' && (event.keyCode === 13 || event.keyCode === 32)) {
                $button_in.trigger('click');
                return false;
            }

        }


    });

    $body.on('click', '.js-expandmore-all', function(event) {
        var $this = $(this),
            options = $this.data(),
            is_expanded = $this.attr('data-expand'),
            txt_expand_all = typeof options.textExpandAll !== 'undefined' ? options.textExpandAll : expand_all_text,
            txt_collapse_all = typeof options.textCloseAll !== 'undefined' ? options.textCloseAll : collapse_all_text,
            $all_buttons = $('.js-expandmore-button:not([data-not-all-expands])'),
            $all_destinations = $('.js-to_expand:not([data-not-all-expands])');

        if (is_expanded === 'true') {
            $all_buttons.addClass('is-opened').attr(attr_expanded, 'true');
            $all_destinations.removeAttr(attr_hidden);
            $this.attr('data-expand', 'false').html(txt_collapse_all);
        } else {
            $all_buttons.removeClass('is-opened').attr(attr_expanded, 'false');
            $all_destinations.attr(attr_hidden, 'true');
            $this.attr('data-expand', 'true').html(txt_expand_all);
        }


    });


});

jQuery(document).ready(function($) {

    /*
     * jQuery Accessible tab panel system, using ARIA
     * @version v1.6.1
     * Website: https://a11y.nicolas-hoffmann.net/tabs/
     * License MIT: https://github.com/nico3333fr/jquery-accessible-tabs-aria/blob/master/LICENSE
     */
    // Store current URL hash.
    var hash = window.location.hash.replace("#", "");

    /* Tabs ------------------------------------------------------------------------------------------------------------ */
    var $tabs = $(".js-tabs"),
        $body = $("body");

    if ($tabs.length) {

        var $tab_list = $tabs.find(".js-tablist");
        $tab_list.each(function() {
            var $this_tab_list = $(this),
                options = $this_tab_list.data(),
                $tabs_prefix_classes = typeof options.tabsPrefixClass !== 'undefined' ? options.tabsPrefixClass + '-' : '',
                $hx = typeof options.hx !== 'undefined' ? options.hx : '',
                $existing_hx = typeof options.existingHx !== 'undefined' ? options.existingHx : '',
                $this_tab_list_items = $this_tab_list.children(".js-tablist__item"),
                $this_tab_list_links = $this_tab_list.find(".js-tablist__link");

            // roles init
            $this_tab_list.attr("role", "tablist"); // ul        
            $this_tab_list_items.attr("role", "presentation"); // li
            $this_tab_list_links.attr("role", "tab"); // a

            // classes init
            $this_tab_list.addClass($tabs_prefix_classes + 'tabs__list');
            $this_tab_list_items.addClass($tabs_prefix_classes + 'tabs__item');
            $this_tab_list_links.addClass($tabs_prefix_classes + 'tabs__link');

            // controls/tabindex attributes
            $this_tab_list_links.each(function() {
                var $this = $(this),
                    $hx_generated_class = typeof options.tabsGeneratedHxClass !== 'undefined' ? options.tabsGeneratedHxClass : 'invisible',
                    $href = $this.attr("href"),
                    $controls = $($href),
                    $text = $this.text();

                if ($hx !== "") {
                    $controls.prepend('<' + $hx + ' class="' + $hx_generated_class + '" tabindex="0">' + $text + '</' + $hx + '>');
                }
                if ($existing_hx !== "") {
                    $controls.find($existing_hx + ':first-child').attr('tabindex', 0);
                }
                if (typeof $href !== "undefined" && $href !== "" && $href !== "#") {
                    $this.attr({
                        "aria-controls": $href.replace("#", ""),
                        "tabindex": -1,
                        "aria-selected": "false"
                    });
                }

                $this.removeAttr("href");

            });
        });

        /* Tabs content ---------------------------------------------------------------------------------------------------- */
        $(".js-tabcontent").attr({
                "role": "tabpanel", // contents
                "aria-hidden": "true" // all hidden
                //"tabindex": 0
            })
            .each(function() {
                var $this = $(this),
                    $this_id = $this.attr("id"),
                    $prefix_attribute = $("#label_" + $this_id).closest('.js-tablist').attr('data-tabs-prefix-class'),
                    $tabs_prefix_classes = typeof $prefix_attribute !== 'undefined' ? $prefix_attribute + '-' : '';
                // label by link
                $this.attr("aria-labelledby", "label_" + $this_id);

                $this.addClass($tabs_prefix_classes + 'tabs__content');
            });

        // search if hash is ON not disabled tab
        if (hash !== "" && $("#" + hash + ".js-tabcontent").length !== 0) {
            if ($("#label_" + hash + ".js-tablist__link:not([aria-disabled='true'])").length) {
                // display not disabled
                $("#" + hash + ".js-tabcontent").removeAttr("aria-hidden");
                // selection menu
                $("#label_" + hash + ".js-tablist__link").attr({
                    "aria-selected": "true",
                    "tabindex": 0
                });
            }

        }
        // search if hash is IN not disabled tab
        if (hash !== "" && $("#" + hash).parents('.js-tabcontent').length) {
            var $this_hash = $("#" + hash),
                $tab_content_parent = $this_hash.parents('.js-tabcontent'),
                $tab_content_parent_id = $tab_content_parent.attr('id');

            if ($("#label_" + $tab_content_parent_id + ".js-tablist__link:not([aria-disabled='true'])").length) {
                $tab_content_parent.removeAttr("aria-hidden");
                // selection menu
                $("#label_" + $tab_content_parent_id + ".js-tablist__link").attr({
                    "aria-selected": "true",
                    "tabindex": 0
                });
            }
        }

        // search if data-selected="1" is on a not disabled tab for each tab system
        $tabs.each(function() {
            var $this = $(this),
                $tab_selected = $this.find('.js-tablist__link[aria-selected="true"]'),
                $tab_data_selected = $this.find('.js-tablist__link[data-selected="1"]:not([aria-disabled="true"]):first'),
                $tab_data_selected_content = $('#' + $tab_data_selected.attr('aria-controls'));

            if ($tab_selected.length === 0 && $tab_data_selected.length !== 0) {
                $tab_data_selected.attr({
                    "aria-selected": "true",
                    "tabindex": 0
                });
                $tab_data_selected_content.removeAttr("aria-hidden");
            }
        });

        // if no selected => select first not disabled
        $tabs.each(function() {
            var $this = $(this),
                $tab_selected = $this.find('.js-tablist__link[aria-selected="true"]'),
                $first_link = $this.find('.js-tablist__link:not([aria-disabled="true"]):first'),
                $first_content = $('#' + $first_link.attr('aria-controls'));

            if ($tab_selected.length === 0) {
                $first_link.attr({
                    "aria-selected": "true",
                    "tabindex": 0
                });
                $first_content.removeAttr("aria-hidden");
            }
        });

        /* Events ---------------------------------------------------------------------------------------------------------- */
        /* click on a tab link */
        $body.on("click", ".js-tablist__link[aria-disabled='true']", function() {
            return false;
        });
        $body.on("click", ".js-tablist__link:not([aria-disabled='true'])", function(event) {
                var $this = $(this),
                    $hash_to_update = $this.attr("aria-controls"),
                    $tab_content_linked = $("#" + $this.attr("aria-controls")),
                    $parent = $this.closest(".js-tabs"),
                    options = $parent.data(),
                    tabs_disable_fragments = typeof options.tabsDisableFragment !== 'undefined' ? true : false,
                    $all_tab_links = $parent.find(".js-tablist__link"),
                    $all_tab_contents = $parent.find(".js-tabcontent");

                // aria selected false on all links
                $all_tab_links.attr({
                    "tabindex": -1,
                    "aria-selected": "false"
                });

                // add aria selected on $this
                $this.attr({
                    "aria-selected": "true",
                    "tabindex": 0
                });

                // add aria-hidden on all tabs contents
                $all_tab_contents.attr("aria-hidden", "true");

                // remove aria-hidden on tab linked
                $tab_content_linked.removeAttr("aria-hidden");

                // add fragment (timeout for transitions)
                if (tabs_disable_fragments === false) {
                    setTimeout(function() {
                        history.pushState(null, null, location.pathname + location.search + '#' + $hash_to_update)
                    }, 1000);
                }

                event.preventDefault();
            })
            /* Key down in tabs */
            .on("keydown", ".js-tablist", function(event) {

                var $parent = $(this).closest('.js-tabs'),
                    $activated = $parent.find('.js-tablist__link[aria-selected="true"]').parent(),
                    $last_link = $parent.find('.js-tablist__item:last-child .js-tablist__link'),
                    $first_link = $parent.find('.js-tablist__item:first-child .js-tablist__link'),
                    $focus_on_tab_only = false,
                    $prev = $activated,
                    $next = $activated;

                // search valid previous 
                do {
                    // if we are on first => activate last
                    if ($prev.is(".js-tablist__item:first-child")) {
                        $prev = $last_link.parent();
                    }
                    // else previous
                    else {
                        $prev = $prev.prev();
                    }
                }
                while ($prev.children('.js-tablist__link').attr('aria-disabled') === 'true' && $prev !== $activated);

                // search valid next
                do {
                    // if we are on last => activate first
                    if ($next.is(".js-tablist__item:last-child")) {
                        $next = $first_link.parent();
                    }
                    // else previous
                    else {
                        $next = $next.next();
                    }
                }
                while ($next.children('.js-tablist__link').attr('aria-disabled') === 'true' && $next !== $activated);

                // some event should be activated only if the focus is on tabs (not on tabpanel)
                if ($(document.activeElement).is($parent.find('.js-tablist__link'))) {
                    $focus_on_tab_only = true;
                }

                // catch keyboard event only if focus is on tab
                if ($focus_on_tab_only && !event.ctrlKey) {
                    // strike up or left in the tab
                    if (event.keyCode == 37 || event.keyCode == 38) {

                        $prev.children(".js-tablist__link").click().focus();

                        event.preventDefault();
                    }
                    // strike down or right in the tab
                    else if (event.keyCode == 40 || event.keyCode == 39) {

                        $next.children(".js-tablist__link").click().focus();

                        event.preventDefault();
                    } else if (event.keyCode == 36) {
                        // activate first tab
                        $first_link.click().focus();
                        event.preventDefault();
                    } else if (event.keyCode == 35) {
                        // activate last tab
                        $last_link.click().focus();
                        event.preventDefault();
                    }

                }

            })
            .on("keydown", ".js-tabcontent", function(event) {

                var $this = $(this),
                    $selector_tab_to_focus = $this.attr('aria-labelledby'),
                    $tab_to_focus = $("#" + $selector_tab_to_focus),
                    $parent_item = $tab_to_focus.parent(),
                    $parent_list = $parent_item.parent(),
                    $first_item = $parent_list.find('.js-tablist__item:first-child'),
                    $last_item = $parent_list.find('.js-tablist__item:last-child'),
                    $prev_item = $parent_item,
                    $next_item = $parent_item;

                // CTRL up/Left
                if ((event.keyCode == 37 || event.keyCode == 38) && event.ctrlKey) {
                    $tab_to_focus.focus();
                    event.preventDefault();
                }
                // CTRL PageUp
                if (event.keyCode == 33 && event.ctrlKey) {
                    //$tab_to_focus.focus();

                    // search valid previous 
                    do {
                        // if we are on first => last
                        if ($prev_item.is(".js-tablist__item:first-child")) {
                            $prev_item = $last_item;
                        }
                        // else previous
                        else {
                            $prev_item = $prev_item.prev();
                        }
                    }
                    while ($prev_item.children('.js-tablist__link').attr('aria-disabled') === 'true' && $prev_item !== $parent_item);

                    $prev_item.children(".js-tablist__link").click().focus();

                    event.preventDefault();
                }
                // CTRL PageDown
                if (event.keyCode == 34 && event.ctrlKey) {
                    $tab_to_focus.focus();

                    // search valid next 
                    do {
                        // if we are on last => first
                        if ($next_item.is(".js-tablist__item:last-child")) {
                            $next_item = $first_item;
                        }
                        // else previous
                        else {
                            $next_item = $next_item.next();
                        }
                    }
                    while ($next_item.children('.js-tablist__link').attr('aria-disabled') === 'true' && $next_item !== $parent_item);

                    $next_item.children(".js-tablist__link").click().focus();

                    event.preventDefault();
                }

            })
            /* click on a tab link */
            .on("click", ".js-link-to-tab", function() {
                var $this = $(this),
                    $tab_to_go = $($this.attr('href')),
                    $button_to_click = $('#' + $tab_to_go.attr('aria-labelledby'));

                if ($button_to_click.attr('aria-disabled') !== 'true') {
                    // activate tabs
                    $button_to_click.click();
                    // give focus to the good button
                    setTimeout(function() {
                        $button_to_click.focus()
                    }, 10);
                }

            });

    }

});

(function() {

    'use strict';

    /*
     * jQuery accessible simple (non-modal) tooltip window, using ARIA
     * @version v2.2.0 
     * Website: https://a11y.nicolas-hoffmann.net/simple-tooltip/
     * License MIT: https://github.com/nico3333fr/jquery-accessible-simple-tooltip-aria/blob/master/LICENSE
     */

    function accessibleSimpleTooltipAria(options) {
        var element = $(this);
        options = options || element.data();
        var text = options.simpletooltipText || '';
        var prefix_class = typeof options.simpletooltipPrefixClass !== 'undefined' ? options.simpletooltipPrefixClass + '-' : '';
        var content_id = typeof options.simpletooltipContentId !== 'undefined' ? '#' + options.simpletooltipContentId : '';

        var index_lisible = Math.random().toString(32).slice(2, 12);
        var aria_describedby = element.attr('aria-describedby') || '';

        element.attr({
            'aria-describedby': 'label_simpletooltip_' + index_lisible + ' ' + aria_describedby
        });

        element.wrap('<span class="' + prefix_class + 'simpletooltip_container"></span>');

        var html = '<span class="js-simpletooltip ' + prefix_class + 'simpletooltip" id="label_simpletooltip_' + index_lisible + '" role="tooltip" aria-hidden="true">';

        if (text !== '') {
            html += '' + text + '';
        } else {
            var $contentId = $(content_id);
            if (content_id !== '' && $contentId.length) {
                html += $contentId.html();
            }
        }
        html += '</span>';

        $(html).insertAfter(element);
    }

    // Bind as a jQuery plugin
    $.fn.accessibleSimpleTooltipAria = accessibleSimpleTooltipAria;

    $(document).ready(function() {

        $('.js-simple-tooltip')
            .each(function() {
                // Call the function with this as the current tooltip
                accessibleSimpleTooltipAria.apply(this);
            });

        // events ------------------
        $('body')
            .on('mouseenter focusin', '.js-simple-tooltip', function() {
                var $this = $(this);
                var aria_describedby = $this.attr('aria-describedby');
                var tooltip_to_show_id = aria_describedby.substr(0, aria_describedby.indexOf(" "));
                var $tooltip_to_show = $('#' + tooltip_to_show_id);
                $tooltip_to_show.attr('aria-hidden', 'false');
            })
            .on('mouseleave', '.js-simple-tooltip', function(event) {
                var $this = $(this);
                var aria_describedby = $this.attr('aria-describedby');
                var tooltip_to_show_id = aria_describedby.substr(0, aria_describedby.indexOf(" "));
                var $tooltip_to_show = $('#' + tooltip_to_show_id);
                var $is_target_hovered = $tooltip_to_show.is(':hover');

                //alert($target_hovered);
                //$target.addClass('redborder');
                if (!$is_target_hovered) {
                    $tooltip_to_show.attr('aria-hidden', 'true');
                }
            })
            .on('focusout', '.js-simple-tooltip', function(event) {
                var $this = $(this);
                var aria_describedby = $this.attr('aria-describedby');
                var tooltip_to_show_id = aria_describedby.substr(0, aria_describedby.indexOf(" "));
                var $tooltip_to_show = $('#' + tooltip_to_show_id);

                $tooltip_to_show.attr('aria-hidden', 'true');
            })
            .on('mouseleave', '.js-simpletooltip', function() {
                var $this = $(this);
                $this.attr('aria-hidden', 'true');
            })
            .on('keydown', '.js-simple-tooltip', function(event) {
                // close esc key

                var $this = $(this);
                var aria_describedby = $this.attr('aria-describedby');
                var tooltip_to_show_id = aria_describedby.substr(0, aria_describedby.indexOf(" "));
                var $tooltip_to_show = $('#' + tooltip_to_show_id);

                if (event.keyCode == 27) { // esc
                    $tooltip_to_show.attr('aria-hidden', 'true');
                }
            });
    });

})();

/*! Lity - v2.4.1 - 2020-04-26
* http://sorgalla.com/lity/
* Copyright (c) 2015-2020 Jan Sorgalla; Licensed MIT */

!function(a,b){"function"==typeof define&&define.amd?define(["jquery"],function(c){return b(a,c)}):"object"==typeof module&&"object"==typeof module.exports?module.exports=b(a,require("jquery")):a.lity=b(a,a.jQuery||a.Zepto)}("undefined"!=typeof window?window:this,function(a,b){"use strict";function c(a){var b=B();return N&&a.length?(a.one(N,b.resolve),setTimeout(b.resolve,500)):b.resolve(),b.promise()}function d(a,c,d){if(1===arguments.length)return b.extend({},a);if("string"==typeof c){if(void 0===d)return void 0===a[c]?null:a[c];a[c]=d}else b.extend(a,c);return this}function e(a){for(var b,c=decodeURI(a.split("#")[0]).split("&"),d={},e=0,f=c.length;e<f;e++)c[e]&&(b=c[e].split("="),d[b[0]]=b[1]);return d}function f(a,c){return a+(a.indexOf("?")>-1?"&":"?")+b.param(c)}function g(a,b){var c=a.indexOf("#");return-1===c?b:(c>0&&(a=a.substr(c)),b+a)}function h(a){return b('<span class="lity-error"></span>').append(a)}function i(a,c){var d=c.opener()&&c.opener().data("lity-desc")||"Image with no description",e=b('<img src="'+a+'" alt="'+d+'"/>'),f=B(),g=function(){f.reject(h("Failed loading image"))};return e.on("load",function(){if(0===this.naturalWidth)return g();f.resolve(e)}).on("error",g),f.promise()}function j(a,c){var d,e,f;try{d=b(a)}catch(a){return!1}return!!d.length&&(e=b('<i style="display:none !important"></i>'),f=d.hasClass("lity-hide"),c.element().one("lity:remove",function(){e.before(d).remove(),f&&!d.closest(".lity-content").length&&d.addClass("lity-hide")}),d.removeClass("lity-hide").after(e))}function k(a){var c=J.exec(a);return!!c&&o(g(a,f("https://www.youtube"+(c[2]||"")+".com/embed/"+c[4],b.extend({autoplay:1},e(c[5]||"")))))}function l(a){var c=K.exec(a);return!!c&&o(g(a,f("https://player.vimeo.com/video/"+c[3],b.extend({autoplay:1},e(c[4]||"")))))}function m(a){var c=M.exec(a);return!!c&&(0!==a.indexOf("http")&&(a="https:"+a),o(g(a,f("https://www.facebook.com/plugins/video.php?href="+a,b.extend({autoplay:1},e(c[4]||""))))))}function n(a){var b=L.exec(a);return!!b&&o(g(a,f("https://www.google."+b[3]+"/maps?"+b[6],{output:b[6].indexOf("layer=c")>0?"svembed":"embed"})))}function o(a){return'<div class="lity-iframe-container"><iframe frameborder="0" allowfullscreen allow="autoplay; fullscreen" src="'+a+'"/></div>'}function p(){return z.documentElement.clientHeight?z.documentElement.clientHeight:Math.round(A.height())}function q(a){var b=v();b&&(27===a.keyCode&&b.options("esc")&&b.close(),9===a.keyCode&&r(a,b))}function r(a,b){var c=b.element().find(G),d=c.index(z.activeElement);a.shiftKey&&d<=0?(c.get(c.length-1).focus(),a.preventDefault()):a.shiftKey||d!==c.length-1||(c.get(0).focus(),a.preventDefault())}function s(){b.each(D,function(a,b){b.resize()})}function t(a){1===D.unshift(a)&&(C.addClass("lity-active"),A.on({resize:s,keydown:q})),b("body > *").not(a.element()).addClass("lity-hidden").each(function(){var a=b(this);void 0===a.data(F)&&a.data(F,a.attr(E)||null)}).attr(E,"true")}function u(a){var c;a.element().attr(E,"true"),1===D.length&&(C.removeClass("lity-active"),A.off({resize:s,keydown:q})),D=b.grep(D,function(b){return a!==b}),c=D.length?D[0].element():b(".lity-hidden"),c.removeClass("lity-hidden").each(function(){var a=b(this),c=a.data(F);c?a.attr(E,c):a.removeAttr(E),a.removeData(F)})}function v(){return 0===D.length?null:D[0]}function w(a,c,d,e){var f,g="inline",h=b.extend({},d);return e&&h[e]?(f=h[e](a,c),g=e):(b.each(["inline","iframe"],function(a,b){delete h[b],h[b]=d[b]}),b.each(h,function(b,d){return!d||(!(!d.test||d.test(a,c))||(f=d(a,c),!1!==f?(g=b,!1):void 0))})),{handler:g,content:f||""}}function x(a,e,f,g){function h(a){k=b(a).css("max-height",p()+"px"),j.find(".lity-loader").each(function(){var a=b(this);c(a).always(function(){a.remove()})}),j.removeClass("lity-loading").find(".lity-content").empty().append(k),m=!0,k.trigger("lity:ready",[l])}var i,j,k,l=this,m=!1,n=!1;e=b.extend({},H,e),j=b(e.template),l.element=function(){return j},l.opener=function(){return f},l.options=b.proxy(d,l,e),l.handlers=b.proxy(d,l,e.handlers),l.resize=function(){m&&!n&&k.css("max-height",p()+"px").trigger("lity:resize",[l])},l.close=function(){if(m&&!n){n=!0,u(l);var a=B();if(g&&(z.activeElement===j[0]||b.contains(j[0],z.activeElement)))try{g.focus()}catch(a){}return k.trigger("lity:close",[l]),j.removeClass("lity-opened").addClass("lity-closed"),c(k.add(j)).always(function(){k.trigger("lity:remove",[l]),j.remove(),j=void 0,a.resolve()}),a.promise()}},i=w(a,l,e.handlers,e.handler),j.attr(E,"false").addClass("lity-loading lity-opened lity-"+i.handler).appendTo("body").focus().on("click","[data-lity-close]",function(a){b(a.target).is("[data-lity-close]")&&l.close()}).trigger("lity:open",[l]),t(l),b.when(i.content).always(h)}function y(a,c,d){a.preventDefault?(a.preventDefault(),d=b(this),a=d.data("lity-target")||d.attr("href")||d.attr("src")):d=b(d);var e=new x(a,b.extend({},d.data("lity-options")||d.data("lity"),c),d,z.activeElement);if(!a.preventDefault)return e}var z=a.document,A=b(a),B=b.Deferred,C=b("html"),D=[],E="aria-hidden",F="lity-"+E,G='a[href],area[href],input:not([disabled]),select:not([disabled]),textarea:not([disabled]),button:not([disabled]),iframe,object,embed,[contenteditable],[tabindex]:not([tabindex^="-"])',H={esc:!0,handler:null,handlers:{image:i,inline:j,youtube:k,vimeo:l,googlemaps:n,facebookvideo:m,iframe:o},template:'<div class="lity" role="dialog" aria-label="Dialog Window (Press escape to close)" tabindex="-1"><div class="lity-wrap" data-lity-close role="document"><div class="lity-loader" aria-hidden="true">Loading...</div><div class="lity-container"><div class="lity-content"></div><button class="lity-close" type="button" aria-label="Close (Press escape to close)" data-lity-close>&times;</button></div></div></div>'},I=/(^data:image\/)|(\.(png|jpe?g|gif|svg|webp|bmp|ico|tiff?)(\?\S*)?$)/i,J=/(youtube(-nocookie)?\.com|youtu\.be)\/(watch\?v=|v\/|u\/|embed\/?)?([\w-]{11})(.*)?/i,K=/(vimeo(pro)?.com)\/(?:[^\d]+)?(\d+)\??(.*)?$/,L=/((maps|www)\.)?google\.([^\/\?]+)\/?((maps\/?)?\?)(.*)/i,M=/(facebook\.com)\/([a-z0-9_-]*)\/videos\/([0-9]*)(.*)?$/i,N=function(){var a=z.createElement("div"),b={WebkitTransition:"webkitTransitionEnd",MozTransition:"transitionend",OTransition:"oTransitionEnd otransitionend",transition:"transitionend"};for(var c in b)if(void 0!==a.style[c])return b[c];return!1}();return i.test=function(a){return I.test(a)},y.version="2.4.1",y.options=b.proxy(d,y,H),y.handlers=b.proxy(d,y,H.handlers),y.current=v,b(z).on("click.lity","[data-lity]",y),y});
(function(a){a.isScrollToFixed=function(b){return !!a(b).data("ScrollToFixed")};a.ScrollToFixed=function(d,i){var m=this;m.$el=a(d);m.el=d;m.$el.data("ScrollToFixed",m);var c=false;var H=m.$el;var I;var F;var k;var e;var z;var E=0;var r=0;var j=-1;var f=-1;var u=null;var A;var g;function v(){H.trigger("preUnfixed.ScrollToFixed");l();H.trigger("unfixed.ScrollToFixed");f=-1;E=H.offset().top;r=H.offset().left;if(m.options.offsets){r+=(H.offset().left-H.position().left)}if(j==-1){j=r}I=H.css("position");c=true;if(m.options.bottom!=-1){H.trigger("preFixed.ScrollToFixed");x();H.trigger("fixed.ScrollToFixed")}}function o(){var J=m.options.limit;if(!J){return 0}if(typeof(J)==="function"){return J.apply(H)}return J}function q(){return I==="fixed"}function y(){return I==="absolute"}function h(){return !(q()||y())}function x(){if(!q()){var J=H[0].getBoundingClientRect();u.css({display:H.css("display"),width:J.width,height:J.height,"float":H.css("float")});cssOptions={"z-index":m.options.zIndex,position:"fixed",top:m.options.bottom==-1?t():"",bottom:m.options.bottom==-1?"":m.options.bottom,"margin-left":"0px"};if(!m.options.dontSetWidth){cssOptions.width=H.css("width")}H.css(cssOptions);H.addClass(m.options.baseClassName);if(m.options.className){H.addClass(m.options.className)}I="fixed"}}function b(){var K=o();var J=r;if(m.options.removeOffsets){J="";K=K-E}cssOptions={position:"absolute",top:K,left:J,"margin-left":"0px",bottom:""};if(!m.options.dontSetWidth){cssOptions.width=H.css("width")}H.css(cssOptions);I="absolute"}function l(){if(!h()){f=-1;u.css("display","none");H.css({"z-index":z,width:"",position:F,left:"",top:e,"margin-left":""});H.removeClass("scroll-to-fixed-fixed");if(m.options.className){H.removeClass(m.options.className)}I=null}}function w(J){if(J!=f){H.css("left",r-J);f=J}}function t(){var J=m.options.marginTop;if(!J){return 0}if(typeof(J)==="function"){return J.apply(H)}return J}function B(){if(!a.isScrollToFixed(H)||H.is(":hidden")){return}var M=c;var L=h();if(!c){v()}else{if(h()){E=H.offset().top;r=H.offset().left}}var J=a(window).scrollLeft();var N=a(window).scrollTop();var K=o();if(m.options.minWidth&&a(window).width()<m.options.minWidth){if(!h()||!M){p();H.trigger("preUnfixed.ScrollToFixed");l();H.trigger("unfixed.ScrollToFixed")}}else{if(m.options.maxWidth&&a(window).width()>m.options.maxWidth){if(!h()||!M){p();H.trigger("preUnfixed.ScrollToFixed");l();H.trigger("unfixed.ScrollToFixed")}}else{if(m.options.bottom==-1){if(K>0&&N>=K-t()){if(!L&&(!y()||!M)){p();H.trigger("preAbsolute.ScrollToFixed");b();H.trigger("unfixed.ScrollToFixed")}}else{if(N>=E-t()){if(!q()||!M){p();H.trigger("preFixed.ScrollToFixed");x();f=-1;H.trigger("fixed.ScrollToFixed")}w(J)}else{if(!h()||!M){p();H.trigger("preUnfixed.ScrollToFixed");l();H.trigger("unfixed.ScrollToFixed")}}}}else{if(K>0){if(N+a(window).height()-H.outerHeight(true)>=K-(t()||-n())){if(q()){p();H.trigger("preUnfixed.ScrollToFixed");if(F==="absolute"){b()}else{l()}H.trigger("unfixed.ScrollToFixed")}}else{if(!q()){p();H.trigger("preFixed.ScrollToFixed");x()}w(J);H.trigger("fixed.ScrollToFixed")}}else{w(J)}}}}}function n(){if(!m.options.bottom){return 0}return m.options.bottom}function p(){var J=H.css("position");if(J=="absolute"){H.trigger("postAbsolute.ScrollToFixed")}else{if(J=="fixed"){H.trigger("postFixed.ScrollToFixed")}else{H.trigger("postUnfixed.ScrollToFixed")}}}var D=function(J){if(H.is(":visible")){c=false;B()}else{l()}};var G=function(J){(!!window.requestAnimationFrame)?requestAnimationFrame(B):B()};var C=function(){var K=document.body;if(document.createElement&&K&&K.appendChild&&K.removeChild){var M=document.createElement("div");if(!M.getBoundingClientRect){return null}M.innerHTML="x";M.style.cssText="position:fixed;top:100px;";K.appendChild(M);var N=K.style.height,O=K.scrollTop;K.style.height="3000px";K.scrollTop=500;var J=M.getBoundingClientRect().top;K.style.height=N;var L=(J===100);K.removeChild(M);K.scrollTop=O;return L}return null};var s=function(J){J=J||window.event;if(J.preventDefault){J.preventDefault()}J.returnValue=false};m.init=function(){m.options=a.extend({},a.ScrollToFixed.defaultOptions,i);z=H.css("z-index");m.$el.css("z-index",m.options.zIndex);u=a("<div />");I=H.css("position");F=H.css("position");k=H.css("float");e=H.css("top");if(h()){m.$el.after(u)}a(window).bind("resize.ScrollToFixed",D);a(window).bind("scroll.ScrollToFixed",G);if("ontouchmove" in window){a(window).bind("touchmove.ScrollToFixed",B)}if(m.options.preFixed){H.bind("preFixed.ScrollToFixed",m.options.preFixed)}if(m.options.postFixed){H.bind("postFixed.ScrollToFixed",m.options.postFixed)}if(m.options.preUnfixed){H.bind("preUnfixed.ScrollToFixed",m.options.preUnfixed)}if(m.options.postUnfixed){H.bind("postUnfixed.ScrollToFixed",m.options.postUnfixed)}if(m.options.preAbsolute){H.bind("preAbsolute.ScrollToFixed",m.options.preAbsolute)}if(m.options.postAbsolute){H.bind("postAbsolute.ScrollToFixed",m.options.postAbsolute)}if(m.options.fixed){H.bind("fixed.ScrollToFixed",m.options.fixed)}if(m.options.unfixed){H.bind("unfixed.ScrollToFixed",m.options.unfixed)}if(m.options.spacerClass){u.addClass(m.options.spacerClass)}H.bind("resize.ScrollToFixed",function(){u.height(H.height())});H.bind("scroll.ScrollToFixed",function(){H.trigger("preUnfixed.ScrollToFixed");l();H.trigger("unfixed.ScrollToFixed");B()});H.bind("detach.ScrollToFixed",function(J){s(J);H.trigger("preUnfixed.ScrollToFixed");l();H.trigger("unfixed.ScrollToFixed");a(window).unbind("resize.ScrollToFixed",D);a(window).unbind("scroll.ScrollToFixed",G);H.unbind(".ScrollToFixed");u.remove();m.$el.removeData("ScrollToFixed")});D()};m.init()};a.ScrollToFixed.defaultOptions={marginTop:0,limit:0,bottom:-1,zIndex:1000,baseClassName:"scroll-to-fixed-fixed"};a.fn.scrollToFixed=function(b){return this.each(function(){(new a.ScrollToFixed(this,b))})}})(jQuery);
/*! npm.im/object-fit-images 3.2.4 */
var objectFitImages=function(){"use strict";function t(t,e){return"data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='"+t+"' height='"+e+"'%3E%3C/svg%3E"}function e(t){if(t.srcset&&!p&&window.picturefill){var e=window.picturefill._;t[e.ns]&&t[e.ns].evaled||e.fillImg(t,{reselect:!0}),t[e.ns].curSrc||(t[e.ns].supported=!1,e.fillImg(t,{reselect:!0})),t.currentSrc=t[e.ns].curSrc||t.src}}function i(t){for(var e,i=getComputedStyle(t).fontFamily,r={};null!==(e=u.exec(i));)r[e[1]]=e[2];return r}function r(e,i,r){var n=t(i||1,r||0);b.call(e,"src")!==n&&h.call(e,"src",n)}function n(t,e){t.naturalWidth?e(t):setTimeout(n,100,t,e)}function c(t){var c=i(t),o=t[l];if(c["object-fit"]=c["object-fit"]||"fill",!o.img){if("fill"===c["object-fit"])return;if(!o.skipTest&&f&&!c["object-position"])return}if(!o.img){o.img=new Image(t.width,t.height),o.img.srcset=b.call(t,"data-ofi-srcset")||t.srcset,o.img.src=b.call(t,"data-ofi-src")||t.src,h.call(t,"data-ofi-src",t.src),t.srcset&&h.call(t,"data-ofi-srcset",t.srcset),r(t,t.naturalWidth||t.width,t.naturalHeight||t.height),t.srcset&&(t.srcset="");try{s(t)}catch(t){window.console&&console.warn("https://bit.ly/ofi-old-browser")}}e(o.img),t.style.backgroundImage='url("'+(o.img.currentSrc||o.img.src).replace(/"/g,'\\"')+'")',t.style.backgroundPosition=c["object-position"]||"center",t.style.backgroundRepeat="no-repeat",t.style.backgroundOrigin="content-box",/scale-down/.test(c["object-fit"])?n(o.img,function(){o.img.naturalWidth>t.width||o.img.naturalHeight>t.height?t.style.backgroundSize="contain":t.style.backgroundSize="auto"}):t.style.backgroundSize=c["object-fit"].replace("none","auto").replace("fill","100% 100%"),n(o.img,function(e){r(t,e.naturalWidth,e.naturalHeight)})}function s(t){var e={get:function(e){return t[l].img[e?e:"src"]},set:function(e,i){return t[l].img[i?i:"src"]=e,h.call(t,"data-ofi-"+i,e),c(t),e}};Object.defineProperty(t,"src",e),Object.defineProperty(t,"currentSrc",{get:function(){return e.get("currentSrc")}}),Object.defineProperty(t,"srcset",{get:function(){return e.get("srcset")},set:function(t){return e.set(t,"srcset")}})}function o(){function t(t,e){return t[l]&&t[l].img&&("src"===e||"srcset"===e)?t[l].img:t}d||(HTMLImageElement.prototype.getAttribute=function(e){return b.call(t(this,e),e)},HTMLImageElement.prototype.setAttribute=function(e,i){return h.call(t(this,e),e,String(i))})}function a(t,e){var i=!y&&!t;if(e=e||{},t=t||"img",d&&!e.skipTest||!m)return!1;"img"===t?t=document.getElementsByTagName("img"):"string"==typeof t?t=document.querySelectorAll(t):"length"in t||(t=[t]);for(var r=0;r<t.length;r++)t[r][l]=t[r][l]||{skipTest:e.skipTest},c(t[r]);i&&(document.body.addEventListener("load",function(t){"IMG"===t.target.tagName&&a(t.target,{skipTest:e.skipTest})},!0),y=!0,t="img"),e.watchMQ&&window.addEventListener("resize",a.bind(null,t,{skipTest:e.skipTest}))}var l="bfred-it:object-fit-images",u=/(object-fit|object-position)\s*:\s*([-.\w\s%]+)/g,g="undefined"==typeof Image?{style:{"object-position":1}}:new Image,f="object-fit"in g.style,d="object-position"in g.style,m="background-size"in g.style,p="string"==typeof g.currentSrc,b=g.getAttribute,h=g.setAttribute,y=!1;return a.supportsObjectFit=f,a.supportsObjectPosition=d,o(),a}();

/*!
 * JsLocalSearch ver: Beta 100
 * https://jelk.net/JsLocalSearch
 *
 * Copyright Carlos López y Ricardo Escanero
 * Released under the MIT license
 * https://jelk.net/JsLocalSearch/license
 *
 * require min jQuery 1.x
 *
 * Date: 2019-07-02
 *
 * Esto sin Bernardo no se podria haber hecho
 */

if (typeof Object.create !== "function") {
    Object.create = function (obj) {
        function F() {
        }
        F.prototype = obj;
        return new F();
    };
}


(function ($, window, document) {

    var JsLocalSearch = {
        init: function (options, el, callback) {

            var my = $(el);
            var base = this;

            if (options === undefined) {
              options = {}
            }

            var searchinput = (options.searchinput === undefined) ? "#gsearchsimple" : options.searchinput;
            options.container = (options.container === undefined) ? "contsearch" : options.container;
            var containersearch = (options.containersearch === undefined) ? "gsearch" : options.containersearch;
            var mincaracteres = (options.mincaracteres === undefined) ? 3 : options.mincaracteres;
            var action = (options.action === undefined) ? "Show" : options.action;
            var info = (options.info === undefined) ? false : options.info;
            options.mark_text = (options.mark_text === undefined) ? false : options.mark_text;
            options.html_search = (options.html_search === undefined) ? true : options.html_search;

            $(el).hide();

            var actionObject = Object.create(eval("Action" + action));

            actionObject.init(options, this)


            $(searchinput).on('keyup', callback , function (event) {

                        event.preventDefault();
                        txt = $(searchinput).val()
                        $('.' + options.container).attr('data-show',0)


                        if (info) {
                            $(el).show();
                        }
                        if ($(searchinput).val().length >= mincaracteres) {
                            actionObject.zero(this)
                            total = 0
                            totalok = 0
                            totalko = 0


                            $("." + options.container).each(function () {
                                visible=false
                                total++
                                $(this).find("." + containersearch).each(function () {
                                if (visible !=true) {

                                    visible=base.busca(options, actionObject, this);
                                }

                            });

                            if (visible == true) {
                                actionObject.ok(this);
                                totalok++
                            } else
                            {
                                actionObject.ko(this);
                                totalko++
                            }

                            });



                            $(el).find('.total').html(total);
                            $(el).find('.number').html(totalok);
                            $(el).find('.numberno').html(totalko);

                        } else {
                            $(el).hide();
                            actionObject.nope();
                            $("." + options.container).find("." + containersearch).each(function () {
                                if (options.mark_text != undefined) {
                                var re = new RegExp('<span class="'+options.mark_text+'">(.*?)<\/span>', "gi");
                                  var str = $(this).html();
                                  var newstr = str.replace(re, "$1");
                              }
                                  $(this).html(newstr);
                            });

                        }


                        if (typeof callback == 'function') { // make sure the callback is a function
                          callback.call(this); // brings the scope to the callback
                        }

                    })


        },

        busca: function (options, actionObject, el) {


            if (options.mark_text != undefined) {
            var re = new RegExp('<span class="'+options.mark_text+'">(.*?)<\/span>', "gi");
            var str = $(el).html();
            var newstr = str.replace(re, "$1");
            $(el).html(newstr);
            }

            search = false;

            if (options.html_search)

                if ($(el).text().normalize('NFD').replace(/([aeio])\u0301|(u)[\u0301\u0308]/gi,"$1$2").normalize().toUpperCase().indexOf(txt.normalize('NFD').replace(/([aeio])\u0301|(u)[\u0301\u0308]/gi,"$1$2").normalize().toUpperCase()) != -1) {
                    search = true;
                    var re = new RegExp("(" + txt + ")", "gi");
                    var str = $(el).text();

                    if (options.mark_text != undefined) {
                    var newstr = str.replace(re, "<span class='"+options.mark_text+"'>$1</span>");
                    }
                    $(el).html(newstr);


                }

            if ($(el).attr('data-description') != undefined && options.description_search) {
                if ($(el).attr('data-description').toUpperCase().indexOf(txt.toUpperCase()) != -1) {
                    search = true;



                }
            }

            if ($(el).attr('data-keywords') != undefined && options.keyword_search) {

                keywords = $(el).attr('data-keywords').toUpperCase().split(",")
                searchKey = txt.toUpperCase().split(" ")


                $.each(keywords, function (index, value) {
                    $.each(searchKey, function (index, key) {
                        if (value == key) {
                            search = true;
                        }
                    });
                });



            }






            return search;
        }
    };

    var ActionShow = {

        init: function (options, el) {
            this.container = options.container;
        },
        zero: function (options, el) {
            $('.' + this.container).hide();
        },
        ok: function (t) {
            $(t).closest('.' + this.container).show();
            $(t).closest('.' + this.container).attr('data-show',1);
        },
        ko: function (t) {
            if ($(t).closest('.' + this.container).attr('show')!=1) {
            $(t).closest('.' + this.container).hide();
        }

        },
        nope: function () {
            $('.' + this.container).show();

        }
    }

    var ActionMark = {

        init: function (options, el) {
            this.container = options.container;
            this.mark = options.actionok;
            this.unmark = options.actionko;
        },
        zero: function (options, el) {
            $('.' + this.container).removeClass(this.mark);
            $('.' + this.container).removeClass(this.unmark);

        },
        ok: function (t) {
            $(t).closest('.' + this.container).removeClass(this.unmark);
            $(t).closest('.' + this.container).addClass(this.mark);
             $(t).closest('.' + this.container).attr('data-show',1);
        },
        ko: function (t) {
            if ($(t).closest('.' + this.container).attr('data-show')!=1) {
                $(t).closest('.' + this.container).removeClass(this.mark);
                $(t).closest('.' + this.container).addClass(this.unmark);
              }

        },
        nope: function () {
            $('.' + this.container).removeClass(this.mark);
            $('.' + this.container).removeClass(this.unmark);

        }
    }


    $.fn.jsLocalSearch = function (options, callback) {
        return this.each(function () {

            var jsLocalSearch = Object.create(JsLocalSearch);
            var actionShow = Object.create(ActionShow);
            jsLocalSearch.init(options, this, callback);

            //     $.data(this, "jsLocalSearch", jsLocalSearch);
        });
    };



}(jQuery, window, document));



/**
 * A11Y functions
 */
(function ($) {
  'use strict';

  var toggleContrast = function () {

    var is_on = localStorage.getItem('contrast');

    if ( is_on == 'true' ) {

      document.body.className = document.body.className.replace(/\bcontrast\b/,'');
      localStorage.removeItem('contrast');
      $('.a11ymodContrast').removeClass('a11ymodContrast--active');

    } else {

      document.body.className += ' contrast';
      localStorage.setItem('contrast', 'true');
      $('.a11ymodContrast').addClass('a11ymodContrast--active');

    }

  };

  var checkContrast = function () {

    var is_on = localStorage.getItem('contrast');

    if ( is_on != 'true' ) {

      document.body.className = document.body.className.replace(/\bcontrast\b/,'');
      localStorage.removeItem('contrast');
      $('.a11ymodContrast').removeClass('a11ymodContrast--active');

    } else {

      document.body.className += ' contrast';
      localStorage.setItem('contrast', 'true');
      $('.a11ymodContrast').addClass('a11ymodContrast--active');

    }

  };

  var init = function () {

    // get contrast preference from localStorage
    checkContrast();

    // modify contrast
    $('.a11ymodContrast').on('click', function () {
      toggleContrast();
      document.body.className = document.body.className.replace('search-active', '');
      $(this).parent().removeClass('active').attr('aria-hidden', true).prev().attr('aria-expanded', false);
    });

    // Close search
    $('.mainsearch-block__close').on('click', function () {
      document.body.className = document.body.className.replace('search-active', '');
      $('.mainsearch-block').removeClass('active').attr('aria-hidden', true).prev().attr('aria-expanded', false);
    });

  };

  init();

}(jQuery));

(function ( w, doc ) {
  // enable strict mode
  'use strict';
  /**
   * Local object for method references
   * and define script meta-data
   */
  var ARIAswitch = {};
  w.ARIAswitch = ARIAswitch;

  ARIAswitch.NS      = 'ARIAswitch';
  ARIAswitch.AUTHOR  = 'Scott O\'Hara';
  ARIAswitch.VERION  = '0.2.0';
  ARIAswitch.LICENSE = 'https://github.com/scottaohara/accessible-components/blob/master/LICENSE.md';

  /**
   * Global Create
   *
   * This function validates that the minimum
   * required markup is present to create the
   * ARIA widget(s). Any additional markup elements
   * or attributes that do not exist in the found
   * required markup patterns will be generated
   * via this function.
   */
  ARIAswitch.create = function () {
    // hooks
    var widget = doc.querySelectorAll('[data-action="aria-switch"]');
    var self;
    var i;
    // define error message here, rather than in the weeds of the code
    var ariaLabelError = 'An attribute of "data-missing-label" has been added to a switch/switches that are missing aria-labelledby or aria-label attributes! Please add unique labels to the appropriate components!';

    // if widgets exist, loop through all instances
    // and set up appropriate attributes
    for ( i = 0; i < widget.length; i++ ) {
      // set this specific widget
      self = widget[i];

      // give each instance the role of switch if the role hasn't been set
      // or if it was set to something else in error
      if ( !self.hasAttribute('role') || self.getAttribute('role') !== 'switch' ) {
        self.setAttribute('role', 'switch');
      }

      // since these sorts of buttons won't work if
      // JavaScript is disabled, (hopefully) a disabled
      // attribute is set to them by default. When JavaScript
      // is on, we should remove the disabled attributes EXCEPT
      // if a switch button is meant to be disabled by default,
      // in which case, look for the data-keep-disabled attribute
      // and DON'T remove that disabled attribute...
      if ( !self.hasAttribute('data-keep-disabled') ) {
        self.removeAttribute('disabled');
      }

      // if an instance doesn't have a set aria-checked attribute,
      // then it must not be checked, so populate an aria-checked='false'
      if ( !self.hasAttribute('aria-checked') ) {
        self.setAttribute('aria-checked', 'false');
      }

      // log an error if an aria-label or labelledby attribute
      // is not found on a switch. also add a 'data-missing-label' attribute
      // to further call out what instance(s) are without appropriate labeling.
      if ( !self.hasAttribute('aria-label') && !self.hasAttribute('aria-labelledby') ) {
        console.warn(ariaLabelError);
      }

      self.addEventListener('click', ARIAswitch.actions);
    } // for(widget.length)
  }; // ARIAswitch.create()



  // primary actions function
  ARIAswitch.actions = function ( e ) {
    e.preventDefault();
    this.setAttribute('aria-checked', e.target.getAttribute('aria-checked') === 'true' ? 'false' : 'true');
  }; // ARIAswitch.events()



  // init function to run start-up functions.
  // if expanding this script, place any other
  // initialize functions within here.
  ARIAswitch.init = function () {
    ARIAswitch.create();
  }; // ARIAswitch.init()



  ARIAswitch.init();

})( window, document );

/**
 * aside blocks position
 */
(function ($) {
  'use strict';

  var $aside = $('.article-aside'),
      $blocks = $('.article-aside .freeblock');


  var asideBlocksInit = function () {
    $blocks.clone().addClass('hidden-md hidden-lg').appendTo($aside.closest('.row')).wrapAll('<div class="col-sm-12"/>');
    $blocks.wrapAll('<div class="hidden-xs hidden-sm"/>');
  };

  asideBlocksInit();


}(jQuery));

/**
 * focus on dropdown links
 */
(function ($) {
  'use strict';

  var onDropdownOpen = function () {

    $(document).on('shown.bs.dropdown', function (event) {

      var $dropdown = $(event.target);

      // Set aria-expanded to true
      $dropdown.find('.dropdown-menu').attr('aria-expanded', true);

      // Set focus on the first link in the dropdown
      setTimeout(function () {
        $dropdown.find('.dropdown-menu li:first-child a').focus();
      }, 10);

    });

  };

  var onDropdownClose = function () {

    $(document).on('hidden.bs.dropdown', function (event) {

      var $dropdown = $(event.target);

      // Set aria-expanded to false
      $dropdown.find('.dropdown-menu').attr('aria-expanded', false);

      // Set focus back to dropdown toggle
      $dropdown.find('.dropdown-toggle').focus();

    });

  };

  var init = function () {

    onDropdownOpen();
    onDropdownClose();

  };

  init();

}(jQuery));

/**
 * form choice for profile
 */
(function($) {
	'use strict';

	var layer = 'choice',
		set1 = 'btn-group--first',
		set2 = 'btn-group--last',
		choiceLink = 'choice-list__link',
		hiddenField = layer + '__field',
		decisionSet = 'decision',
		originBtn = 'decision__button',
		activeBtn = originBtn + '--active',
		disabledBtn = originBtn + '--disabled',
		submitBtn = 'decision__submitbtn',
		activeSubmit = submitBtn + '--active';


	var setMenuChoice = function(e) {
		var el = $(e.currentTarget),
			context = el.closest('.decision__form'),
			selectSet = el.closest('.btn-group'),
			hField = selectSet.find('.' + hiddenField),
			btn = selectSet.find('.' + originBtn),
			choiceId = el.data('choiceid'),
			choiceTxt = el.data('choice');

		btn.html(choiceTxt).addClass(activeBtn); // update button text

		if (selectSet.hasClass(set1)) {

			enableSecondButton(context); // enable second button (remove aria attributes and bootstrap disabled class)

			// if new value is different from value stored in input[type=hidden]
			if (choiceId !== hField.val()) {
				btn.data('selectedChoiceId', choiceId);
				resetSecondChoice(context);
				enableSubmitBtn(el);
			}

		} else if (selectSet.hasClass(set2)) {
			var target = el.data('target');
			context.attr('action', target);
			var base = window.location.protocol + '//' + window.location.host;
			if (!(target.startsWith('/') ||
				  target.startsWith('#') ||
				  target.startsWith('javascript:') ||
				  target.startsWith(base))) {
				context.attr('target', '_blank');
			} else {
				context.removeAttr('target');
			}
		}

		hField.val(choiceId); // update hidden input value

		if (selectSet.hasClass(set2)) {
			enableSubmitBtn(el); // check fields state to enable/disable submit button
		}
	};


	var setChoice = function() {
		$('.' + choiceLink).on('click', function(e) {
			setMenuChoice(e);
		});
	};


	var enableSecondButton = function(context) {

		var $secondButton = $(context).find('.' + set2 + ' .' + originBtn);

		$secondButton.removeClass(disabledBtn + ' disabled').removeAttr('tabindex aria-hidden');

	};

	// unused for the moment, can be handy
	var disableSecondButton = function(context) {

		var $secondButton = $(context).find('.' + set2 + ' .' + originBtn);

		$secondButton.addClass(disabledBtn + ' disabled').attr({'tabindex': '-1', 'aria-hidden': 'true'});

	};


	var resetSecondChoice = function(context) {

		var $secondButton = $(context).find('.' + set2 + ' .' + originBtn),
			secondMenu = $(context).find('.' + set2 + ' .choice-list'),
			initialTxt = $secondButton.data('choice'),
			hField = $(context).find('.' + set2 + ' .' + hiddenField),
			firstBtn = $(context).find('.' + originBtn),
			target = context.data('ams-engine-target') + '/get-menu-options.json';

		$.getJSON(target, {menu: firstBtn.data('selectedChoiceId')}, function(result) {
			secondMenu.empty();
			var suffix = secondMenu.data('suffix') || '';
			for (var index = 0; index < result.length; index++) {
				var item = result[index];
				$('<li></li>').addClass('choice-list__item')
					.append($('<a></a>').attr('class', 'choice-list__link')
										.attr('href', 'javascript:')
										.attr('data-choiceid', item.item_id)
										.attr('data-choice', suffix + ' ' + item.choice)
										.attr('data-target', item.target)
										.text(item.title)
										.on('click', setMenuChoice))
					.appendTo(secondMenu);
			}
			$secondButton.removeClass(activeBtn).html(initialTxt);
			hField.val(0); // update hidden input value
		});
	};


	var enableSubmitBtn = function(el) {

		var $decisionSet = $(el).parents('.' + decisionSet),
			$submitBtn = $decisionSet.find('.' + submitBtn);

		var fcount = $decisionSet.find('.' + hiddenField).filter(function() {
			return +this.value > 0;
		}).length; // return number of hidden inputs filled with a value

		if (fcount > 1) {
			$submitBtn.removeAttr('aria-hidden').addClass(activeSubmit);
		} else {
			$submitBtn.attr('aria-hidden', true).removeClass(activeSubmit);
		}

	};


	var init = function() {
		setChoice();
	};

	init();


}(jQuery));

/**
 * collapse all filters
 */
(function ($) {
  'use strict';

  var filters = 'filters';

  var closeAll = function () {

    $('.' + filters).find('.collapse').collapse('hide');

  };

  $.collapseAllFilters = function () {
    closeAll();
  };

}(jQuery));

/**
 * focus on dropdown links
 */
(function ($) {
  'use strict';

  var $mainSticky       = $('#mainSticky'),
      supHiddenClass    = 'wrapper-sticky--supHidden',
      opaqueHeaderclass = 'wrapper-sticky--fixed',
      lastScrollTop     = 0,
      triggerValue      = 123;

  var throttle = function (func) {
    var wait = arguments.length <= 1 || arguments[1] === undefined ? 100 : arguments[1];
    var timer = null;
    return function () {
      var _this = this;
      for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
        args[_key] = arguments[_key];
      }
      if (timer === null) {
        timer = setTimeout(function () {
          func.apply(_this, args);
          timer = null;
        }, wait);
      }
    };
  };

  // get scroll direction
  var setStickyOptions = function ($this) {

    var st = $this.scrollTop();

    if (st > lastScrollTop) {
      // console.log('downscroll!');
      hideSupHeader(st);
    }
    // } else {
    //   // console.log('upscroll!');
    //   showSupHeader();
    // }

    lastScrollTop = st;

    if (st > triggerValue) {
      $mainSticky.addClass(opaqueHeaderclass);
    } else {
      $mainSticky.removeClass(opaqueHeaderclass);
      showSupHeader();
    }

  };

  // set supheader visibility
  var hideSupHeader = function (st) {
    if (st > triggerValue) {
      $('body').addClass(supHiddenClass);
      $mainSticky.addClass(supHiddenClass);
      $.closeContrastButton();
    }
  };

  var showSupHeader = function () {
    $('body').removeClass(supHiddenClass);
    $mainSticky.removeClass(supHiddenClass);
  };

  var scroller = function () {

    $(window).on('scroll', function () {
      throttle(setStickyOptions($(this)), 1000);
    });

  };

  var scrollFixed = function () {

    $mainSticky.scrollToFixed();

  };

  var init = function () {

    scroller();
    scrollFixed();

  };

  init();

}(jQuery));

/**
 * focus on dropdown links
 */
(function ($) {
  'use strict';

  var immersiveBg = function () {

    if ($('.immersive-section[data-immersive-bg]').length > 0) {
      $('.immersive-section[data-immersive-bg]').each(function () {

        var imgPath = $(this).data('immersive-bg');
        $(this).closest('.slot').addClass('immersive-bg').css('background-image', 'url(' + imgPath + ')');

        if ($(this).data('immersive-offset-bg')) {
          var bgOffset = $(this).data('immersive-offset-bg');
          $(this).closest('.slot').css('background-position', '100% ' + bgOffset + '%');
        }

      })
    }

  };

  var init = function () {

    immersiveBg();

  };

  init();

}(jQuery));

/**
 * « Produits et services » home slider
 */
(function () {
  'use strict';

  var carName = 'home-slider__item';
  var cardActiveName = carName + '--active';
  var cards = document.getElementsByClassName(carName);

  var pixName = 'intro-fade__banner';
  var pix = document.getElementsByClassName(pixName);
  var pixId = 'banner';
  var pixActiveName = 'intro-fade__banner--active';

  var hilightCard = function (el) {
    el.classList.add(cardActiveName);
    var bannerId = el.getAttribute('data-banner');
    document.getElementById(bannerId).classList.add(pixActiveName);
  };

  var switchOffCard = function () {
    for (var i = 0, x = cards.length; i < x; i++) {
      cards[i].classList.remove(cardActiveName);
    }
    for (var j = 0, y = pix.length; j < y; j++) {
      pix[j].classList.remove(pixActiveName);
    }
  };

  var addEvents = function () {
    for (var i = 0, x = cards.length; i < x; i++) {
      cards[i].addEventListener('mouseenter', function () {
        switchOffCard();
        hilightCard(this);
      }, false)
    }
  };

  if (cards) {
    addEvents();
  }

}());

(function (document, window, $, undefined) {
  'use strict';

  // Buttons
  var buttons = document.querySelectorAll('.js-button');

  var closeAll = function (button, content) {

    var excludeCurrent = button;

    [].forEach.call(buttons, function(button, index) {

      if (button != excludeCurrent && excludeCurrent.classList.contains('disablecloseall') == false) {
        var content = button.nextElementSibling;
        content.classList.remove('active');
        button.setAttribute('aria-expanded', 'false');
        content.setAttribute('aria-hidden', 'true');
        document.body.className = document.body.className.replace('search-active', '');
      }

    });
  }

  var displayContent = function (button, content) {

    if (content.classList.contains('active')) {
      // Hide content
      content.classList.remove('active');
      button.setAttribute('aria-expanded', 'false');
      content.setAttribute('aria-hidden', 'true');
      if (button.classList.contains('main-nav__link--search')) {
        document.body.className = document.body.className.replace('search-active', '');
      }
    } else {
      // Show content
      content.classList.add('active');
      button.setAttribute('aria-expanded', 'true');
      content.setAttribute('aria-hidden', 'false');
      if (button.classList.contains('main-nav__link--search')) {
        document.body.className += ' search-active';
      }
    }
  };

  [].forEach.call(buttons, function(button, index) {
    // Content var
    var content = button.nextElementSibling;

    // Set button attributes
    button.setAttribute('id', 'button-' + index);
    button.setAttribute('aria-expanded', 'false');
    button.setAttribute('aria-controls', 'content-' + index);

    // Set content attributes
    content.setAttribute('id', 'content-' + index);
    content.setAttribute('aria-hidden', 'true');
    content.setAttribute('aria-labelledby', 'button-' + index);

    button.addEventListener('click', function () {
      closeAll(this, content);
      displayContent(this, content);
      return false;
    }, false);

    button.addEventListener('keydown', function (event) {
      // Handle 'space' key
      if (event.which === 32) {
        event.preventDefault();
        closeAll(this, content);
        displayContent(this, content);
      }
    }, false);

  });

  $.closeContrastButton = function () {
    var contrastButton = document.querySelector('.supheader__link.js-button');
    var contrastContent = contrastButton.nextElementSibling;
    contrastContent.classList.remove('active');
    contrastButton.setAttribute('aria-expanded', 'false');
    contrastContent.setAttribute('aria-hidden', 'true');
    document.body.className = document.body.className.replace('search-active', '');
  };

})(document, window, jQuery);

/**
 * mobile accordion menu
 */
(function ($) {
  'use strict';

  var $hamburger = $('#mainMenuButton'),
      $mainNav   = $('#menu-principal'),
      $mainList  = $('.sidemobilemenu .main-nav__list'),
      mainLinks  = '.main-nav__link',
      $body      = $('body'),
      $overlay   = $('.global-overlay');

  var openCloseMainMenu = function () {
    $hamburger.on('click', function (event) {

      event.preventDefault();

      var $current = $(event.currentTarget),
      freezeOption = $current.data('scroll');

      $current.toggleClass('active');
      $mainNav.toggleClass('active');
      $body.toggleClass('active-mobileflap');


      if (freezeOption === 'noscroll' && $mainNav.hasClass('active')) {
        $body.addClass('noscrollmobile');
      } else {
        $body.removeClass('noscrollmobile');
      }

    });
  };

  var bindClose = function () {
    $overlay.on('click', function (event) {
      closeAll();
    });
  };

  var closeAll = function () {
    $hamburger.removeClass('active');
    $mainNav.removeClass('active');
    $body.removeClass('noscrollmobile active-mobileflap');
  };

  var resetEventMainMenu = function () {
    $hamburger.off();
    $mainList.off();
    $hamburger.removeClass('active');
    $mainNav.removeClass('active');
    $body.removeClass('noscrollmobile active-mobileflap');
  };

  var insideAccordion = function () {

    $mainList.on('click', mainLinks, function (event) {

      event.preventDefault();

      var $current = $(event.currentTarget);

      $mainList.find('.submenu').removeClass('active');
      $current.next().toggleClass('active');
      //$('.main-menu__list > li:not(.main-nav__item--search) > ul').not($current.next()).removeClass('active');

    });

  };

  $.mobileAccordionMenuInit = function () {
    openCloseMainMenu();
    insideAccordion();
    bindClose();
  };

  $.mobileAccordionMenuReset = function () {
    resetEventMainMenu();
  };

  $.mobileAccordionMenuInit();


}(jQuery));

/**
 * hovering a link in a card modify parent style
 */
(function ($) {
  'use strict';

     var card = 'result',
  activeClass = '--active';

  var init = function () {

    $('.' + card).on({
      mouseenter: function () {
        $(this).closest('.' + card).addClass(card + activeClass);
      },
      mouseleave: function () {
        $(this).closest('.' + card).removeClass(card + activeClass);
      }
    }, 'a.' + card + '__pic, a.' + card + '__body');

  };

  init();

}(jQuery));

/**
 * return top button
 */
(function ($) {
  'use strict';

  var $links = $('a[href="#top"], a[href="#debut"]');

  $links.on('click', function () {
    $('html, body').animate({scrollTop: 0}, 500);
  });

}(jQuery));

/**
 * bootstrap dropdown used to control accessible tabs
 */
(function ($) {
  'use strict';

  var ddown = '.dropdown-control-tabs',
  offsetForMenu = 150;

  var ddownAction = function () {
    $(ddown).on('click', '.js-link-to-tab', function () {

      var $this = $(this),
      thisText = $this.html(),
      el = $this.closest(ddown),
      $sel = el.find('button'),
      elTop = $(el).offset().top;

      $sel.text(thisText);
      $('html, body').animate({scrollTop: (elTop - offsetForMenu)}, 500);

    });
  };

  $.selector2TabsInit = function () {
    ddownAction();
  };

  $.selector2TabsInit();

}(jQuery));

/**
 * smooth scroll on return top
 */
(function ($) {
  'use strict';

  var link = $('a[href="#top"]');

  var init = function () {

    link.on('click', function (e) {
      e.preventDefault();
      $('html, body').animate({scrollTop: 0}, 500);
    });

  };

  init();

}(jQuery));

/**
 * open/close main menu
 */
(function ($) {
  'use strict';

  var $trigger = $('a[data-target]:not([data-toggle])'),
        $flaps = $('.hidden-block'),
         $body = $('body'),
     $document = $(document);

  var initButtons = function () {

    $trigger.on('click', function (event) {

      // event.preventDefault();

      var $current = $(event.currentTarget),
          $flap = $($current.data('target')),
      freezeOption = $current.data('scroll');

      $current.toggleClass('active');
      $current.parent().toggleClass('active');
      $flap.toggleClass('active');
      $body.addClass('active-flap');

      closeOthers($current);

      if (freezeOption === 'noscroll' && $flap.hasClass('active')) {
        $body.addClass('noscroll');
      }

      if ($flap.hasClass('active')) {
        $body.addClass('active-flap');
      } else {
        $body.removeClass('active-flap');
      }

    });

  };

  var attachCloseEvents = function () {

    $document.on('click', function (event) {

      var $component = $trigger.add($flaps);

      if (!$(event.target).closest($component).length) {
        closeAll();
      }

    });

  };

  var closeAll = function () {

    $flaps.removeClass('active');
    $trigger.removeClass('active');
    $trigger.parent().removeClass('active');
    $body.removeClass('noscroll active-flap');

  };

  var closeOthers = function (currentElement) {

    var $flap = $(currentElement.data('target'));

    $body.removeClass('noscroll');
    $flaps.not($flap).removeClass('active');
    $trigger.not(currentElement).removeClass('active');
    $trigger.not(currentElement).parent().removeClass('active');

  };

  var init = function () {

    initButtons();
    attachCloseEvents();
    $flaps.removeClass('active');

  };

  var reset = function () {
    closeAll();
    $trigger.off();
  };

  init();

}(jQuery));

// jshint asi:false
/* global ResponsiveBootstrapToolkit, lity, objectFitImages */
// jshint devel:true
// jshint unused:false


(function (doc) {
  'use strict';
  var iconPath = doc.getElementById('iconPath').dataset.path;
  var scripts = doc.getElementsByTagName('script');
  var script = scripts[scripts.length - 1];
  var xhr = new XMLHttpRequest();
  xhr.onload = function () {
    var div = doc.createElement('div');
    div.innerHTML = this.responseText;
    div.style.width = 0;
    div.style.height = 0;
    div.classList.add('visually-hidden');
    div.setAttribute('aria-hidden', true);
    script.parentNode.insertBefore(div, script);
  };
  xhr.open('get', iconPath, true);
  xhr.send();
}(document));



// DOM loaded and ready
// --------------------------------------------------
$(function() {
  'use strict';

  document.documentElement.className = document.documentElement.className.replace(/\bno-js\b/, '');

  var touchDevice = navigator.maxTouchPoints || 'ontouchstart' in document.documentElement;
  if (touchDevice) {
    document.documentElement.className += ' touchDevice';
  } else {
    document.documentElement.className += ' noTouchDevice';
  }

  // object-fit polyfill: https://github.com/fregante/object-fit-images
  objectFitImages();

  // search Parcours Forêts
  if (document.getElementById('localSearchParcours')) {
    $('#localSearchParcours').jsLocalSearch({
      'amincaracteres': 3,
      'searchinput': '#searchParcoursForets',
      'container': 'contsearch',
      'containersearch': 'gsearch'
    });
  }

  // lity template option
  jQuery(function() {
    lity.options('template', '<div class="lity" role="dialog" aria-label="Fenêtre de dialogue (Appuyez Échap pour fermer)" tabindex="-1"><div class="lity-wrap" data-lity-close role="document"><div class="lity-loader" aria-hidden="true">Chargement…</div><div class="lity-container"><div class="lity-content"></div><button class="lity-close" type="button" aria-label="Fermer (Appuyez Échap pour fermer)" data-lity-close>&times;</button></div></div></div>');
  });

  jQuery('input[type="file"]').each(function() {
    var $input = $(this),
      $label = $input.next('label'),
      labelVal = $label.html();

    $input.on('change', function(e) {
      var fileName = '';

      if (this.files && this.files.length > 1)
        fileName = (this.getAttribute('data-multiple-caption') || '').replace(
          '{count}',
          this.files.length
        );
      else if (e.target.value) fileName = e.target.value.split('\\').pop();

      if (fileName) $label.find('span').html(fileName);
      else $label.html(labelVal);
    });

    // Firefox bug fix
    $input
      .on('focus', function() {
        $input.addClass('has-focus');
      })
      .on('blur', function() {
        $input.removeClass('has-focus');
      });
  });

  jQuery('.owl-drag').on('click', '.linkedin-card', function () {
    jQuery(this).addClass('clickable');
  });

});





// DOM is ready + ResponsiveBootstrapToolkit
// --------------------------------------------------
(function($, viewport) {
  'use strict';

  $(document).ready(function() {
    // Executes only in XS + SM breakpoints
    if (viewport.is('<md')) {
      jQuery('body').addClass('sidemobilemenu');
      $.mobileAccordionMenuReset();
      $.mobileAccordionMenuInit();
      $.collapseAllFilters();
    } else {
      jQuery('body').removeClass('sidemobilemenu');
      $.mobileAccordionMenuReset();
    }
  }, 150);

  $(window).resize(
    viewport.changed(function() {
      if (document.activeElement.closest('.main-search-form')) {
        return;
      }
      if (viewport.is('<md')) {
        jQuery('body').addClass('sidemobilemenu');
        $.mobileAccordionMenuReset();
        $.mobileAccordionMenuInit();
        // $.collapseAllFilters();
      } else {
        jQuery('body').removeClass('sidemobilemenu');
        $.mobileAccordionMenuReset();
      }
    }, 150)
  );
})(jQuery, ResponsiveBootstrapToolkit);

/**
 * onload
 */
window.addEventListener('load', function () {
  'use strict';
  document.documentElement.classList.remove('pageload');
}, false);
