/**
 * onf v1.0.0 (http://proto.smartagence.com/onf/)
 * Copyright 2004-2023 Smart Agence <gilles@smartagence.com>
 */
/* ========================================================================
 * Bootstrap: collapse.js v3.4.1
 * https://getbootstrap.com/docs/3.4/javascript/#collapse
 * ========================================================================
 * Copyright 2011-2019 Twitter, Inc.
 * Licensed under MIT (https://github.com/twbs/bootstrap/blob/master/LICENSE)
 * ======================================================================== */

/* jshint latedef: false */

+function ($) {
  'use strict';

  // COLLAPSE PUBLIC CLASS DEFINITION
  // ================================

  var Collapse = function (element, options) {
    this.$element      = $(element)
    this.options       = $.extend({}, Collapse.DEFAULTS, options)
    this.$trigger      = $('[data-toggle="collapse"][href="#' + element.id + '"],' +
                           '[data-toggle="collapse"][data-target="#' + element.id + '"]')
    this.transitioning = null

    if (this.options.parent) {
      this.$parent = this.getParent()
    } else {
      this.addAriaAndCollapsedClass(this.$element, this.$trigger)
    }

    if (this.options.toggle) this.toggle()
  }

  Collapse.VERSION  = '3.4.1'

  Collapse.TRANSITION_DURATION = 350

  Collapse.DEFAULTS = {
    toggle: true
  }

  Collapse.prototype.dimension = function () {
    var hasWidth = this.$element.hasClass('width')
    return hasWidth ? 'width' : 'height'
  }

  Collapse.prototype.show = function () {
    if (this.transitioning || this.$element.hasClass('in')) return

    var activesData
    var actives = this.$parent && this.$parent.children('.panel').children('.in, .collapsing')

    if (actives && actives.length) {
      activesData = actives.data('bs.collapse')
      if (activesData && activesData.transitioning) return
    }

    var startEvent = $.Event('show.bs.collapse')
    this.$element.trigger(startEvent)
    if (startEvent.isDefaultPrevented()) return

    if (actives && actives.length) {
      Plugin.call(actives, 'hide')
      activesData || actives.data('bs.collapse', null)
    }

    var dimension = this.dimension()

    this.$element
      .removeClass('collapse')
      .addClass('collapsing')[dimension](0)
      .attr('aria-expanded', true)

    this.$trigger
      .removeClass('collapsed')
      .attr('aria-expanded', true)

    this.transitioning = 1

    var complete = function () {
      this.$element
        .removeClass('collapsing')
        .addClass('collapse in')[dimension]('')
      this.transitioning = 0
      this.$element
        .trigger('shown.bs.collapse')
    }

    if (!$.support.transition) return complete.call(this)

    var scrollSize = $.camelCase(['scroll', dimension].join('-'))

    this.$element
      .one('bsTransitionEnd', $.proxy(complete, this))
      .emulateTransitionEnd(Collapse.TRANSITION_DURATION)[dimension](this.$element[0][scrollSize])
  }

  Collapse.prototype.hide = function () {
    if (this.transitioning || !this.$element.hasClass('in')) return

    var startEvent = $.Event('hide.bs.collapse')
    this.$element.trigger(startEvent)
    if (startEvent.isDefaultPrevented()) return

    var dimension = this.dimension()

    this.$element[dimension](this.$element[dimension]())[0].offsetHeight

    this.$element
      .addClass('collapsing')
      .removeClass('collapse in')
      .attr('aria-expanded', false)

    this.$trigger
      .addClass('collapsed')
      .attr('aria-expanded', false)

    this.transitioning = 1

    var complete = function () {
      this.transitioning = 0
      this.$element
        .removeClass('collapsing')
        .addClass('collapse')
        .trigger('hidden.bs.collapse')
    }

    if (!$.support.transition) return complete.call(this)

    this.$element
      [dimension](0)
      .one('bsTransitionEnd', $.proxy(complete, this))
      .emulateTransitionEnd(Collapse.TRANSITION_DURATION)
  }

  Collapse.prototype.toggle = function () {
    this[this.$element.hasClass('in') ? 'hide' : 'show']()
  }

  Collapse.prototype.getParent = function () {
    return $(document).find(this.options.parent)
      .find('[data-toggle="collapse"][data-parent="' + this.options.parent + '"]')
      .each($.proxy(function (i, element) {
        var $element = $(element)
        this.addAriaAndCollapsedClass(getTargetFromTrigger($element), $element)
      }, this))
      .end()
  }

  Collapse.prototype.addAriaAndCollapsedClass = function ($element, $trigger) {
    var isOpen = $element.hasClass('in')

    $element.attr('aria-expanded', isOpen)
    $trigger
      .toggleClass('collapsed', !isOpen)
      .attr('aria-expanded', isOpen)
  }

  function getTargetFromTrigger($trigger) {
    var href
    var target = $trigger.attr('data-target')
      || (href = $trigger.attr('href')) && href.replace(/.*(?=#[^\s]+$)/, '') // strip for ie7

    return $(document).find(target)
  }


  // COLLAPSE PLUGIN DEFINITION
  // ==========================

  function Plugin(option) {
    return this.each(function () {
      var $this   = $(this)
      var data    = $this.data('bs.collapse')
      var options = $.extend({}, Collapse.DEFAULTS, $this.data(), typeof option == 'object' && option)

      if (!data && options.toggle && /show|hide/.test(option)) options.toggle = false
      if (!data) $this.data('bs.collapse', (data = new Collapse(this, options)))
      if (typeof option == 'string') data[option]()
    })
  }

  var old = $.fn.collapse

  $.fn.collapse             = Plugin
  $.fn.collapse.Constructor = Collapse


  // COLLAPSE NO CONFLICT
  // ====================

  $.fn.collapse.noConflict = function () {
    $.fn.collapse = old
    return this
  }


  // COLLAPSE DATA-API
  // =================

  $(document).on('click.bs.collapse.data-api', '[data-toggle="collapse"]', function (e) {
    var $this   = $(this)

    if (!$this.attr('data-target')) e.preventDefault()

    var $target = getTargetFromTrigger($this)
    var data    = $target.data('bs.collapse')
    var option  = data ? 'toggle' : $this.data()

    Plugin.call($target, option)
  })

}(jQuery);

/* ========================================================================
 * Bootstrap: dropdown.js v3.4.1
 * https://getbootstrap.com/docs/3.4/javascript/#dropdowns
 * ========================================================================
 * Copyright 2011-2019 Twitter, Inc.
 * Licensed under MIT (https://github.com/twbs/bootstrap/blob/master/LICENSE)
 * ======================================================================== */


+function ($) {
  'use strict';

  // DROPDOWN CLASS DEFINITION
  // =========================

  var backdrop = '.dropdown-backdrop'
  var toggle   = '[data-toggle="dropdown"]'
  var Dropdown = function (element) {
    $(element).on('click.bs.dropdown', this.toggle)
  }

  Dropdown.VERSION = '3.4.1'

  function getParent($this) {
    var selector = $this.attr('data-target')

    if (!selector) {
      selector = $this.attr('href')
      selector = selector && /#[A-Za-z]/.test(selector) && selector.replace(/.*(?=#[^\s]*$)/, '') // strip for ie7
    }

    var $parent = selector !== '#' ? $(document).find(selector) : null

    return $parent && $parent.length ? $parent : $this.parent()
  }

  function clearMenus(e) {
    if (e && e.which === 3) return
    $(backdrop).remove()
    $(toggle).each(function () {
      var $this         = $(this)
      var $parent       = getParent($this)
      var relatedTarget = { relatedTarget: this }

      if (!$parent.hasClass('open')) return

      if (e && e.type == 'click' && /input|textarea/i.test(e.target.tagName) && $.contains($parent[0], e.target)) return

      $parent.trigger(e = $.Event('hide.bs.dropdown', relatedTarget))

      if (e.isDefaultPrevented()) return

      $this.attr('aria-expanded', 'false')
      $parent.removeClass('open').trigger($.Event('hidden.bs.dropdown', relatedTarget))
    })
  }

  Dropdown.prototype.toggle = function (e) {
    var $this = $(this)

    if ($this.is('.disabled, :disabled')) return

    var $parent  = getParent($this)
    var isActive = $parent.hasClass('open')

    clearMenus()

    if (!isActive) {
      if ('ontouchstart' in document.documentElement && !$parent.closest('.navbar-nav').length) {
        // if mobile we use a backdrop because click events don't delegate
        $(document.createElement('div'))
          .addClass('dropdown-backdrop')
          .insertAfter($(this))
          .on('click', clearMenus)
      }

      var relatedTarget = { relatedTarget: this }
      $parent.trigger(e = $.Event('show.bs.dropdown', relatedTarget))

      if (e.isDefaultPrevented()) return

      $this
        .trigger('focus')
        .attr('aria-expanded', 'true')

      $parent
        .toggleClass('open')
        .trigger($.Event('shown.bs.dropdown', relatedTarget))
    }

    return false
  }

  Dropdown.prototype.keydown = function (e) {
    if (!/(38|40|27|32)/.test(e.which) || /input|textarea/i.test(e.target.tagName)) return

    var $this = $(this)

    e.preventDefault()
    e.stopPropagation()

    if ($this.is('.disabled, :disabled')) return

    var $parent  = getParent($this)
    var isActive = $parent.hasClass('open')

    if (!isActive && e.which != 27 || isActive && e.which == 27) {
      if (e.which == 27) $parent.find(toggle).trigger('focus')
      return $this.trigger('click')
    }

    var desc = ' li:not(.disabled):visible a'
    var $items = $parent.find('.dropdown-menu' + desc)

    if (!$items.length) return

    var index = $items.index(e.target)

    if (e.which == 38 && index > 0)                 index--         // up
    if (e.which == 40 && index < $items.length - 1) index++         // down
    if (!~index)                                    index = 0

    $items.eq(index).trigger('focus')
  }


  // DROPDOWN PLUGIN DEFINITION
  // ==========================

  function Plugin(option) {
    return this.each(function () {
      var $this = $(this)
      var data  = $this.data('bs.dropdown')

      if (!data) $this.data('bs.dropdown', (data = new Dropdown(this)))
      if (typeof option == 'string') data[option].call($this)
    })
  }

  var old = $.fn.dropdown

  $.fn.dropdown             = Plugin
  $.fn.dropdown.Constructor = Dropdown


  // DROPDOWN NO CONFLICT
  // ====================

  $.fn.dropdown.noConflict = function () {
    $.fn.dropdown = old
    return this
  }


  // APPLY TO STANDARD DROPDOWN ELEMENTS
  // ===================================

  $(document)
    .on('click.bs.dropdown.data-api', clearMenus)
    .on('click.bs.dropdown.data-api', '.dropdown form', function (e) { e.stopPropagation() })
    .on('click.bs.dropdown.data-api', toggle, Dropdown.prototype.toggle)
    .on('keydown.bs.dropdown.data-api', toggle, Dropdown.prototype.keydown)
    .on('keydown.bs.dropdown.data-api', '.dropdown-menu', Dropdown.prototype.keydown)

}(jQuery);

/* ========================================================================
 * Bootstrap: transition.js v3.4.1
 * https://getbootstrap.com/docs/3.4/javascript/#transitions
 * ========================================================================
 * Copyright 2011-2019 Twitter, Inc.
 * Licensed under MIT (https://github.com/twbs/bootstrap/blob/master/LICENSE)
 * ======================================================================== */


+function ($) {
  'use strict';

  // CSS TRANSITION SUPPORT (Shoutout: https://modernizr.com/)
  // ============================================================

  function transitionEnd() {
    var el = document.createElement('bootstrap')

    var transEndEventNames = {
      WebkitTransition : 'webkitTransitionEnd',
      MozTransition    : 'transitionend',
      OTransition      : 'oTransitionEnd otransitionend',
      transition       : 'transitionend'
    }

    for (var name in transEndEventNames) {
      if (el.style[name] !== undefined) {
        return { end: transEndEventNames[name] }
      }
    }

    return false // explicit for ie8 (  ._.)
  }

  // https://blog.alexmaccaw.com/css-transitions
  $.fn.emulateTransitionEnd = function (duration) {
    var called = false
    var $el = this
    $(this).one('bsTransitionEnd', function () { called = true })
    var callback = function () { if (!called) $($el).trigger($.support.transition.end) }
    setTimeout(callback, duration)
    return this
  }

  $(function () {
    $.support.transition = transitionEnd()

    if (!$.support.transition) return

    $.event.special.bsTransitionEnd = {
      bindType: $.support.transition.end,
      delegateType: $.support.transition.end,
      handle: function (e) {
        if ($(e.target).is(this)) return e.handleObj.handler.apply(this, arguments)
      }
    }
  })

}(jQuery);

/*!
 * Responsive Bootstrap Toolkit
 * Author:    Maciej Gurban
 * License:   MIT
 * Version:   2.6.3 (2016-06-21)
 * Origin:    https://github.com/maciej-gurban/responsive-bootstrap-toolkit
 */
var ResponsiveBootstrapToolkit=function(i){var e={detectionDivs:{bootstrap:{xs:i('<div class="device-xs visible-xs visible-xs-block"></div>'),sm:i('<div class="device-sm visible-sm visible-sm-block"></div>'),md:i('<div class="device-md visible-md visible-md-block"></div>'),lg:i('<div class="device-lg visible-lg visible-lg-block"></div>')},foundation:{small:i('<div class="device-xs show-for-small-only"></div>'),medium:i('<div class="device-sm show-for-medium-only"></div>'),large:i('<div class="device-md show-for-large-only"></div>'),xlarge:i('<div class="device-lg show-for-xlarge-only"></div>')}},applyDetectionDivs:function(){i(document).ready(function(){i.each(o.breakpoints,function(i){o.breakpoints[i].appendTo(".responsive-bootstrap-toolkit")})})},isAnExpression:function(i){return"<"==i.charAt(0)||">"==i.charAt(0)},splitExpression:function(i){var e=i.charAt(0),o="="==i.charAt(1),s=1+(o?1:0),n=i.slice(s);return{operator:e,orEqual:o,breakpointName:n}},isAnyActive:function(e){var s=!1;return i.each(e,function(i,e){return o.breakpoints[e].is(":visible")?(s=!0,!1):void 0}),s},isMatchingExpression:function(i){var s=e.splitExpression(i),n=Object.keys(o.breakpoints),r=n.indexOf(s.breakpointName);if(-1!==r){var t=0,a=0;"<"==s.operator&&(t=0,a=s.orEqual?++r:r),">"==s.operator&&(t=s.orEqual?r:++r,a=void 0);var l=n.slice(t,a);return e.isAnyActive(l)}}},o={interval:300,framework:null,breakpoints:null,is:function(i){return e.isAnExpression(i)?e.isMatchingExpression(i):o.breakpoints[i]&&o.breakpoints[i].is(":visible")},use:function(i,s){o.framework=i.toLowerCase(),"bootstrap"===o.framework||"foundation"===o.framework?o.breakpoints=e.detectionDivs[o.framework]:o.breakpoints=s,e.applyDetectionDivs()},current:function(){var e="unrecognized";return i.each(o.breakpoints,function(i){o.is(i)&&(e=i)}),e},changed:function(i,e){var s;return function(){clearTimeout(s),s=setTimeout(function(){i()},e||o.interval)}}};return i(document).ready(function(){i('<div class="responsive-bootstrap-toolkit"></div>').appendTo("body")}),null===o.framework&&o.use("bootstrap"),o}(jQuery);"undefined"!=typeof module&&module.exports&&(module.exports=ResponsiveBootstrapToolkit);
/*! Lity - v2.4.1 - 2020-04-26
* http://sorgalla.com/lity/
* Copyright (c) 2015-2020 Jan Sorgalla; Licensed MIT */

!function(a,b){"function"==typeof define&&define.amd?define(["jquery"],function(c){return b(a,c)}):"object"==typeof module&&"object"==typeof module.exports?module.exports=b(a,require("jquery")):a.lity=b(a,a.jQuery||a.Zepto)}("undefined"!=typeof window?window:this,function(a,b){"use strict";function c(a){var b=B();return N&&a.length?(a.one(N,b.resolve),setTimeout(b.resolve,500)):b.resolve(),b.promise()}function d(a,c,d){if(1===arguments.length)return b.extend({},a);if("string"==typeof c){if(void 0===d)return void 0===a[c]?null:a[c];a[c]=d}else b.extend(a,c);return this}function e(a){for(var b,c=decodeURI(a.split("#")[0]).split("&"),d={},e=0,f=c.length;e<f;e++)c[e]&&(b=c[e].split("="),d[b[0]]=b[1]);return d}function f(a,c){return a+(a.indexOf("?")>-1?"&":"?")+b.param(c)}function g(a,b){var c=a.indexOf("#");return-1===c?b:(c>0&&(a=a.substr(c)),b+a)}function h(a){return b('<span class="lity-error"></span>').append(a)}function i(a,c){var d=c.opener()&&c.opener().data("lity-desc")||"Image with no description",e=b('<img src="'+a+'" alt="'+d+'"/>'),f=B(),g=function(){f.reject(h("Failed loading image"))};return e.on("load",function(){if(0===this.naturalWidth)return g();f.resolve(e)}).on("error",g),f.promise()}function j(a,c){var d,e,f;try{d=b(a)}catch(a){return!1}return!!d.length&&(e=b('<i style="display:none !important"></i>'),f=d.hasClass("lity-hide"),c.element().one("lity:remove",function(){e.before(d).remove(),f&&!d.closest(".lity-content").length&&d.addClass("lity-hide")}),d.removeClass("lity-hide").after(e))}function k(a){var c=J.exec(a);return!!c&&o(g(a,f("https://www.youtube"+(c[2]||"")+".com/embed/"+c[4],b.extend({autoplay:1},e(c[5]||"")))))}function l(a){var c=K.exec(a);return!!c&&o(g(a,f("https://player.vimeo.com/video/"+c[3],b.extend({autoplay:1},e(c[4]||"")))))}function m(a){var c=M.exec(a);return!!c&&(0!==a.indexOf("http")&&(a="https:"+a),o(g(a,f("https://www.facebook.com/plugins/video.php?href="+a,b.extend({autoplay:1},e(c[4]||""))))))}function n(a){var b=L.exec(a);return!!b&&o(g(a,f("https://www.google."+b[3]+"/maps?"+b[6],{output:b[6].indexOf("layer=c")>0?"svembed":"embed"})))}function o(a){return'<div class="lity-iframe-container"><iframe frameborder="0" allowfullscreen allow="autoplay; fullscreen" src="'+a+'"/></div>'}function p(){return z.documentElement.clientHeight?z.documentElement.clientHeight:Math.round(A.height())}function q(a){var b=v();b&&(27===a.keyCode&&b.options("esc")&&b.close(),9===a.keyCode&&r(a,b))}function r(a,b){var c=b.element().find(G),d=c.index(z.activeElement);a.shiftKey&&d<=0?(c.get(c.length-1).focus(),a.preventDefault()):a.shiftKey||d!==c.length-1||(c.get(0).focus(),a.preventDefault())}function s(){b.each(D,function(a,b){b.resize()})}function t(a){1===D.unshift(a)&&(C.addClass("lity-active"),A.on({resize:s,keydown:q})),b("body > *").not(a.element()).addClass("lity-hidden").each(function(){var a=b(this);void 0===a.data(F)&&a.data(F,a.attr(E)||null)}).attr(E,"true")}function u(a){var c;a.element().attr(E,"true"),1===D.length&&(C.removeClass("lity-active"),A.off({resize:s,keydown:q})),D=b.grep(D,function(b){return a!==b}),c=D.length?D[0].element():b(".lity-hidden"),c.removeClass("lity-hidden").each(function(){var a=b(this),c=a.data(F);c?a.attr(E,c):a.removeAttr(E),a.removeData(F)})}function v(){return 0===D.length?null:D[0]}function w(a,c,d,e){var f,g="inline",h=b.extend({},d);return e&&h[e]?(f=h[e](a,c),g=e):(b.each(["inline","iframe"],function(a,b){delete h[b],h[b]=d[b]}),b.each(h,function(b,d){return!d||(!(!d.test||d.test(a,c))||(f=d(a,c),!1!==f?(g=b,!1):void 0))})),{handler:g,content:f||""}}function x(a,e,f,g){function h(a){k=b(a).css("max-height",p()+"px"),j.find(".lity-loader").each(function(){var a=b(this);c(a).always(function(){a.remove()})}),j.removeClass("lity-loading").find(".lity-content").empty().append(k),m=!0,k.trigger("lity:ready",[l])}var i,j,k,l=this,m=!1,n=!1;e=b.extend({},H,e),j=b(e.template),l.element=function(){return j},l.opener=function(){return f},l.options=b.proxy(d,l,e),l.handlers=b.proxy(d,l,e.handlers),l.resize=function(){m&&!n&&k.css("max-height",p()+"px").trigger("lity:resize",[l])},l.close=function(){if(m&&!n){n=!0,u(l);var a=B();if(g&&(z.activeElement===j[0]||b.contains(j[0],z.activeElement)))try{g.focus()}catch(a){}return k.trigger("lity:close",[l]),j.removeClass("lity-opened").addClass("lity-closed"),c(k.add(j)).always(function(){k.trigger("lity:remove",[l]),j.remove(),j=void 0,a.resolve()}),a.promise()}},i=w(a,l,e.handlers,e.handler),j.attr(E,"false").addClass("lity-loading lity-opened lity-"+i.handler).appendTo("body").focus().on("click","[data-lity-close]",function(a){b(a.target).is("[data-lity-close]")&&l.close()}).trigger("lity:open",[l]),t(l),b.when(i.content).always(h)}function y(a,c,d){a.preventDefault?(a.preventDefault(),d=b(this),a=d.data("lity-target")||d.attr("href")||d.attr("src")):d=b(d);var e=new x(a,b.extend({},d.data("lity-options")||d.data("lity"),c),d,z.activeElement);if(!a.preventDefault)return e}var z=a.document,A=b(a),B=b.Deferred,C=b("html"),D=[],E="aria-hidden",F="lity-"+E,G='a[href],area[href],input:not([disabled]),select:not([disabled]),textarea:not([disabled]),button:not([disabled]),iframe,object,embed,[contenteditable],[tabindex]:not([tabindex^="-"])',H={esc:!0,handler:null,handlers:{image:i,inline:j,youtube:k,vimeo:l,googlemaps:n,facebookvideo:m,iframe:o},template:'<div class="lity" role="dialog" aria-label="Dialog Window (Press escape to close)" tabindex="-1"><div class="lity-wrap" data-lity-close role="document"><div class="lity-loader" aria-hidden="true">Loading...</div><div class="lity-container"><div class="lity-content"></div><button class="lity-close" type="button" aria-label="Close (Press escape to close)" data-lity-close>&times;</button></div></div></div>'},I=/(^data:image\/)|(\.(png|jpe?g|gif|svg|webp|bmp|ico|tiff?)(\?\S*)?$)/i,J=/(youtube(-nocookie)?\.com|youtu\.be)\/(watch\?v=|v\/|u\/|embed\/?)?([\w-]{11})(.*)?/i,K=/(vimeo(pro)?.com)\/(?:[^\d]+)?(\d+)\??(.*)?$/,L=/((maps|www)\.)?google\.([^\/\?]+)\/?((maps\/?)?\?)(.*)/i,M=/(facebook\.com)\/([a-z0-9_-]*)\/videos\/([0-9]*)(.*)?$/i,N=function(){var a=z.createElement("div"),b={WebkitTransition:"webkitTransitionEnd",MozTransition:"transitionend",OTransition:"oTransitionEnd otransitionend",transition:"transitionend"};for(var c in b)if(void 0!==a.style[c])return b[c];return!1}();return i.test=function(a){return I.test(a)},y.version="2.4.1",y.options=b.proxy(d,y,H),y.handlers=b.proxy(d,y,H.handlers),y.current=v,b(z).on("click.lity","[data-lity]",y),y});
(function(a){a.isScrollToFixed=function(b){return !!a(b).data("ScrollToFixed")};a.ScrollToFixed=function(d,i){var m=this;m.$el=a(d);m.el=d;m.$el.data("ScrollToFixed",m);var c=false;var H=m.$el;var I;var F;var k;var e;var z;var E=0;var r=0;var j=-1;var f=-1;var u=null;var A;var g;function v(){H.trigger("preUnfixed.ScrollToFixed");l();H.trigger("unfixed.ScrollToFixed");f=-1;E=H.offset().top;r=H.offset().left;if(m.options.offsets){r+=(H.offset().left-H.position().left)}if(j==-1){j=r}I=H.css("position");c=true;if(m.options.bottom!=-1){H.trigger("preFixed.ScrollToFixed");x();H.trigger("fixed.ScrollToFixed")}}function o(){var J=m.options.limit;if(!J){return 0}if(typeof(J)==="function"){return J.apply(H)}return J}function q(){return I==="fixed"}function y(){return I==="absolute"}function h(){return !(q()||y())}function x(){if(!q()){var J=H[0].getBoundingClientRect();u.css({display:H.css("display"),width:J.width,height:J.height,"float":H.css("float")});cssOptions={"z-index":m.options.zIndex,position:"fixed",top:m.options.bottom==-1?t():"",bottom:m.options.bottom==-1?"":m.options.bottom,"margin-left":"0px"};if(!m.options.dontSetWidth){cssOptions.width=H.css("width")}H.css(cssOptions);H.addClass(m.options.baseClassName);if(m.options.className){H.addClass(m.options.className)}I="fixed"}}function b(){var K=o();var J=r;if(m.options.removeOffsets){J="";K=K-E}cssOptions={position:"absolute",top:K,left:J,"margin-left":"0px",bottom:""};if(!m.options.dontSetWidth){cssOptions.width=H.css("width")}H.css(cssOptions);I="absolute"}function l(){if(!h()){f=-1;u.css("display","none");H.css({"z-index":z,width:"",position:F,left:"",top:e,"margin-left":""});H.removeClass("scroll-to-fixed-fixed");if(m.options.className){H.removeClass(m.options.className)}I=null}}function w(J){if(J!=f){H.css("left",r-J);f=J}}function t(){var J=m.options.marginTop;if(!J){return 0}if(typeof(J)==="function"){return J.apply(H)}return J}function B(){if(!a.isScrollToFixed(H)||H.is(":hidden")){return}var M=c;var L=h();if(!c){v()}else{if(h()){E=H.offset().top;r=H.offset().left}}var J=a(window).scrollLeft();var N=a(window).scrollTop();var K=o();if(m.options.minWidth&&a(window).width()<m.options.minWidth){if(!h()||!M){p();H.trigger("preUnfixed.ScrollToFixed");l();H.trigger("unfixed.ScrollToFixed")}}else{if(m.options.maxWidth&&a(window).width()>m.options.maxWidth){if(!h()||!M){p();H.trigger("preUnfixed.ScrollToFixed");l();H.trigger("unfixed.ScrollToFixed")}}else{if(m.options.bottom==-1){if(K>0&&N>=K-t()){if(!L&&(!y()||!M)){p();H.trigger("preAbsolute.ScrollToFixed");b();H.trigger("unfixed.ScrollToFixed")}}else{if(N>=E-t()){if(!q()||!M){p();H.trigger("preFixed.ScrollToFixed");x();f=-1;H.trigger("fixed.ScrollToFixed")}w(J)}else{if(!h()||!M){p();H.trigger("preUnfixed.ScrollToFixed");l();H.trigger("unfixed.ScrollToFixed")}}}}else{if(K>0){if(N+a(window).height()-H.outerHeight(true)>=K-(t()||-n())){if(q()){p();H.trigger("preUnfixed.ScrollToFixed");if(F==="absolute"){b()}else{l()}H.trigger("unfixed.ScrollToFixed")}}else{if(!q()){p();H.trigger("preFixed.ScrollToFixed");x()}w(J);H.trigger("fixed.ScrollToFixed")}}else{w(J)}}}}}function n(){if(!m.options.bottom){return 0}return m.options.bottom}function p(){var J=H.css("position");if(J=="absolute"){H.trigger("postAbsolute.ScrollToFixed")}else{if(J=="fixed"){H.trigger("postFixed.ScrollToFixed")}else{H.trigger("postUnfixed.ScrollToFixed")}}}var D=function(J){if(H.is(":visible")){c=false;B()}else{l()}};var G=function(J){(!!window.requestAnimationFrame)?requestAnimationFrame(B):B()};var C=function(){var K=document.body;if(document.createElement&&K&&K.appendChild&&K.removeChild){var M=document.createElement("div");if(!M.getBoundingClientRect){return null}M.innerHTML="x";M.style.cssText="position:fixed;top:100px;";K.appendChild(M);var N=K.style.height,O=K.scrollTop;K.style.height="3000px";K.scrollTop=500;var J=M.getBoundingClientRect().top;K.style.height=N;var L=(J===100);K.removeChild(M);K.scrollTop=O;return L}return null};var s=function(J){J=J||window.event;if(J.preventDefault){J.preventDefault()}J.returnValue=false};m.init=function(){m.options=a.extend({},a.ScrollToFixed.defaultOptions,i);z=H.css("z-index");m.$el.css("z-index",m.options.zIndex);u=a("<div />");I=H.css("position");F=H.css("position");k=H.css("float");e=H.css("top");if(h()){m.$el.after(u)}a(window).bind("resize.ScrollToFixed",D);a(window).bind("scroll.ScrollToFixed",G);if("ontouchmove" in window){a(window).bind("touchmove.ScrollToFixed",B)}if(m.options.preFixed){H.bind("preFixed.ScrollToFixed",m.options.preFixed)}if(m.options.postFixed){H.bind("postFixed.ScrollToFixed",m.options.postFixed)}if(m.options.preUnfixed){H.bind("preUnfixed.ScrollToFixed",m.options.preUnfixed)}if(m.options.postUnfixed){H.bind("postUnfixed.ScrollToFixed",m.options.postUnfixed)}if(m.options.preAbsolute){H.bind("preAbsolute.ScrollToFixed",m.options.preAbsolute)}if(m.options.postAbsolute){H.bind("postAbsolute.ScrollToFixed",m.options.postAbsolute)}if(m.options.fixed){H.bind("fixed.ScrollToFixed",m.options.fixed)}if(m.options.unfixed){H.bind("unfixed.ScrollToFixed",m.options.unfixed)}if(m.options.spacerClass){u.addClass(m.options.spacerClass)}H.bind("resize.ScrollToFixed",function(){u.height(H.height())});H.bind("scroll.ScrollToFixed",function(){H.trigger("preUnfixed.ScrollToFixed");l();H.trigger("unfixed.ScrollToFixed");B()});H.bind("detach.ScrollToFixed",function(J){s(J);H.trigger("preUnfixed.ScrollToFixed");l();H.trigger("unfixed.ScrollToFixed");a(window).unbind("resize.ScrollToFixed",D);a(window).unbind("scroll.ScrollToFixed",G);H.unbind(".ScrollToFixed");u.remove();m.$el.removeData("ScrollToFixed")});D()};m.init()};a.ScrollToFixed.defaultOptions={marginTop:0,limit:0,bottom:-1,zIndex:1000,baseClassName:"scroll-to-fixed-fixed"};a.fn.scrollToFixed=function(b){return this.each(function(){(new a.ScrollToFixed(this,b))})}})(jQuery);
/*!
 * JsLocalSearch ver: Beta 100
 * https://jelk.net/JsLocalSearch
 *
 * Copyright Carlos López y Ricardo Escanero
 * Released under the MIT license
 * https://jelk.net/JsLocalSearch/license
 *
 * require min jQuery 1.x
 *
 * Date: 2019-07-02
 *
 * Esto sin Bernardo no se podria haber hecho
 */

if (typeof Object.create !== "function") {
    Object.create = function (obj) {
        function F() {
        }
        F.prototype = obj;
        return new F();
    };
}


(function ($, window, document) {

    var JsLocalSearch = {
        init: function (options, el, callback) {

            var my = $(el);
            var base = this;

            if (options === undefined) {
              options = {}
            }

            var searchinput = (options.searchinput === undefined) ? "#gsearchsimple" : options.searchinput;
            options.container = (options.container === undefined) ? "contsearch" : options.container;
            var containersearch = (options.containersearch === undefined) ? "gsearch" : options.containersearch;
            var mincaracteres = (options.mincaracteres === undefined) ? 3 : options.mincaracteres;
            var action = (options.action === undefined) ? "Show" : options.action;
            var info = (options.info === undefined) ? false : options.info;
            options.mark_text = (options.mark_text === undefined) ? false : options.mark_text;
            options.html_search = (options.html_search === undefined) ? true : options.html_search;

            $(el).hide();

            var actionObject = Object.create(eval("Action" + action));

            actionObject.init(options, this)


            $(searchinput).on('keyup', callback , function (event) {

                        event.preventDefault();
                        txt = $(searchinput).val()
                        $('.' + options.container).attr('data-show',0)


                        if (info) {
                            $(el).show();
                        }
                        if ($(searchinput).val().length >= mincaracteres) {
                            actionObject.zero(this)
                            total = 0
                            totalok = 0
                            totalko = 0


                            $("." + options.container).each(function () {
                                visible=false
                                total++
                                $(this).find("." + containersearch).each(function () {
                                if (visible !=true) {

                                    visible=base.busca(options, actionObject, this);
                                }

                            });

                            if (visible == true) {
                                actionObject.ok(this);
                                totalok++
                            } else
                            {
                                actionObject.ko(this);
                                totalko++
                            }

                            });



                            $(el).find('.total').html(total);
                            $(el).find('.number').html(totalok);
                            $(el).find('.numberno').html(totalko);

                        } else {
                            $(el).hide();
                            actionObject.nope();
                            $("." + options.container).find("." + containersearch).each(function () {
                                if (options.mark_text != undefined) {
                                var re = new RegExp('<span class="'+options.mark_text+'">(.*?)<\/span>', "gi");
                                  var str = $(this).html();
                                  var newstr = str.replace(re, "$1");
                              }
                                  $(this).html(newstr);
                            });

                        }


                        if (typeof callback == 'function') { // make sure the callback is a function
                          callback.call(this); // brings the scope to the callback
                        }

                    })


        },

        busca: function (options, actionObject, el) {


            if (options.mark_text != undefined) {
            var re = new RegExp('<span class="'+options.mark_text+'">(.*?)<\/span>', "gi");
            var str = $(el).html();
            var newstr = str.replace(re, "$1");
            $(el).html(newstr);
            }

            search = false;

            if (options.html_search)

                if ($(el).text().normalize('NFD').replace(/([aeio])\u0301|(u)[\u0301\u0308]/gi,"$1$2").normalize().toUpperCase().indexOf(txt.normalize('NFD').replace(/([aeio])\u0301|(u)[\u0301\u0308]/gi,"$1$2").normalize().toUpperCase()) != -1) {
                    search = true;
                    var re = new RegExp("(" + txt + ")", "gi");
                    var str = $(el).text();

                    if (options.mark_text != undefined) {
                    var newstr = str.replace(re, "<span class='"+options.mark_text+"'>$1</span>");
                    }
                    $(el).html(newstr);


                }

            if ($(el).attr('data-description') != undefined && options.description_search) {
                if ($(el).attr('data-description').toUpperCase().indexOf(txt.toUpperCase()) != -1) {
                    search = true;



                }
            }

            if ($(el).attr('data-keywords') != undefined && options.keyword_search) {

                keywords = $(el).attr('data-keywords').toUpperCase().split(",")
                searchKey = txt.toUpperCase().split(" ")


                $.each(keywords, function (index, value) {
                    $.each(searchKey, function (index, key) {
                        if (value == key) {
                            search = true;
                        }
                    });
                });



            }






            return search;
        }
    };

    var ActionShow = {

        init: function (options, el) {
            this.container = options.container;
        },
        zero: function (options, el) {
            $('.' + this.container).hide();
        },
        ok: function (t) {
            $(t).closest('.' + this.container).show();
            $(t).closest('.' + this.container).attr('data-show',1);
        },
        ko: function (t) {
            if ($(t).closest('.' + this.container).attr('show')!=1) {
            $(t).closest('.' + this.container).hide();
        }

        },
        nope: function () {
            $('.' + this.container).show();

        }
    }

    var ActionMark = {

        init: function (options, el) {
            this.container = options.container;
            this.mark = options.actionok;
            this.unmark = options.actionko;
        },
        zero: function (options, el) {
            $('.' + this.container).removeClass(this.mark);
            $('.' + this.container).removeClass(this.unmark);

        },
        ok: function (t) {
            $(t).closest('.' + this.container).removeClass(this.unmark);
            $(t).closest('.' + this.container).addClass(this.mark);
             $(t).closest('.' + this.container).attr('data-show',1);
        },
        ko: function (t) {
            if ($(t).closest('.' + this.container).attr('data-show')!=1) {
                $(t).closest('.' + this.container).removeClass(this.mark);
                $(t).closest('.' + this.container).addClass(this.unmark);
              }

        },
        nope: function () {
            $('.' + this.container).removeClass(this.mark);
            $('.' + this.container).removeClass(this.unmark);

        }
    }


    $.fn.jsLocalSearch = function (options, callback) {
        return this.each(function () {

            var jsLocalSearch = Object.create(JsLocalSearch);
            var actionShow = Object.create(ActionShow);
            jsLocalSearch.init(options, this, callback);

            //     $.data(this, "jsLocalSearch", jsLocalSearch);
        });
    };



}(jQuery, window, document));



/**
 * A11Y functions
 */
(function ($) {
  'use strict';

  var toggleContrast = function () {

    var is_on = localStorage.getItem('contrast');

    if ( is_on == 'true' ) {

      document.body.className = document.body.className.replace(/\bcontrast\b/,'');
      localStorage.removeItem('contrast');
      $('.a11ymodContrast').removeClass('a11ymodContrast--active');

    } else {

      document.body.className += ' contrast';
      localStorage.setItem('contrast', 'true');
      $('.a11ymodContrast').addClass('a11ymodContrast--active');

    }

  };

  var checkContrast = function () {

    var is_on = localStorage.getItem('contrast');

    if ( is_on != 'true' ) {

      document.body.className = document.body.className.replace(/\bcontrast\b/,'');
      localStorage.removeItem('contrast');
      $('.a11ymodContrast').removeClass('a11ymodContrast--active');

    } else {

      document.body.className += ' contrast';
      localStorage.setItem('contrast', 'true');
      $('.a11ymodContrast').addClass('a11ymodContrast--active');

    }

  };

  var init = function () {

    // get contrast preference from localStorage
    checkContrast();

    // modify contrast
    $('.a11ymodContrast').on('click', function () {
      toggleContrast();
      document.body.className = document.body.className.replace('search-active', '');
      $(this).parent().removeClass('active').attr('aria-hidden', true).prev().attr('aria-expanded', false);
    });

    // Close search
    $('.mainsearch-block__close').on('click', function () {
      document.body.className = document.body.className.replace('search-active', '');
      $('.mainsearch-block').removeClass('active').attr('aria-hidden', true).prev().attr('aria-expanded', false);
    });

  };

  init();

}(jQuery));

(function ( w, doc ) {
  // enable strict mode
  'use strict';
  /**
   * Local object for method references
   * and define script meta-data
   */
  var ARIAswitch = {};
  w.ARIAswitch = ARIAswitch;

  ARIAswitch.NS      = 'ARIAswitch';
  ARIAswitch.AUTHOR  = 'Scott O\'Hara';
  ARIAswitch.VERION  = '0.2.0';
  ARIAswitch.LICENSE = 'https://github.com/scottaohara/accessible-components/blob/master/LICENSE.md';

  /**
   * Global Create
   *
   * This function validates that the minimum
   * required markup is present to create the
   * ARIA widget(s). Any additional markup elements
   * or attributes that do not exist in the found
   * required markup patterns will be generated
   * via this function.
   */
  ARIAswitch.create = function () {
    // hooks
    var widget = doc.querySelectorAll('[data-action="aria-switch"]');
    var self;
    var i;
    // define error message here, rather than in the weeds of the code
    var ariaLabelError = 'An attribute of "data-missing-label" has been added to a switch/switches that are missing aria-labelledby or aria-label attributes! Please add unique labels to the appropriate components!';

    // if widgets exist, loop through all instances
    // and set up appropriate attributes
    for ( i = 0; i < widget.length; i++ ) {
      // set this specific widget
      self = widget[i];

      // give each instance the role of switch if the role hasn't been set
      // or if it was set to something else in error
      if ( !self.hasAttribute('role') || self.getAttribute('role') !== 'switch' ) {
        self.setAttribute('role', 'switch');
      }

      // since these sorts of buttons won't work if
      // JavaScript is disabled, (hopefully) a disabled
      // attribute is set to them by default. When JavaScript
      // is on, we should remove the disabled attributes EXCEPT
      // if a switch button is meant to be disabled by default,
      // in which case, look for the data-keep-disabled attribute
      // and DON'T remove that disabled attribute...
      if ( !self.hasAttribute('data-keep-disabled') ) {
        self.removeAttribute('disabled');
      }

      // if an instance doesn't have a set aria-checked attribute,
      // then it must not be checked, so populate an aria-checked='false'
      if ( !self.hasAttribute('aria-checked') ) {
        self.setAttribute('aria-checked', 'false');
      }

      // log an error if an aria-label or labelledby attribute
      // is not found on a switch. also add a 'data-missing-label' attribute
      // to further call out what instance(s) are without appropriate labeling.
      if ( !self.hasAttribute('aria-label') && !self.hasAttribute('aria-labelledby') ) {
        console.warn(ariaLabelError);
      }

      self.addEventListener('click', ARIAswitch.actions);
    } // for(widget.length)
  }; // ARIAswitch.create()



  // primary actions function
  ARIAswitch.actions = function ( e ) {
    e.preventDefault();
    this.setAttribute('aria-checked', e.target.getAttribute('aria-checked') === 'true' ? 'false' : 'true');
  }; // ARIAswitch.events()



  // init function to run start-up functions.
  // if expanding this script, place any other
  // initialize functions within here.
  ARIAswitch.init = function () {
    ARIAswitch.create();
  }; // ARIAswitch.init()



  ARIAswitch.init();

})( window, document );

/**
 * aside blocks position
 */
(function ($) {
  'use strict';

  var $aside = $('.article-aside'),
      $blocks = $('.article-aside .freeblock');


  var asideBlocksInit = function () {
    $blocks.clone().addClass('hidden-md hidden-lg').appendTo($aside.closest('.row')).wrapAll('<div class="col-sm-12"/>');
    $blocks.wrapAll('<div class="hidden-xs hidden-sm"/>');
  };

  asideBlocksInit();


}(jQuery));

/**
 * focus on dropdown links
 */
(function ($) {
  'use strict';

  var onDropdownOpen = function () {

    $(document).on('shown.bs.dropdown', function (event) {

      var $dropdown = $(event.target);

      // Set aria-expanded to true
      $dropdown.find('.dropdown-menu').attr('aria-expanded', true);

      // Set focus on the first link in the dropdown
      setTimeout(function () {
        $dropdown.find('.dropdown-menu li:first-child a').focus();
      }, 10);

    });

  };

  var onDropdownClose = function () {

    $(document).on('hidden.bs.dropdown', function (event) {

      var $dropdown = $(event.target);

      // Set aria-expanded to false
      $dropdown.find('.dropdown-menu').attr('aria-expanded', false);

      // Set focus back to dropdown toggle
      $dropdown.find('.dropdown-toggle').focus();

    });

  };

  var init = function () {

    onDropdownOpen();
    onDropdownClose();

  };

  init();

}(jQuery));

/**
 * form choice for profile
 */
(function($) {
	'use strict';

	var layer = 'choice',
		set1 = 'btn-group--first',
		set2 = 'btn-group--last',
		choiceLink = 'choice-list__link',
		hiddenField = layer + '__field',
		decisionSet = 'decision',
		originBtn = 'decision__button',
		activeBtn = originBtn + '--active',
		disabledBtn = originBtn + '--disabled',
		submitBtn = 'decision__submitbtn',
		activeSubmit = submitBtn + '--active';


	var setMenuChoice = function(e) {
		var el = $(e.currentTarget),
			context = el.closest('.decision__form'),
			selectSet = el.closest('.btn-group'),
			hField = selectSet.find('.' + hiddenField),
			btn = selectSet.find('.' + originBtn),
			choiceId = el.data('choiceid'),
			choiceTxt = el.data('choice');

		btn.html(choiceTxt).addClass(activeBtn); // update button text

		if (selectSet.hasClass(set1)) {

			enableSecondButton(context); // enable second button (remove aria attributes and bootstrap disabled class)

			// if new value is different from value stored in input[type=hidden]
			if (choiceId !== hField.val()) {
				btn.data('selectedChoiceId', choiceId);
				resetSecondChoice(context);
				enableSubmitBtn(el);
			}

		} else if (selectSet.hasClass(set2)) {
			var target = el.data('target');
			context.attr('action', target);
			var base = window.location.protocol + '//' + window.location.host;
			if (!(target.startsWith('/') ||
				  target.startsWith('#') ||
				  target.startsWith('javascript:') ||
				  target.startsWith(base))) {
				context.attr('target', '_blank');
			} else {
				context.removeAttr('target');
			}
		}

		hField.val(choiceId); // update hidden input value

		if (selectSet.hasClass(set2)) {
			enableSubmitBtn(el); // check fields state to enable/disable submit button
		}
	};


	var setChoice = function() {
		$('.' + choiceLink).on('click', function(e) {
			setMenuChoice(e);
		});
	};


	var enableSecondButton = function(context) {

		var $secondButton = $(context).find('.' + set2 + ' .' + originBtn);

		$secondButton.removeClass(disabledBtn + ' disabled').removeAttr('tabindex aria-hidden');

	};

	// unused for the moment, can be handy
	var disableSecondButton = function(context) {

		var $secondButton = $(context).find('.' + set2 + ' .' + originBtn);

		$secondButton.addClass(disabledBtn + ' disabled').attr({'tabindex': '-1', 'aria-hidden': 'true'});

	};


	var resetSecondChoice = function(context) {

		var $secondButton = $(context).find('.' + set2 + ' .' + originBtn),
			secondMenu = $(context).find('.' + set2 + ' .choice-list'),
			initialTxt = $secondButton.data('choice'),
			hField = $(context).find('.' + set2 + ' .' + hiddenField),
			firstBtn = $(context).find('.' + originBtn),
			target = context.data('ams-engine-target') + '/get-menu-options.json';

		$.getJSON(target, {menu: firstBtn.data('selectedChoiceId')}, function(result) {
			secondMenu.empty();
			var suffix = secondMenu.data('suffix') || '';
			for (var index = 0; index < result.length; index++) {
				var item = result[index];
				$('<li></li>').addClass('choice-list__item')
					.append($('<a></a>').attr('class', 'choice-list__link')
										.attr('href', 'javascript:')
										.attr('data-choiceid', item.item_id)
										.attr('data-choice', suffix + ' ' + item.choice)
										.attr('data-target', item.target)
										.text(item.title)
										.on('click', setMenuChoice))
					.appendTo(secondMenu);
			}
			$secondButton.removeClass(activeBtn).html(initialTxt);
			hField.val(0); // update hidden input value
		});
	};


	var enableSubmitBtn = function(el) {

		var $decisionSet = $(el).parents('.' + decisionSet),
			$submitBtn = $decisionSet.find('.' + submitBtn);

		var fcount = $decisionSet.find('.' + hiddenField).filter(function() {
			return +this.value > 0;
		}).length; // return number of hidden inputs filled with a value

		if (fcount > 1) {
			$submitBtn.removeAttr('aria-hidden').addClass(activeSubmit);
		} else {
			$submitBtn.attr('aria-hidden', true).removeClass(activeSubmit);
		}

	};


	var init = function() {
		setChoice();
	};

	init();


}(jQuery));

/**
 * collapse all filters
 */
(function ($) {
  'use strict';

  var filters = 'filters';

  var closeAll = function () {

    $('.' + filters).find('.collapse').collapse('hide');

  };

  $.collapseAllFilters = function () {
    closeAll();
  };

}(jQuery));

/**
 * focus on dropdown links
 */
(function ($) {
  'use strict';

  var immersiveBg = function () {

    if ($('.immersive-section[data-immersive-bg]').length > 0) {
      $('.immersive-section[data-immersive-bg]').each(function () {

        var imgPath = $(this).data('immersive-bg');
        $(this).closest('.slot').addClass('immersive-bg').css('background-image', 'url(' + imgPath + ')');

        if ($(this).data('immersive-offset-bg')) {
          var bgOffset = $(this).data('immersive-offset-bg');
          $(this).closest('.slot').css('background-position', '100% ' + bgOffset + '%');
        }

      })
    }

  };

  var init = function () {

    immersiveBg();

  };

  init();

}(jQuery));

/**
 * « Produits et services » home slider
 */
(function () {
  'use strict';

  var carName = 'home-slider__item';
  var cardActiveName = carName + '--active';
  var cards = document.getElementsByClassName(carName);

  var pixName = 'intro-fade__banner';
  var pix = document.getElementsByClassName(pixName);
  var pixId = 'banner';
  var pixActiveName = 'intro-fade__banner--active';

  var hilightCard = function (el) {
    el.classList.add(cardActiveName);
    var bannerId = el.getAttribute('data-banner');
    document.getElementById(bannerId).classList.add(pixActiveName);
  };

  var switchOffCard = function () {
    for (var i = 0, x = cards.length; i < x; i++) {
      cards[i].classList.remove(cardActiveName);
    }
    for (var j = 0, y = pix.length; j < y; j++) {
      pix[j].classList.remove(pixActiveName);
    }
  };

  var addEvents = function () {
    for (var i = 0, x = cards.length; i < x; i++) {
      cards[i].addEventListener('mouseenter', function () {
        switchOffCard();
        hilightCard(this);
      }, false)
    }
  };

  if (cards) {
    addEvents();
  }

}());

(function (document, window, $, undefined) {
  'use strict';

  // Buttons
  var buttons = document.querySelectorAll('.js-button');

  var closeAll = function (button, content) {

    var excludeCurrent = button;

    [].forEach.call(buttons, function(button, index) {

      if (button != excludeCurrent && excludeCurrent.classList.contains('disablecloseall') == false) {
        var content = button.nextElementSibling;
        content.classList.remove('active');
        button.setAttribute('aria-expanded', 'false');
        content.setAttribute('aria-hidden', 'true');
        document.body.className = document.body.className.replace('search-active', '');
      }

    });
  }

  var displayContent = function (button, content) {

    if (content.classList.contains('active')) {
      // Hide content
      content.classList.remove('active');
      button.setAttribute('aria-expanded', 'false');
      content.setAttribute('aria-hidden', 'true');
      if (button.classList.contains('main-nav__link--search')) {
        document.body.className = document.body.className.replace('search-active', '');
      }
    } else {
      // Show content
      content.classList.add('active');
      button.setAttribute('aria-expanded', 'true');
      content.setAttribute('aria-hidden', 'false');
      if (button.classList.contains('main-nav__link--search')) {
        document.body.className += ' search-active';
      }
    }
  };

  [].forEach.call(buttons, function(button, index) {
    // Content var
    var content = button.nextElementSibling;

    // Set button attributes
    button.setAttribute('id', 'button-' + index);
    button.setAttribute('aria-expanded', 'false');
    button.setAttribute('aria-controls', 'content-' + index);

    // Set content attributes
    content.setAttribute('id', 'content-' + index);
    content.setAttribute('aria-hidden', 'true');
    content.setAttribute('aria-labelledby', 'button-' + index);

    button.addEventListener('click', function () {
      closeAll(this, content);
      displayContent(this, content);
      return false;
    }, false);

    button.addEventListener('keydown', function (event) {
      // Handle 'space' key
      if (event.which === 32) {
        event.preventDefault();
        closeAll(this, content);
        displayContent(this, content);
      }
    }, false);

  });

  $.closeContrastButton = function () {
    var contrastButton = document.querySelector('.supheader__link.js-button');
    var contrastContent = contrastButton.nextElementSibling;
    contrastContent.classList.remove('active');
    contrastButton.setAttribute('aria-expanded', 'false');
    contrastContent.setAttribute('aria-hidden', 'true');
    document.body.className = document.body.className.replace('search-active', '');
  };

})(document, window, jQuery);

/**
 * mobile accordion menu
 */
(function ($) {
  'use strict';

  var $hamburger = $('#mainMenuButton'),
      $mainNav   = $('#menu-principal'),
      $mainList  = $('.sidemobilemenu .main-nav__list'),
      mainLinks  = '.main-nav__link',
      $body      = $('body'),
      $overlay   = $('.global-overlay');

  var openCloseMainMenu = function () {
    $hamburger.on('click', function (event) {

      event.preventDefault();

      $('[data-target]:not([data-toggle]):not(#mainMenuButton):not(.main-nav__link)').each(function () {
        $(this).removeClass('active');
        $($(this).data('target')).removeClass('active');
      })

      // $([document.documentElement, document.body]).animate({
      //   scrollTop: $(this).offset().top
      // }, 200);

      var $current = $(event.currentTarget),
      freezeOption = $current.data('scroll');

      $current.toggleClass('active');
      $mainNav.toggleClass('active');
      $body.toggleClass('active-mobileflap');

      setTimeout(() => {
        $('.wrapper-sticky').addClass('wrapper-sticky--fixed');
      }, 100);


      if (freezeOption === 'noscroll' && $mainNav.hasClass('active')) {
        $body.addClass('noscrollmobile');
      } else {
        $body.removeClass('noscrollmobile');
      }

    });
  };

  var bindClose = function () {
    $overlay.on('click', function (event) {
      closeAll();
    });
  };

  var closeAll = function () {
    $hamburger.removeClass('active');
    $mainNav.removeClass('active');
    $body.removeClass('noscrollmobile active-mobileflap');
  };

  var resetEventMainMenu = function () {
    $hamburger.off();
    $mainList.off();
    $hamburger.removeClass('active');
    $mainNav.removeClass('active');
    $body.removeClass('noscrollmobile active-mobileflap');
  };

  var insideAccordion = function () {

    $mainList.on('click', mainLinks, function (event) {

      event.preventDefault();

      var $current = $(event.currentTarget);

      $mainList.find('.submenu').removeClass('active');
      $current.next().toggleClass('active');
      //$('.main-menu__list > li:not(.main-nav__item--search) > ul').not($current.next()).removeClass('active');

    });

  };

  $.mobileAccordionMenuInit = function () {
    openCloseMainMenu();
    insideAccordion();
    bindClose();
  };

  $.mobileAccordionMenuReset = function () {
    resetEventMainMenu();
  };

  $.mobileAccordionMenuInit();


}(jQuery));

/**
 * hovering a link in a card modify parent style
 */
(function ($) {
  'use strict';

     var card = 'result',
  activeClass = '--active';

  var init = function () {

    $('.' + card).on({
      mouseenter: function () {
        $(this).closest('.' + card).addClass(card + activeClass);
      },
      mouseleave: function () {
        $(this).closest('.' + card).removeClass(card + activeClass);
      }
    }, 'a.' + card + '__pic, a.' + card + '__body');

  };

  init();

}(jQuery));

/**
 * bootstrap dropdown used to control accessible tabs
 */
(function ($) {
  'use strict';

  var ddown = '.dropdown-control-tabs',
  offsetForMenu = 150;

  var ddownAction = function () {
    $(ddown).on('click', '.js-link-to-tab', function () {

      var $this = $(this),
      thisText = $this.html(),
      el = $this.closest(ddown),
      $sel = el.find('button'),
      elTop = $(el).offset().top;

      $sel.text(thisText);
      $('html, body').animate({scrollTop: (elTop - offsetForMenu)}, 500);

    });
  };

  $.selector2TabsInit = function () {
    ddownAction();
  };

  $.selector2TabsInit();

}(jQuery));

/**
 * open/close main menu
 */
(function ($) {
  'use strict';

  var $trigger = $('[data-target]:not([data-toggle]):not(#mainMenuButton)'),
        $flaps = $('.hidden-block'),
         $body = $('body'),
   $mainSticky = $('#mainSticky'),
     $document = $(document);

  var initButtons = function () {

    $trigger.on('click', function (event) {

      // event.preventDefault();

      var $current = $(event.currentTarget),
             $flap = $($current.data('target')),
      freezeOption = $current.data('scroll');

      $current.toggleClass('active');
      $current.parent().toggleClass('active');
         $flap.toggleClass('active');
         $body.addClass('active-flap');

      closeOthers($current);

      if (freezeOption === 'noscroll' && $flap.hasClass('active')) {
        $body.addClass('noscroll');
      }

      if ($flap.hasClass('active')) {
        $body.addClass('active-flap');
      } else {
        $body.removeClass('active-flap');
      }

    });

  };

  var attachCloseEvents = function () {

    $document.on('click', function (event) {

      var $component = $trigger.add($flaps);

      if (!$(event.target).closest($component).length) {
        closeAll();
      }

    });

  };

  var closeAll = function () {

      $flaps.removeClass('active');
    $trigger.removeClass('active');
    $trigger.parent().removeClass('active');
       $body.removeClass('noscroll active-flap');

  };

  var closeOthers = function (currentElement) {

    var $flap = $(currentElement.data('target'));

    if (!currentElement.hasClass('main-nav__link')) {
      $('#mainMenuButton').removeClass('active');
      $('#menu-principal').removeClass('active');
      $body.removeClass('noscrollmobile active-mobileflap');
    }

    $body.removeClass('noscroll');
    $flaps.not($flap).removeClass('active');
    $trigger.not(currentElement).removeClass('active');
    $trigger.not(currentElement).parent().removeClass('active');

  };

  var init = function () {

    initButtons();
    attachCloseEvents();
    $flaps.removeClass('active');

  };

  var reset = function () {
    closeAll();
    $trigger.off();
  };

  init();

}(jQuery));

// jshint asi:false
/* global ResponsiveBootstrapToolkit, lity */
// jshint devel:true
// jshint unused:false


// DOM loaded and ready
// --------------------------------------------------
$(function() {
  'use strict';

  // search Parcours Forêts
  if (document.getElementById('localSearchParcours')) {
    $('#localSearchParcours').jsLocalSearch({
      'amincaracteres': 3,
      'searchinput': '#searchParcoursForets',
      'container': 'contsearch',
      'containersearch': 'gsearch'
    });
  }

  // lity template option
  jQuery(function() {
    lity.options('template', '<div class="lity" role="dialog" aria-label="Fenêtre de dialogue (Appuyez Échap pour fermer)" tabindex="-1"><div class="lity-wrap" data-lity-close role="document"><div class="lity-loader" aria-hidden="true">Chargement…</div><div class="lity-container"><div class="lity-content"></div><button class="lity-close" type="button" aria-label="Fermer (Appuyez Échap pour fermer)" data-lity-close>&times;</button></div></div></div>');
  });

  jQuery('input[type="file"]').each(function() {
    var $input = $(this),
      $label = $input.next('label'),
      labelVal = $label.html();

    $input.on('change', function(e) {
      var fileName = '';

      if (this.files && this.files.length > 1)
        fileName = (this.getAttribute('data-multiple-caption') || '').replace(
          '{count}',
          this.files.length
        );
      else if (e.target.value) fileName = e.target.value.split('\\').pop();

      if (fileName) $label.find('span').html(fileName);
      else $label.html(labelVal);
    });

    // Firefox bug fix
    $input
      .on('focus', function() {
        $input.addClass('has-focus');
      })
      .on('blur', function() {
        $input.removeClass('has-focus');
      });
  });

  jQuery('.owl-drag').on('click', '.linkedin-card', function () {
    jQuery(this).addClass('clickable');
  });

});





// DOM is ready + ResponsiveBootstrapToolkit
// --------------------------------------------------
(function($, viewport) {
  'use strict';

  $(document).ready(function() {
    // Executes only in XS + SM breakpoints
    if (viewport.is('<md')) {
      jQuery('body').addClass('sidemobilemenu');
      $.mobileAccordionMenuReset();
      $.mobileAccordionMenuInit();
      $.collapseAllFilters();
    } else {
      jQuery('body').removeClass('sidemobilemenu');
      $.mobileAccordionMenuReset();
    }
  }, 150);

  $(window).resize(
    viewport.changed(function () {
      // console.log('viewport.changed triggered!');
      if (document.activeElement.closest('.main-search-form')) {
        // console.log('activeElement triggered!');
        return;
      }
      if (viewport.is('<md')) {
        jQuery('body').addClass('sidemobilemenu');
        $.mobileAccordionMenuReset();
        $.mobileAccordionMenuInit();
        // $.collapseAllFilters();
      } else {
        jQuery('body').removeClass('sidemobilemenu');
        $.mobileAccordionMenuReset();
      }
    }, 150)
  );

})(jQuery, ResponsiveBootstrapToolkit);
