/*! Zabuto Calendar - v2.1.0 - 2022-12-29
* https://github.com/zabuto/calendar
* Copyright (c) 2022 Anke Heijnen; Licensed MIT */(function(e){(function(e,t,n,s){"use strict";var o="zabuto_calendar",i=new Date;function a(t,n){this.element=t,this._name=o,this._defaults=e.fn[o].defaults,this.settings=e.extend({},this._defaults,n),null!==this.settings.translation?this.settings.language=null:this.settings.language=this.settings.language.toLowerCase(),this.init()}e.fn[o]=function(t){if(t!==s){var n,i=e.makeArray(arguments);n=i.slice(1)}return this.each(function(){var s=e.data(this,"plugin_"+o);s?typeof t=="string"&&typeof s[t]=="function"&&s[t].apply(s,n):e.data(this,"plugin_"+o,new a(this,t))})},e.fn[o].defaults={year:i.getFullYear(),month:i.getMonth()+1,language:"en",translation:null,week_starts:"monday",show_days:!0,classname:null,header_format:"[month] [year]",date_format:"y-m-d",first_date:null,last_date:null,navigation_prev:!0,navigation_next:!0,navigation_markup:{prev:"&#9668;",next:"&#9658;"},today_markup:null,events:null,ajax:null},e.fn[o].languages={},e.extend(a.prototype,{init:function(){var n,t=e.Event("zabuto:calendar:init");t.settings=this.settings,n=e(this.element),n.trigger(t),this.goto(this.settings.year,this.settings.month)},destroy:function(){var t=e(this.element);t.removeData("plugin_"+o),t.removeData("year"),t.removeData("month"),t.removeData("event-data"),t.empty(),t.trigger("zabuto:calendar:destroy")},reload:function(){var t=e(this.element),n=e.Event("zabuto:calendar:reload");n.year=t.data("year"),n.month=t.data("month"),t.trigger(n),this.data()},goto:function(t,n){if(!1===this._isValidDate(t,n,1))return;var s,i,a,o=e.Event("zabuto:calendar:goto");o.year=t,o.month=n,s=e(this.element),s.data("year",t),s.data("month",n),s.trigger(o),this._defaults.navigation_prev&&this.settings.first_date&&(i=new Date(t,n-1,1),this.settings.navigation_prev=i>=this.settings.first_date),this._defaults.navigation_next&&this.settings.last_date&&(a=new Date(t,n,1),this.settings.navigation_next=a<this.settings.last_date),this.data()},data:function(){var o,i,a,n=this,t=e(this.element),s=n._getEventHandle();null===s?(t.data("event-data",[]),this.render()):s.type==="fixed"?(a=n._eventsToDays(s.data),o=e.Event("zabuto:calendar:data"),o.type="fixed",o.eventlist=s.data,o.eventdata=a,t.data("event-data",a),t.trigger(o),n.render()):s.type==="ajax"&&(i=s.settings,i.data={year:t.data("year"),month:t.data("month")},i.dataType="json",e.ajax(i).done(function(s){var i=n._eventsToDays(s),o=e.Event("zabuto:calendar:data");o.type="ajax",o.eventlist=s,o.eventdata=i,t.data("event-data",i),t.trigger(o),n.render()}).fail(function(s,o,i){var a=e.Event("zabuto:calendar:data-fail");a.text=o,a.error=i,t.data("event-data",[]),t.trigger(a),n.render()}))},render:function(){var o,t=e(this.element),n=t.data("year"),s=t.data("month"),i=e.Event("zabuto:calendar:preRender");i.year=n,i.month=s,t.trigger(i),t.empty(),this._isValidDate(n,s,1)&&t.append(this._renderTable(n,s)),o=e.Event("zabuto:calendar:render"),o.year=n,o.month=s,t.trigger(o)},_renderTable:function(t,n){var o,i,s=e("<table></table>").addClass("zabuto-calendar");return this.settings.classname&&s.addClass(this.settings.classname),o=e("<thead></thead>"),o.append(this._renderNavigation(t,n)),!0===this.settings.show_days&&o.append(this._renderDaysOfWeek()),i=this._renderDaysInMonth(t,n),s.append(o),s.append(i),s},_renderNavigation:function(t,n){var i,a,r,c,l,u,s=this,o=s.settings.header_format,o=o.replace("[year]",t.toString()),d=s._getTranslation();return null!==d&&"months"in d?(u=d.months,o=o.replace("[month]",u[n.toString()])):o=o.replace("[month]",n.toString()),i=e("<tr></tr>").addClass("zabuto-calendar__navigation").attr("role","navigation"),r=s._calculatePrevious(t,n),c=s._calculateNext(t,n),l=e("<span></span>").text(o).data("to",{year:s.settings.year,month:s.settings.month}),l.addClass("zabuto-calendar__navigation__item--header__title"),(null!==r||null!==c)&&l.on("zabuto:calendar:navigate-init",function(t){var n=e(this).data("to");t.year=n.year,t.month=n.month,s.goto(n.year,n.month)}).on("dblclick",function(){e(this).trigger("zabuto:calendar:navigate-init")}),a=e("<td></td>"),a.addClass("zabuto-calendar__navigation__item--header"),a.append(l),null===r&&null===c?i.append(a.attr("colspan",7)):(i.append(s._renderNavigationItem("prev",r)),i.append(a.attr("colspan",5)),i.append(s._renderNavigationItem("next",c))),i},_renderNavigationItem:function(t,n){var s,o=this;return t=t.toString(),s=e("<td></td>").data("nav",t).data("to",n),s.addClass("zabuto-calendar__navigation__item--"+t),null!==n&&(t in o.settings.navigation_markup?s.html(o.settings.navigation_markup[t]):s.html(t),s.on("zabuto:calendar:navigate",function(t){var n=e(this).data("to");t.year=n.year,t.month=n.month,o.goto(n.year,n.month)}).on("click",function(){e(this).trigger("zabuto:calendar:navigate")})),s},_renderDaysOfWeek:function(){var t,s=this.settings.week_starts,n={0:"0",1:"1",2:"2",3:"3",4:"4",5:"5",6:"6"},o=this._getTranslation();return null!==o&&"days"in o&&(n=o.days),t=e("<tr></tr>").addClass("zabuto-calendar__days-of-week"),(s===0||s==="0"||s==="sunday")&&t.append(e("<th></th>").data("dow",0).text(n[0]).addClass("zabuto-calendar__days-of-week__item")),t.append(e("<th></th>").data("dow",1).text(n[1]).addClass("zabuto-calendar__days-of-week__item")),t.append(e("<th></th>").data("dow",2).text(n[2]).addClass("zabuto-calendar__days-of-week__item")),t.append(e("<th></th>").data("dow",3).text(n[3]).addClass("zabuto-calendar__days-of-week__item")),t.append(e("<th></th>").data("dow",4).text(n[4]).addClass("zabuto-calendar__days-of-week__item")),t.append(e("<th></th>").data("dow",5).text(n[5]).addClass("zabuto-calendar__days-of-week__item")),t.append(e("<th></th>").data("dow",6).text(n[6]).addClass("zabuto-calendar__days-of-week__item")),(s===1||s==="1"||s==="monday")&&t.append(e("<th></th>").data("dow",0).text(n[0]).addClass("zabuto-calendar__days-of-week__item")),t},_renderDaysInMonth:function(t,n){var o,i,a,l,s=this,r=s.settings.week_starts,d=s._calculateWeeksInMonth(t,n),m=s._calculateLastDayOfMonth(t,n),c=s._calculateDayOfWeek(t,n,1),u=[0,1,2,3,4,5,6],h=c;(r===1||r==="1"||r==="monday")&&(u=[1,2,3,4,5,6,7],h=c===0?7:c),l=e("<tbody></tbody>"),i=1;for(o=1;o<=d;o++)a=s._renderWeek(o,d),e.each(u,function(r,c){if(o===1&&c<h||i>m)a.append(e("<td></td>").addClass("zabuto-calendar__day--empty"));else{var l=s._renderDay(t,n,i,c);a.append(l),i++}}),l.append(a);return l},_renderWeek:function(t,n){var s=e("<tr></tr>");return t===1?s.addClass("zabuto-calendar__week--first"):t===n?s.addClass("zabuto-calendar__week--last"):s.addClass("zabuto-calendar__week"),s},_renderDay:function(t,n,s,o){var r,c,l=this._dateAsString(t,n,s),a=this._eventsForDay(l),i=e("<td></td>");return i.data("date",l),i.data("year",t),i.data("month",n),i.data("day",s),i.data("dow",o===7?0:o),i.data("eventdata",a),this._isToday(t,n,s)?(i.data("today",1),i.addClass("zabuto-calendar__day--today"),this.settings.today_markup?(r=this.settings.today_markup,r=r.replace("[day]",s),i.html(r)):i.text(s)):(i.data("today",0),i.addClass("zabuto-calendar__day"),i.text(s)),null!==a?(i.data("hasEvent",1),i.addClass("zabuto-calendar__event"),e.each(a.classnames,function(e,t){i.addClass(t)}),null!==a.markup&&(c=a.markup,c=c.replace("[day]",s),i.html(c))):i.data("hasEvent",0),i.on("zabuto:calendar:day",function(t){t.element=e(this),t.date=new Date(e(this).data("year"),e(this).data("month")-1,e(this).data("day")),t.value=e(this).data("date"),t.today=!!e(this).data("today"),t.hasEvent=!!e(this).data("hasEvent"),t.eventdata=a}).on("click",function(){e(this).trigger("zabuto:calendar:day")}),i},_getTranslation:function(){var n,s,t=this.settings.translation;return null!==t&&typeof t=="object"&&"months"in t&&"days"in t?t:(n=this.settings.language,s=e.fn[o].languages,n in s?s[n]:null)},_calculateWeeksInMonth:function(e,t){var c,l,n=this.settings.week_starts,i=this._calculateLastDayOfMonth(e,t),s=this._calculateDayOfWeek(e,t,1),o=this._calculateDayOfWeek(e,t,i),a=s,r=o;return(n===1||n==="1"||n==="monday")&&(a=s===0?7:s,r=o===0?7:o),c=a-r,l=i+c,Math.ceil(l/7)},_calculateLastDayOfMonth:function(e,t){var n=t-1,s=new Date(e,n+1,0);return s.getDate()},_calculateDayOfWeek:function(e,t,n){var s=t-1,o=new Date(e,s,n);return o.getDay()},_calculatePrevious:function(e,t){if(!1===this.settings.navigation_prev)return null;var s=e,n=t-1;return n===0&&(s=e-1,n=12),{year:s,month:n}},_calculateNext:function(e,t){if(!1===this.settings.navigation_next)return null;var s=e,n=t+1;return n===13&&(s=e+1,n=1),{year:s,month:n}},_isValidDate:function(e,t,n){if(t<1||t>12)return!1;var o=t-1,s=new Date(e,o,n);return s.getFullYear()===e&&s.getMonth()===o&&s.getDate()===Number(n)},_isToday:function(e,t,n){var s=t-1,o=new Date,i=new Date(e,s,n);return i.toDateString()===o.toDateString()},_dateAsString:function(e,t,n){var s=this.settings.date_format;return n=n<10?"0"+n:n,t=t<10?"0"+t:t,s=s.replace("y",e),s=s.replace("m",t),s=s.replace("d",n),s},_getEventHandle:function(){var e,t=this.settings.events;return null!==t&&typeof t=="object"?{type:"fixed",data:t}:(e=this.settings.ajax,null!==e?(typeof e=="string"&&(e={type:"GET",url:e,cache:!1}),{type:"ajax",settings:e}):null)},_eventsToDays:function(t){var n=[];return e.each(t,function(e,t){if(typeof t=="object"&&"date"in t){var o=t.date,s={count:0,classnames:[],markup:null,events:[]};o in n&&(s=n[o]),s.count=s.count+1,s.events.push(t),"classname"in t&&t.classname!==null&&s.classnames.push(t.classname),"markup"in t&&t.markup!==null&&(s.markup=t.markup),n[o]=s}}),n},_eventsForDay:function(t){var n,s,o=e(this.element),i=o.data("event-data");return t in i?(s=i[t],n=e.Event("zabuto:calendar:day-event"),n.value=t,n.eventdata=s,o.trigger(n),s):null}})})(jQuery,window,document,void 0),e.fn.zabuto_calendar.languages=e.fn.zabuto_calendar.languages||{},e.fn.zabuto_calendar.languages.ar={months:{1:"يناير",2:"فبراير",3:"مارس",4:"أبريل",5:"مايو",6:"يونيو",7:"يوليو",8:"أغسطس",9:"سبتمبر",10:"أكتوبر",11:"نوفمبر",12:"ديسمبر"},days:{0:"أحد",1:"أثنين",2:"ثلاثاء",3:"اربعاء",4:"خميس",5:"جمعه",6:"سبت"}},e.fn.zabuto_calendar.languages.az={months:{1:"Yanvar",2:"Fevral",3:"Mart",4:"Aprel",5:"May",6:"İyun",7:"İyul",8:"Avqust",9:"Sentyabr",10:"Oktyabr",11:"Noyabr",12:"Dekabr"},days:{0:"Baz",1:"B.e",2:"Ç.A",3:"Çərş",4:"C.A",5:"Cümə",6:"Şən"}},e.fn.zabuto_calendar.languages.ca={months:{1:"Gener",2:"Febrer",3:"Març",4:"Abril",5:"Maig",6:"Juny",7:"Juliol",8:"Agost",9:"Setembre",10:"Octubre",11:"Novembre",12:"Desembre"},days:{0:"Dg",1:"Dl",2:"Dt",3:"Dc",4:"Dj",5:"Dv",6:"Ds"}},e.fn.zabuto_calendar.languages.cn={months:{1:"一月",2:"二月",3:"三月",4:"四月",5:"五月",6:"六月",7:"七月",8:"八月",9:"九月",10:"十月",11:"十一月",12:"十二月"},days:{0:"星期日",1:"星期一",2:"星期二",3:"星期三",4:"星期四",5:"星期五",6:"星期六"}},e.fn.zabuto_calendar.languages.cs={months:{1:"Leden",2:"Únor",3:"Březen",4:"Duben",5:"Květen",6:"Červen",7:"Červenec",8:"Srpen",9:"Září",10:"Říjen",11:"Listopad",12:"Prosinec"},days:{0:"Ne",1:"Po",2:"Út",3:"St",4:"Čt",5:"Pá",6:"So"}},e.fn.zabuto_calendar.languages.de={months:{1:"Januar",2:"Februar",3:"März",4:"April",5:"Mai",6:"Juni",7:"Juli",8:"August",9:"September",10:"Oktober",11:"November",12:"Dezember"},days:{0:"So",1:"Mo",2:"Di",3:"Mi",4:"Do",5:"Fr",6:"Sa"}},e.fn.zabuto_calendar.languages.en={months:{1:"January",2:"February",3:"March",4:"April",5:"May",6:"June",7:"July",8:"August",9:"September",10:"October",11:"November",12:"December"},days:{0:"Sun",1:"Mon",2:"Tue",3:"Wed",4:"Thu",5:"Fri",6:"Sat"}},e.fn.zabuto_calendar.languages.es={months:{1:"Enero",2:"Febrero",3:"Marzo",4:"Abril",5:"Mayo",6:"Junio",7:"Julio",8:"Agosto",9:"Septiembre",10:"Octubre",11:"Noviembre",12:"Diciembre"},days:{0:"Do",1:"Lu",2:"Ma",3:"Mi",4:"Ju",5:"Vi",6:"Sá"}},e.fn.zabuto_calendar.languages.fi={months:{1:"Tammikuu",2:"Helmikuu",3:"Maaliskuu",4:"Huhtikuu",5:"Toukokuu",6:"Kesäkuu",7:"Heinäkuu",8:"Elokuu",9:"Syyskuu",10:"Lokakuu",11:"Marraskuu",12:"Joulukuu"},days:{0:"Su",1:"Ma",2:"Ti",3:"Ke",4:"To",5:"Pe",6:"La"}},e.fn.zabuto_calendar.languages.fr={months:{1:"Janvier",2:"Février",3:"Mars",4:"Avril",5:"Mai",6:"Juin",7:"Juillet",8:"Août",9:"Septembre",10:"Octobre",11:"Novembre",12:"Décembre"},days:{0:"Dim",1:"Lun",2:"Mar",3:"Mer",4:"Jeu",5:"Ven",6:"Sam"}},e.fn.zabuto_calendar.languages.he={months:{1:"ינואר",2:"פברואר",3:"מרץ",4:"אפריל",5:"מאי",6:"יוני",7:"יולי",8:"אוגוסט",9:"ספטמבר",10:"אוקטובר",11:"נובמבר",12:"דצמבר"},days:{0:"א",1:"ב",2:"ג",3:"ד",4:"ה",5:"ו",6:"ש"}},e.fn.zabuto_calendar.languages.hu={months:{1:"Január",2:"Február",3:"Március",4:"Április",5:"Május",6:"Június",7:"Július",8:"Augusztus",9:"Szeptember",10:"Október",11:"November",12:"December"},days:{0:"Va",1:"Hé",2:"Ke",3:"Sze",4:"Cs",5:"Pé",6:"Szo"}},e.fn.zabuto_calendar.languages.id={months:{1:"Januari",2:"Februari",3:"Maret",4:"April",5:"Mei",6:"Juni",7:"Juli",8:"Agustus",9:"September",10:"Oktober",11:"November",12:"Desember"},days:{0:"Minggu",1:"Senin",2:"Selasa",3:"Rabu",4:"Kamis",5:"Jum'at",6:"Sabtu"}},e.fn.zabuto_calendar.languages.it={months:{1:"Gennaio",2:"Febbraio",3:"Marzo",4:"Aprile",5:"Maggio",6:"Giugno",7:"Luglio",8:"Agosto",9:"Settembre",10:"Ottobre",11:"Novembre",12:"Dicembre"},days:{0:"Dom",1:"Lun",2:"Mar",3:"Mer",4:"Gio",5:"Ven",6:"Sab"}},e.fn.zabuto_calendar.languages.jp={months:{1:"1月",2:"2月",3:"3月",4:"4月",5:"5月",6:"6月",7:"7月",8:"8月",9:"9月",10:"10月",11:"11月",12:"12月"},days:{0:"日",1:"月",2:"火",3:"水",4:"木",5:"金",6:"土"}},e.fn.zabuto_calendar.languages.kr={months:{1:"1월",2:"2월",3:"3월",4:"4월",5:"5월",6:"6월",7:"7월",8:"8월",9:"9월",10:"10월",11:"11월",12:"12월"},days:{0:"일",1:"월",2:"화",3:"수",4:"목",5:"금",6:"토"}},e.fn.zabuto_calendar.languages.nl={months:{1:"Januari",2:"Februari",3:"Maart",4:"April",5:"Mei",6:"Juni",7:"Juli",8:"Augustus",9:"September",10:"Oktober",11:"November",12:"December"},days:{0:"Zo",1:"Ma",2:"Di",3:"Wo",4:"Do",5:"Vr",6:"Za"}},e.fn.zabuto_calendar.languages.no={months:{1:"Januar",2:"Februar",3:"Mars",4:"April",5:"Mai",6:"Juni",7:"Juli",8:"August",9:"September",10:"Oktober",11:"November",12:"Desember"},days:{0:"Sø",1:"Ma",2:"Ti",3:"On",4:"To",5:"Fr",6:"Lø"}},e.fn.zabuto_calendar.languages.pl={months:{1:"Styczeń",2:"Luty",3:"Marzec",4:"Kwiecień",5:"Maj",6:"Czerwiec",7:"Lipiec",8:"Sierpień",9:"Wrzesień",10:"Październik",11:"Listopad",12:"Grudzień"},days:{0:"niedz.",1:"pon.",2:"wt.",3:"śr.",4:"czw.",5:"pt.",6:"sob."}},e.fn.zabuto_calendar.languages.pt={months:{1:"Janeiro",2:"Fevereiro",3:"Marco",4:"Abril",5:"Maio",6:"Junho",7:"Julho",8:"Agosto",9:"Setembro",10:"Outubro",11:"Novembro",12:"Dezembro"},days:{0:"D",1:"S",2:"T",3:"Q",4:"Q",5:"S",6:"S"}},e.fn.zabuto_calendar.languages.ru={months:{1:"Январь",2:"Февраль",3:"Март",4:"Апрель",5:"Май",6:"Июнь",7:"Июль",8:"Август",9:"Сентябрь",10:"Октябрь",11:"Ноябрь",12:"Декабрь"},days:{0:"Вск",1:"Пн",2:"Вт",3:"Ср",4:"Чт",5:"Пт",6:"Сб"}},e.fn.zabuto_calendar.languages.se={months:{1:"Januari",2:"Februari",3:"Mars",4:"April",5:"Maj",6:"Juni",7:"Juli",8:"Augusti",9:"September",10:"Oktober",11:"November",12:"December"},days:{0:"Sön",1:"Mån",2:"Tis",3:"Ons",4:"Tor",5:"Fre",6:"Lör"}},e.fn.zabuto_calendar.languages.sk={months:{1:"Január",2:"Február",3:"Marec",4:"Apríl",5:"Máj",6:"Jún",7:"Júl",8:"August",9:"September",10:"Október",11:"November",12:"December"},days:{0:"Ne",1:"Po",2:"Ut",3:"St",4:"Št",5:"Pi",6:"So"}},e.fn.zabuto_calendar.languages.sr={months:{1:"Јануар",2:"Фебруар",3:"Март",4:"Април",5:"Мај",6:"Јун",7:"Јул",8:"Август",9:"Септембар",10:"Октобар",11:"Новембар",12:"Децембар"},days:{0:"Нед",1:"Пон",2:"Уто",3:"Сре",4:"Чет",5:"Пет",6:"Суб"}},e.fn.zabuto_calendar.languages.tr={months:{1:"Ocak",2:"Şubat",3:"Mart",4:"Nisan",5:"Mayıs",6:"Haziran",7:"Temmuz",8:"Ağustos",9:"Eylül",10:"Ekim",11:"Kasım",12:"Aralık"},days:{0:"Paz",1:"Pts",2:"Salı",3:"Çar",4:"Per",5:"Cuma",6:"Cts"}},e.fn.zabuto_calendar.languages.ua={months:{1:"Січень",2:"Лютий",3:"Березень",4:"Квітень",5:"Травень",6:"Червень",7:"Липень",8:"Серпень",9:"Вересень",10:"Жовтень",11:"Листопад",12:"Грудень"},days:{0:"Нд",1:"Пн",2:"Вт",3:"Ср",4:"Чт",5:"Пт",6:"Сб"}}})(jQuery)