(function () {
  const app = document.getElementById('selectorApp');
  if (app !== null) {
    const dataFile = app.getAttribute('data-file');
    const selectorApp = new Vue({
      el: '#selectorApp',
      data() {
        return {
          datafile: dataFile,
          firstLevelOptions: [],
          selectedFirstLevel: '',
          selectedSecondLevel: ''
        }
      },
      mounted: function() {
        fetch(this.datafile)
          .then((resp) => resp.json())
          .then(data => {
            this.firstLevelOptions = data
          })
      },
      computed: {
        secondLevelOptions: function() {
          var current1stEl = '';
          if (this.selectedFirstLevel) {
            current1stEl = this.findElement(this.firstLevelOptions, 'value', this.selectedFirstLevel);
            return current1stEl.subs;
          } else {
            return '';
          }
        },
        action() {
          var current2ndEl = '';
          if (this.selectedSecondLevel) {
            current2ndEl = this.findElement(this.secondLevelOptions, 'value', this.selectedSecondLevel);
            return current2ndEl.target
          } else {
            return 'javascript:;'
          }
        }
      },
      methods: {
        findElement(arr, propName, propValue) {
          for (var i = 0; i < arr.length; i++) {
            if (arr[i][propName] == propValue) {
              return arr[i];
            }
          }
        },
        reset2ndSelect() {
          this.selectedSecondLevel = ''
        }
      }
    });
  }
}());
