#
# Copyright (c) 2008-2019 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

from zope.interface import Interface

from onf_website.skin.public import onf_patronage_skin
from onf_website.skin.public.satellite.services import IONFServicesLayer
from pyams_skin.interfaces import ISkin
from pyams_skin.interfaces.resources import IResources
from pyams_utils.adapter import ContextRequestViewAdapter, adapter_config
from pyams_utils.registry import utility_config


__docformat__ = 'restructuredtext'

from onf_website import _


class IONFPatronageLayer(IONFServicesLayer):
    """ONF patronage skin layer"""


@utility_config(name='ONF patronage skin', provides=ISkin)
class ONFPatronageSkin(object):
    """ONF patronage skin"""

    label = _("ONF: patronage skin")
    layer = IONFPatronageLayer


@adapter_config(context=(Interface, IONFPatronageLayer, Interface), provides=IResources)
class ONFPatronageLayerResourcesAdapter(ContextRequestViewAdapter):
    """Patronage layer resources adapter"""

    resources = (onf_patronage_skin,)
