#
# Copyright (c) 2008-2018 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

from zope.interface import Interface

from pyams_default_theme.layer import IPyAMSDefaultLayer
from pyams_template.template import layout_config

__docformat__ = 'restructuredtext'


ONF_API_SKIN_NAME = 'ONF API skin'


PYAMS_BODY_CLASS_KEY = 'pyams.body.class'
PYAMS_MAIN_CLASS_KEY = 'pyams.main.class'


class IBodyClass(Interface):
    """HTML body class interface"""


class IMainClass(Interface):
    """HTML #main class interface"""


@layout_config(template='templates/inner-layout.pt', layer=IPyAMSDefaultLayer)
class IInnerView(Interface):
    """Inner view marker interface"""
