#
# Copyright (c) 2008-2018 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

from fanstatic import Group, Library, Resource

from myams import jquery, myams_js_require


__docformat__ = 'restructuredtext'


library = Library('onf_website', 'resources')


#
# Base javascript resources
#

main_bundle = Resource(library, 'scripts/main.bundle.js',
                       minified='scripts/main.bundle.min.js',
                       depends=(jquery,),
                       bottom=True)

main_base_script = Resource(library, 'scripts/main.jquery.js',
                            minified='scripts/main.jquery.min.js',
                            depends=(main_bundle,),
                            bottom=True)

onf_base_script = Resource(library, 'scripts/onf.js',
                           minified='scripts/onf.min.js',
                           depends=(main_base_script, myams_js_require),
                           bottom=True)


#
# Custom javascript plug-ins
#

# Carousel

owl_carousel = Resource(library, 'plugins/owl.carousel.js',
                        minified='plugins/owl.carousel.min.js',
                        depends=(onf_base_script,),
                        bottom=True)

owl_autoheight = Resource(library, 'plugins/owl.autoheight.js',
                          minified='plugins/owl.autoheight.min.js',
                          depends=(owl_carousel,),
                          bottom=True)

owl_navigation = Resource(library, 'plugins/owl.navigation.js',
                          minified='plugins/owl.navigation.min.js',
                          depends=(owl_carousel,),
                          bottom=True)

owl_carousel_aria = Resource(library, 'plugins/owl.carousel.aria.js',
                             minified='plugins/owl.carousel.aria.min.js',
                             depends=(owl_navigation,),
                             bottom=True)

owl_carousel_init = Resource(library, 'plugins/owl.carousel.init.js',
                             minified='plugins/owl.carousel.init.min.js',
                             depends=(owl_autoheight, owl_carousel_aria,),
                             bottom=True)

# Alerts

alert = Resource(library, 'plugins/alert.jquery.js',
                 minified='plugins/alert.jquery.min.js',
                 depends=(owl_carousel_init,),
                 bottom=True)

# Sticky

jquery_scrolltofixed = Resource(library, 'plugins/jquery-scrolltofixed-min.js',
                                depends=(jquery,),
                                bottom=True)

aside_sticky = Resource(library, 'plugins/aside.sticky.jquery.js',
                        minified='plugins/aside.sticky.jquery.min.js',
                        depends=(jquery_scrolltofixed,),
                        bottom=True)

# Home animations

gsap = Resource(library, 'plugins/gsap.min.js',
                bottom=True)

home_banner_anim = Resource(library, 'plugins/home-banner-anim.js',
                            minified='plugins/home-banner-anim.min.js',
                            depends=(gsap, onf_base_script),
                            bottom=True)

# TOC

jquery_waypoints = Resource(library, 'plugins/jquery.waypoints.min.js',
                            depends=(jquery,),
                            bottom=True)

aside_toc = Resource(library, 'plugins/aside.toc.jquery.js',
                     minified='plugins/aside.toc.jquery.min.js',
                     depends=(jquery_waypoints,),
                     bottom=True)

# JQuery Twenty-Twenty

jquery_move = Resource(library, 'plugins/jquery.event.move.js',
                       minified='plugins/jquery.event.move.min.js',
                       depends=(jquery,),
                       bottom=True)

jquery_twentytwenty = Resource(library, 'plugins/jquery.twentytwenty.js',
                               minified='plugins/jquery.twentytwenty.min.js',
                               depends=(jquery_move,),
                               bottom=True)

jquery_twentytwenty_init = Resource(library, 'plugins/jquery.twentytwenty.init.js',
                                    minified='plugins/jquery.twentytwenty.init.min.js',
                                    depends=(jquery_twentytwenty,),
                                    bottom=True)

#
# JQuery parallax plug-ins
#

rellax = Resource(library, 'plugins/rellax.min.js',
                  depends=(jquery,),
                  bottom=True)

pan_container = Resource(library, 'plugins/pan-container.js',
                         minified='plugins/pan-container.min.js',
                         depends=(jquery, ),
                         bottom=True)

jquery_tilt = Resource(library, 'plugins/tilt.jquery.min.js',
                       depends=(jquery, rellax, pan_container),
                       bottom=True)


#
# JQuery gallery plug-ins
#

baguettebox = Resource(library, 'plugins/baguetteBox.js',
                       minified='plugins/baguetteBox.min.js',
                       depends=(jquery,),
                       bottom=True)

masonry = Resource(library, 'plugins/masonry.pkgd.min.js',
                   depends=(jquery,),
                   bottom=True)

magic_grid = Resource(library, 'plugins/magic-grid.js',
                      minified='plugins/magic-grid.min.js',
                      bottom=True)


#
# Custom VueJS plug-ins
#

vuejs = Resource(library, 'vendor/vue.js',
                 minified='vendor/vue.min.js',
                 bottom=True)

selector = Resource(library, 'plugins/selector.vue.js',
                    depends=(vuejs,),
                    bottom=True)


#
# Custom ONF skins
#

onf_base_skin = Resource(library, 'styles/main.css',
                         minified='styles/main.min.css',
                         depends=(onf_base_script,))

onf_internal_skin = Resource(library, 'styles/internal.css',
                             minified='styles/internal.min.css',
                             depends=(onf_base_skin,))

onf_services_skin = Resource(library, 'styles/products-services.css',
                             minified='styles/products-services.min.css',
                             depends=(onf_base_skin,))

onf_territories_skin = Resource(library, 'styles/territories.css',
                                minified='styles/territories.min.css',
                                depends=(onf_base_skin,))

onf_live_skin = Resource(library, 'styles/live.css',
                         minified='styles/live.min.css',
                         depends=(onf_base_skin,))

onf_patronage_skin = Resource(library, 'styles/patronage.css',
                              minified='styles/patronage.min.css',
                              depends=(onf_services_skin,))

onf_vegetis_skin = Resource(library, 'styles/vegetis.css',
                            minified='styles/vegetis.min.css',
                            depends=(onf_services_skin,))


#
# External modules
#

tarteaucitron_css = Resource(library, 'styles/tarteaucitron.css',
                             minified='styles/tarteaucitron.min.css')

tarteaucitron_base = Resource(library, 'scripts/tarteaucitron.js',
                              bottom=True)

tarteaucitron_services = Resource(library, 'scripts/tarteaucitron.services.js',
                                  depends=(tarteaucitron_base,),
                                  bottom=True)

tarteaucitron = Group({tarteaucitron_css, tarteaucitron_services})
