#
# Copyright (c) 2015-2021 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

"""PyAMS_*** module

"""

__docformat__ = 'restructuredtext'

from z3c.form.browser.checkbox import SingleCheckBoxFieldWidget
from z3c.form.field import Fields

from onf_website.shared.view.skin.interfaces import IONFViewItemsPortletMapRendererSettings
from pyams_form.group import NamedWidgetsGroup
from pyams_form.interfaces.form import IFormManager
from pyams_portal.zmi.portlet import PortletRendererPropertiesEditForm
from pyams_skin.layer import IPyAMSLayer
from pyams_utils.adapter import ContextRequestViewAdapter, adapter_config
from pyams_zmi.form import AdminDialogEditForm

from onf_website import _


@adapter_config(context=(IONFViewItemsPortletMapRendererSettings, IPyAMSLayer,
                         PortletRendererPropertiesEditForm),
                provides=IFormManager)
class ONFViewItemsPortletMapRendererSettingsFormManager(ContextRequestViewAdapter):
    """ONF view items portlet map renderer settings form manager"""

    def getFields(self):
        fields = Fields(IONFViewItemsPortletMapRendererSettings).omit(
            'use_default_map_configuration')
        fields['no_use_default_map_configuration'].widgetFactory = SingleCheckBoxFieldWidget
        return fields

    def update(self):
        view = self.view
        view.dialog_class = 'modal-large'
        AdminDialogEditForm.update(view)

    def updateWidgets(self, prefix=None):
        AdminDialogEditForm.updateWidgets(self.view, prefix)

    def updateActions(self):
        AdminDialogEditForm.updateActions(self.view)

    def updateGroups(self):
        form = self.view
        form.add_group(NamedWidgetsGroup(form, 'configuration', form.widgets,
                                         ('no_use_default_map_configuration', 'crs', 'layers',
                                          'auto_adjust', 'initial_center', 'zoom_level',
                                          'initial_bounds', 'attribution_control',
                                          'zoom_control', 'fullscreen_control', 'layer_control',
                                          'keyboard', 'scroll_wheel_zoom'),
                                         legend=_("Don't use default map configuration"),
                                         css_class='inner',
                                         switch=True,
                                         checkbox_switch=True,
                                         checkbox_field=IONFViewItemsPortletMapRendererSettings[
                                             'no_use_default_map_configuration']))
        AdminDialogEditForm.updateGroups(form)
