#
# Copyright (c) 2008-2018 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

from zope.interface import classImplements

from onf_website.component.hearing import IHearingTarget
from onf_website.component.hearing.interfaces import IHearingManagerTarget
from onf_website.component.location import ILocationManagerTarget, ILocationTarget
from onf_website.shared.common.security import SharedToolManagerRestrictionInfo
from pyams_content.shared.common.interfaces import IManagerRestrictionsFactory
from pyams_content.shared.topic import WfTopic
from pyams_content.shared.topic.interfaces import ITopicManager
from pyams_content.shared.topic.manager import TopicManager
from pyams_utils.adapter import adapter_config


#
# Add interfaces to base classes
#

classImplements(TopicManager, ILocationManagerTarget)
classImplements(TopicManager, IHearingManagerTarget)

classImplements(WfTopic, ILocationTarget)
classImplements(WfTopic, IHearingTarget)


@adapter_config(context=ITopicManager, provides=IManagerRestrictionsFactory)
def topic_manager_restrictions_factory(context):
    """Topics manager custom restrictions factory"""
    return SharedToolManagerRestrictionInfo
