#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

from persistent import Persistent
from zope.interface import classImplements
from zope.schema.fieldproperty import FieldProperty

from onf_website.component.hearing.interfaces import IHearingManagerTarget, IHearingTarget
from onf_website.shared.common.security import SharedToolManagerRestrictionInfo
from onf_website.shared.site.interfaces import ISiteManagerUniverseInfo, SITE_MANAGER_UNIVERSE_KEY
from pyams_content.component.gallery import IGalleryTarget
from pyams_content.root.interfaces import ISiteRoot
from pyams_content.shared.common.interfaces import IManagerRestrictionsFactory
from pyams_content.shared.site import WfSiteTopic
from pyams_content.shared.site.folder import SiteFolder
from pyams_content.shared.site.interfaces import ISiteContainer, ISiteManager
from pyams_content.shared.site.manager import SiteManager
from pyams_utils.adapter import adapter_config, get_annotation_adapter
from pyams_utils.factory import factory_config

#
# Topics interfaces
#

classImplements(WfSiteTopic, IHearingTarget)

#
# Site folder interfaces
#

classImplements(SiteFolder, IHearingTarget)

#
# Site manager interfaces
#

classImplements(SiteManager, IGalleryTarget)

classImplements(SiteManager, IHearingManagerTarget)
classImplements(SiteManager, IHearingTarget)


@adapter_config(context=ISiteContainer, provides=IManagerRestrictionsFactory)
def site_container_restrictions_factory(context):
    """Site container restrictions factory"""
    return SharedToolManagerRestrictionInfo


@factory_config(ISiteManagerUniverseInfo)
class SiteManagerUniverseInfo(Persistent):
    """Site manager universe info"""

    universe = FieldProperty(ISiteManagerUniverseInfo['universe'])

    def get_universe(self, visible_only=True):
        universe = self.universe
        if universe is None:
            return None
        if (not visible_only) or universe.visible:
            return universe
        return None


@adapter_config(required=ISiteManager,
                provides=ISiteManagerUniverseInfo)
@adapter_config(required=ISiteRoot,
                provides=ISiteManagerUniverseInfo)
def site_manager_universe_info(context):
    """Site manager universe information adapter"""
    return get_annotation_adapter(context, SITE_MANAGER_UNIVERSE_KEY,
                                  ISiteManagerUniverseInfo)
