#
# Copyright (c) 2008-2018 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

from zope.interface import Interface

from onf_website.shared.service import IWfService
from onf_website.skin.public.layer import IONFBaseLayer
from pyams_default_theme.shared.common.interfaces import ICustomContentHeaderRenderer
from pyams_template.template import template_config
from pyams_utils.adapter import adapter_config
from pyams_viewlet.viewlet import ViewContentProvider


__docformat__ = 'restructuredtext'


@adapter_config(context=(IWfService, IONFBaseLayer, Interface),
                provides=ICustomContentHeaderRenderer)
@template_config(template='templates/head-specificities.pt', layer=IONFBaseLayer)
class ServiceHeadViewlet(ViewContentProvider):
    """Service head specificities viewlet"""
