#
# Copyright (c) 2008-2017 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

from zope.interface import implementer, provider
from zope.schema.fieldproperty import FieldProperty

from onf_website.component.hearing.interfaces import IHearingTarget
from onf_website.component.location.interfaces import ILocationTarget
from onf_website.shared.service.interfaces import IService, IWfService, IWfServiceFactory, SERVICE_CONTENT_NAME, \
    SERVICE_CONTENT_TYPE
from pyams_content.component.illustration.interfaces import IIllustrationTarget, ILinkIllustrationTarget
from pyams_content.component.paragraph.interfaces import IParagraphContainerTarget
from pyams_content.component.theme.interfaces import ITagsTarget, IThemesTarget
from pyams_content.features.preview.interfaces import IPreviewTarget
from pyams_content.features.review.interfaces import IReviewTarget
from pyams_content.shared.common import IWfSharedContentFactory, SharedContent, WfSharedContent, register_content_type
from pyams_sequence.reference import get_reference_target
from pyams_utils.adapter import adapter_config


@implementer(IWfService, IIllustrationTarget, ILinkIllustrationTarget, IParagraphContainerTarget,
             ILocationTarget, IHearingTarget, ITagsTarget, IThemesTarget,
             IPreviewTarget, IReviewTarget)
class WfService(WfSharedContent):
    """Service class"""

    content_type = SERVICE_CONTENT_TYPE
    content_name = SERVICE_CONTENT_NAME

    references = FieldProperty(IWfService['references'])
    client_wish_header = FieldProperty(IWfService['client_wish_header'])
    client_wish = FieldProperty(IWfService['client_wish'])
    provider_assets_header = FieldProperty(IWfService['provider_assets_header'])
    provider_assets = FieldProperty(IWfService['provider_assets'])
    logos = FieldProperty(IWfService['logos'])

    def __init__(self):
        super(WfService, self).__init__()
        self.client_wish_header = {
            'en': "You wish",
            'fr': "Vous souhaitez"
        }
        self.provider_assets_header = {
            'en': "ONF assets",
            'fr': "Les plus de l'ONF"
        }

    def get_logos(self, state=None, with_reference=False, request=None):
        for reference in self.logos or ():
            if with_reference:
                yield reference, get_reference_target(reference, state)
            else:
                yield get_reference_target(reference, state)


register_content_type(WfService)


@provider(IWfServiceFactory)
@implementer(IService)
class Service(SharedContent):
    """Workflow managed service delivery"""


@adapter_config(context=IWfServiceFactory, provides=IWfSharedContentFactory)
def service_content_factory(context):
    return WfService
