#
# Copyright (c) 2008-2018 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

from pyramid.decorator import reify
from zope.interface import Interface

from onf_website.skin.public.layer import IONFBaseLayer
from pyams_content.component.illustration import IIllustration
from pyams_content.component.theme import ICollectionsInfo
from pyams_content.features.search.interfaces import ISearchManagerInfo
from pyams_content.shared.resource import IResourceInfo, IWfResource
from pyams_default_theme.interfaces import IContentHeaderIllustration
from pyams_default_theme.shared.common.interfaces import \
    ICustomContentSpecificitiesParagraphRenderer, ICustomContentSpecificitiesRenderer
from pyams_template.template import template_config
from pyams_utils.adapter import adapter_config
from pyams_viewlet.viewlet import ViewContentProvider


__docformat__ = 'restructuredtext'


@adapter_config(context=(IWfResource, IONFBaseLayer, Interface),
                provides=ICustomContentSpecificitiesRenderer)
@template_config(template='templates/specificities.pt', layer=IONFBaseLayer)
class ResourceSpecificitiesRenderer(ViewContentProvider):
    """Resource specificities renderer"""

    @property
    def resource_info(self):
        return IResourceInfo(self.context)


@adapter_config(context=(IWfResource, IONFBaseLayer, Interface),
                provides=ICustomContentSpecificitiesParagraphRenderer)
@template_config(template='templates/specificities-paragraph.pt', layer=IONFBaseLayer)
class ResourceSpecificitiesParagraphRenderer(ViewContentProvider):
    """Resource specificities renderer"""

    @reify
    def resource_info(self):
        return IResourceInfo(self.context)

    def has_any_value(self, field_names):
        resource_info = self.resource_info
        for name in field_names:
            if name in ('summary', 'publisher_words'):
                continue
            if getattr(resource_info, name, None):
                return True
        return False

    @property
    def collections(self):
        collections_info = ICollectionsInfo(self.context, None)
        if collections_info is not None:
            collections = collections_info.collections or ()
            yield from sorted(collections, key=lambda x: (x.order or 999, x.alt or x.label))

    @reify
    def search_target(self):
        search_info = ISearchManagerInfo(self.request.root, None)
        if search_info is not None:
            return search_info.collections_target


@adapter_config(name='specificities', context=(IWfResource, IONFBaseLayer),
                provides=IContentHeaderIllustration)
def resource_specificities_illustration_adapter(context, request):
    """Resource specificities illustration adapter"""
    return request.registry.queryAdapter(context, IIllustration)
