
from pyramid.decorator import reify
from zope.interface import Interface

from onf_website.shared.planning import IPlanningManager, IWfPlanning
from onf_website.skin.public.layer import IONFBaseLayer
from pyams_content.component.illustration import IIllustration
from pyams_default_theme.interfaces import IContentHeaderIllustration
from pyams_default_theme.shared.common.interfaces import ICustomContentSpecificitiesRenderer
from pyams_template.template import template_config
from pyams_utils.adapter import adapter_config
from pyams_utils.registry import query_utility
from pyams_viewlet.viewlet import ViewContentProvider


__docformat__ = 'restructuredtext'


@adapter_config(context=(IWfPlanning, IONFBaseLayer, Interface),
                provides=ICustomContentSpecificitiesRenderer)
@template_config(template='templates/specificities.pt', layer=IONFBaseLayer)
class PlanningSpecificitiesRenderer(ViewContentProvider):
    """Planning specificities renderer"""

    @property
    def manager(self):
        return query_utility(IPlanningManager)

    @reify
    def planning(self):
        return IWfPlanning(self.context)


@adapter_config(name='specificities', context=(IWfPlanning, IONFBaseLayer),
                provides=IContentHeaderIllustration)
def planning_specificities_illustration_adapter(context, request):
    """Planning specificities illustration adapter"""
    return request.registry.queryAdapter(context, IIllustration)
