#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'


# import standard library

# import interfaces
from onf_website.component.hearing.interfaces import IHearingManagerTarget, IHearingTarget
from onf_website.component.location.interfaces import ILocationManagerTarget, ILocationTarget
from pyams_content.shared.common.interfaces import IManagerRestrictionsFactory
from pyams_content.shared.news.interfaces import INewsManager

# import packages
from onf_website.shared.common.security import SharedToolManagerRestrictionInfo
from pyams_content.shared.news import WfNewsEvent
from pyams_content.shared.news.manager import NewsManager
from pyams_utils.adapter import adapter_config
from zope.interface import classImplements


#
# Add interfaces to base classes
#

classImplements(NewsManager, ILocationManagerTarget)
classImplements(NewsManager, IHearingManagerTarget)

classImplements(WfNewsEvent, ILocationTarget)
classImplements(WfNewsEvent, IHearingTarget)


@adapter_config(context=INewsManager, provides=IManagerRestrictionsFactory)
def news_manager_restrictions_factory(context):
    """News manager custom restrictions factory"""
    return SharedToolManagerRestrictionInfo
