#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

from zope.interface import Interface

from pyams_content.shared.common.interfaces import ISharedContent, IWfSharedContentPortalContext, \
    ISharedToolPortalContext
from pyams_sequence.interfaces import IInternalReferencesList


__docformat__ = 'restructuredtext'

from onf_website import _


LONG_READ_CONTENT_TYPE = 'long-read'
LONG_READ_CONTENT_NAME = _("Long-read")


class ILongReadManager(ISharedToolPortalContext):
    """Long-read manager interface"""


class ILongReadManagerFactory(Interface):
    """Long-read manager factory interface"""


class IWfLongRead(IWfSharedContentPortalContext, IInternalReferencesList):
    """Long-read interface"""


class IWfLongReadFactory(Interface):
    """Long-read parent interface"""


class ILongRead(ISharedContent):
    """Workflow managed long-read interface"""
