#
# Copyright (c) 2008-2018 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'


# import standard library

from zope.interface import classImplements

# import interfaces
from onf_website.component.location.interfaces import ILocationManagerTarget, ILocationTarget
# import packages
from onf_website.shared.common.security import SharedToolManagerRestrictionInfo
from pyams_content.shared.common.interfaces import IManagerRestrictionsFactory
from pyams_content.shared.logo import WfLogo
from pyams_content.shared.logo.interfaces import ILogosManager
from pyams_content.shared.logo.manager import LogosManager
from pyams_utils.adapter import adapter_config

#
# Add interfaces to base classes
#

classImplements(LogosManager, ILocationManagerTarget)

classImplements(WfLogo, ILocationTarget)


@adapter_config(context=ILogosManager, provides=IManagerRestrictionsFactory)
def logos_manager_restrictions_factory(context):
    """Logos manager custom restrictions factory"""
    return SharedToolManagerRestrictionInfo

