#
# Copyright (c) 2008-2018 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

from zope.interface import Interface

from onf_website.shared.interview import IWfInterview
from onf_website.skin.public.layer import IONFBaseLayer
from pyams_content.component.illustration import IBasicIllustration
from pyams_default_theme.component.illustration import base_content_navigation_illustration_factory
from pyams_default_theme.features.search.portlet import ISearchResultHeader
from pyams_default_theme.interfaces import IContentNavigationIllustration, ISearchResultsView
from pyams_default_theme.shared.common.interfaces import ISharedContentHeadViewletManager
from pyams_i18n.interfaces import II18n
from pyams_template.template import template_config
from pyams_utils.adapter import adapter_config
from pyams_viewlet.viewlet import Viewlet, viewlet_config


@viewlet_config(name='interview-head', context=IWfInterview, layer=IONFBaseLayer, view=Interface,
                manager=ISharedContentHeadViewletManager, weight=1)
@template_config(template='templates/head-specifities.pt', layer=IONFBaseLayer)
class InterviewHeadViewlet(Viewlet):
    """Interview head specificities viewlet"""


@adapter_config(context=(IWfInterview, IONFBaseLayer),
                provides=IContentNavigationIllustration)
def interview_link_illustration_adapter(context, request):
    """Interview navigation illustration adapter"""
    illustration = base_content_navigation_illustration_factory(context, request)
    if not (illustration and illustration.has_data()):
        illustration = IBasicIllustration(context.portrait, None)
    return illustration


@adapter_config(context=(IWfInterview, IONFBaseLayer, ISearchResultsView),
                provides=ISearchResultHeader)
def interview_search_result_header_adapter(context, request, view):
    """Interview search result header adapter"""
    i18n = II18n(context)
    header = i18n.query_attribute('header', request=request)
    if not header:
        header = i18n.query_attribute('leading', request=request)
    return header
