#
# Copyright (c) 2008-2017 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

from zope.interface import implementer, provider
from zope.schema.fieldproperty import FieldProperty

from onf_website.component.hearing.interfaces import IHearingTarget
from onf_website.component.location.interfaces import ILocationTarget
from onf_website.shared.interview.interfaces import IInterview, INTERVIEW_CONTENT_NAME, \
    INTERVIEW_CONTENT_TYPE, IWfInterview, IWfInterviewFactory
from pyams_content.component.illustration.interfaces import IIllustrationTarget, \
    ILinkIllustrationTarget
from pyams_content.component.paragraph.interfaces import IParagraphContainerTarget
from pyams_content.component.theme.interfaces import ITagsTarget, IThemesTarget
from pyams_content.features.preview.interfaces import IPreviewTarget
from pyams_content.features.review.interfaces import IReviewTarget
from pyams_content.shared.common import IWfSharedContentFactory, SharedContent, WfSharedContent, \
    register_content_type
from pyams_content.shared.common.types import WfTypedSharedContentMixin
from pyams_file.property import FileProperty
from pyams_utils.adapter import adapter_config


__docformat__ = 'restructuredtext'


@implementer(IWfInterview, IIllustrationTarget, ILinkIllustrationTarget, IParagraphContainerTarget,
             ILocationTarget, IHearingTarget, ITagsTarget, IThemesTarget,
             IPreviewTarget, IReviewTarget)
class WfInterview(WfSharedContent, WfTypedSharedContentMixin):
    """Interview class"""

    content_type = INTERVIEW_CONTENT_TYPE
    content_name = INTERVIEW_CONTENT_NAME

    references = FieldProperty(IWfInterview['references'])

    leading = FieldProperty(IWfInterview['leading'])
    person_name = FieldProperty(IWfInterview['person_name'])
    portrait = FileProperty(IWfInterview['portrait'])

register_content_type(WfInterview)


@provider(IWfInterviewFactory)
@implementer(IInterview)
class Interview(SharedContent):
    """Workflow managed interview"""


@adapter_config(context=IWfInterviewFactory, provides=IWfSharedContentFactory)
def interview_content_factory(context):
    return WfInterview
