# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

from z3c.form.field import Fields

from onf_website.shared.hunting.interfaces import IHuntingManager, IHuntingManagerInfo
from pyams_content.component.theme.zmi import TagsMenu
from pyams_content.interfaces import MANAGE_TOOL_PERMISSION
from pyams_content.shared.common.zmi.manager import SharedToolPropertiesEditForm
from pyams_form.form import ajax_config
from pyams_form.interfaces.form import IInnerSubForm
from pyams_pagelet.pagelet import pagelet_config
from pyams_skin.layer import IPyAMSLayer
from pyams_utils.adapter import adapter_config
from pyams_viewlet.viewlet import viewlet_config
from pyams_zmi.form import InnerAdminEditForm
from pyams_zmi.interfaces.menu import IPropertiesMenu
from pyams_zmi.layer import IAdminLayer

__docformat__ = 'restructuredtext'

from onf_website import _


@pagelet_config(name='properties.html',
                context=IHuntingManager, layer=IPyAMSLayer,
                permission=MANAGE_TOOL_PERMISSION)
@ajax_config(name='properties.json',
             context=IHuntingManager, layer=IPyAMSLayer)
class HuntingManagerPropertiesEditForm(SharedToolPropertiesEditForm):
    """Hunting manager properties edit form"""

    @property
    def fields(self):
        return super().fields + Fields(IHuntingManagerInfo).select('notepad')
    
    
@adapter_config(name='owner-settings',
                context=(IHuntingManager, IPyAMSLayer, SharedToolPropertiesEditForm),
                provides=IInnerSubForm)
class HuntingManagerOwnerSettingsEditForm(InnerAdminEditForm):
    """Hunting manager owner settings edit form"""

    prefix = 'owner_properties.'

    legend = _("Text settings")
    fieldset_class = 'bordered no-x-margin margin-y-10'

    fields = Fields(IHuntingManagerInfo).select('title_prefix', 'season_prefix', 'default_header',
                                                'msg_generic_info', 'msg_incomplete_info',
                                                'msg_missing_info', 'msg_no_hunting_info')

    weight = 15


@adapter_config(name='hearing-settings',
                context=(IHuntingManager, IPyAMSLayer, SharedToolPropertiesEditForm),
                provides=IInnerSubForm)
class HuntingManagerHearingSettingsEditForm(InnerAdminEditForm):
    """Planning manager hearing settings edit form"""

    prefix = 'hearing_properties.'

    legend = _("Hearing settings")
    fieldset_class = 'bordered no-x-margin margin-y-10'

    fields = Fields(IHuntingManagerInfo).select('default_hearing_source',
                                                'default_source_folder')

    weight = 20


@adapter_config(name='template-settings',
                context=(IHuntingManager, IPyAMSLayer, SharedToolPropertiesEditForm),
                provides=IInnerSubForm)
class HuntingManagerTemplateSettingsEditForm(InnerAdminEditForm):
    """Hunting manager template settings edit form"""

    prefix = 'template_properties.'

    legend = _("Artemis calendars templates settings")
    fieldset_class = 'bordered no-x-margin margin-y-10'

    fields = Fields(IHuntingManagerInfo).select('default_template', 'missing_info_template')

    weight = 30


@viewlet_config(name='tags.menu',
                context=IHuntingManager, layer=IAdminLayer,
                manager=IPropertiesMenu, weight=350,
                permission=MANAGE_TOOL_PERMISSION)
class HuntingManagerTagsMenu(TagsMenu):
    """Hunting manager tags menu"""

    label = _("Default tags...")
