#
# Copyright (c) 2015-2022 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

"""PyAMS_*** module

"""

__docformat__ = 'restructuredtext'

from z3c.form.field import Fields
from onf_website.features.search.skin.zmi import \
    MapWithHeadFiltersSearchResultsPortletRendererSettingsFormManager
from onf_website.shared.hunting.skin.interfaces import \
    IHuntingCalendarsMapSearchResultsPortletRendererSettings
from pyams_form.interfaces.form import IFormManager
from pyams_portal.zmi.portlet import PortletRendererPropertiesEditForm
from pyams_skin.layer import IPyAMSLayer
from pyams_utils.adapter import adapter_config


@adapter_config(required=(IHuntingCalendarsMapSearchResultsPortletRendererSettings,
                          IPyAMSLayer, PortletRendererPropertiesEditForm),
                provides=IFormManager)
class ForestsAndActivitiesMapSearchResultsPortletRendererSettingsFormManager(
        MapWithHeadFiltersSearchResultsPortletRendererSettingsFormManager):
    """Forests and activities map search results portlet renderer settings edit form manager"""

    def getFields(self):
        return super().getFields() + \
            Fields(IHuntingCalendarsMapSearchResultsPortletRendererSettings) \
                .select('display_header', 'search_distance', 'display_distance',
                        'distance_message', 'short_distance_length', 'short_distance_message',
                        'no_result_message')
