# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

from zope.interface import Interface

from onf_website.reference.hunting.model import LotChasse
from onf_website.shared.hunting import IHuntingManager
from pyams_content.shared.common.portlet.interfaces import ISharedContentSpecificitiesPortletSettings
from pyams_i18n.interfaces import II18n
from pyams_portal.interfaces import IPortalContext, IPortletRenderer
from pyams_portal.portlet import PortletRenderer
from pyams_skin.layer import IPyAMSLayer
from pyams_template.template import template_config
from pyams_utils.adapter import adapter_config
from pyams_utils.registry import get_utility

__docformat__ = 'restructuredtext'

from onf_website import _


@adapter_config(name='hunting-missing-info',
                required=(IPortalContext, IPyAMSLayer, Interface,
                          ISharedContentSpecificitiesPortletSettings),
                provides=IPortletRenderer)
@template_config(template='templates/hunting-calendar-missing-info.pt',
                 layer=IPyAMSLayer)
class HuntingCalendarMissingInfoSpecificitiesRenderer(PortletRenderer):
    """Hunting calendar missing information specificities renderer"""
    
    label = _("ONF: Hunting calendar missing information")
    weight = 10
    
    @property
    def manager(self):
        return get_utility(IHuntingManager)

    @property
    def missing_info(self):
        manager = II18n(self.manager)
        if LotChasse.find_lots(self.context.forest_ids).count() > 0:
            return manager.query_attribute('msg_missing_info', request=self.request)
        return manager.query_attribute('msg_no_hunting_info', request=self.request)
