#
# Copyright (c) 2015-2021 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

"""PyAMS_*** module

"""

from zope.interface import Interface
from zope.schema import Choice, Text

from pyams_content.features.search import ISearchFolder
from pyams_content.shared.common import ISharedContent
from pyams_content.shared.common.interfaces import ISharedToolPortalContext, \
    IWfSharedContentPortalContext
from pyams_i18n.schema import I18nHTMLField, I18nTextField, I18nTextLineField
from pyams_portal.interfaces import PORTAL_TEMPLATES_VOCABULARY
from pyams_sequence.interfaces import IInternalReferencesList
from pyams_sequence.schema import InternalReferenceField

__docformat__ = 'restructuredtext'

from onf_website import _


HUNTING_CONTENT_TYPE = 'hunting'
HUNTING_CONTENT_NAME = _("Hunting calendar")


class IHuntingManagerInfo(Interface):
    """Hunting manager base information interface"""
    
    notepad = Text(title=_("Notepad"),
                   description=_("Internal information to be known about this tool"),
                   required=False)
    
    title_prefix = I18nTextLineField(title=_("Title prefix"),
                                     description=_("This prefix will be displayed in front of every "
                                                   "hunting calendar"),
                                     required=False)

    season_prefix = I18nTextLineField(title=_("Season prefix"),
                                      description=_("This prefix will be displayed in front of each "
                                                    "season label"),
                                      required=False)
    
    default_header = I18nTextField(
        title=_("Default header"),
        description=_("This header will be used as default header for all calendars for which no "
                      "custom header has been defined"),
        required=False)
    
    default_hearing_source = Choice(title=_("Default origin site"),
                                    description=_("This site will be used as source site for all "
                                                  "hunting calendars created automatically"),
                                    required=False,
                                    vocabulary='PyAMS shared sites')

    default_source_folder = InternalReferenceField(
        title=_("Default source folder"),
        description=_("Main folder to which content is attached; if this reference "
                      "is set, canonical URL will be based on this object's URL for all "
                      "hunting calendars"),
        required=False)
    
    def get_default_source(self):
        """Default hearing source getter"""

    default_template = Choice(title=_("Default template"),
                              description=_("This is the template which will be used for hunting "
                                            "calendars created automatically from Artemis database"),
                              vocabulary=PORTAL_TEMPLATES_VOCABULARY,
                              required=False)
    
    missing_info_template = Choice(title=_("Missing info template"),
                                   description=_("This template will be used when no hunting "
                                                 "calendar information is available"),
                                   vocabulary=PORTAL_TEMPLATES_VOCABULARY,
                                   required=False)

    msg_generic_info = I18nHTMLField(
        title=_("Generic information message"),
        description=_("This message will be displayed on every hunting calendar"),
        required=False)
    
    msg_incomplete_info = I18nHTMLField(
        title=_("Incomplete information message"),
        description=_("This message will be displayed when unvalidated dates are present in the hunting "
                      "calendar"),
        required=False)
    
    msg_missing_info = I18nHTMLField(
        title=_("Missing information message"),
        description=_("This message will be displayed when hunting calendar information is still missing"),
        required=False)
    
    msg_no_hunting_info = I18nHTMLField(
        title=_("No-hunting information message"),
        description=_("This message will be displayed when selected forest is not concerned by hunting"),
        required=False)


class IHuntingManager(ISharedToolPortalContext, IHuntingManagerInfo):
    """Hunting manager interface"""


class IHuntingManagerFactory(Interface):
    """Hunting manager factory interface"""


class IWfHuntingCalendar(IWfSharedContentPortalContext, IInternalReferencesList):
    """Hunting calendar content interface"""


class IWfRealHuntingCalendar(Interface):
    """Real hunting calendar marker interface"""
    

class IWfHuntingCalendarFactory(Interface):
    """Hunting calendar factory interface"""


class IHuntingCalendar(ISharedContent):
    """Workflow managed hunting calendar interface"""


HUNTING_INFO_ANNOTATIONS_KEY = 'onf_website.hunting'


class IHuntingCalendarInfo(Interface):
    """Hunting calendar info interface"""

    season = I18nTextLineField(title=_("Season"),
                               description=_("Hunting calendar season"),
                               required=False)


class IHuntingCalendarSearchFolder(ISearchFolder):
    """Hunting calendar search folder interface"""


class IHuntingCalendarSearchFolderQuery(Interface):
    """Hunting calendar search folder query adapter interface"""

    def get_results(self, context, sort_index=None, reverse=None, limit=None,
                    start=0, length=None, ignore_cache=False, get_count=False, request=None,
                    aggregates=None, settings=None, **kwargs):
        """Search results getter"""
