#
# Copyright (c) 2015-2022 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

"""PyAMS_*** module

"""

from enum import Enum
from zope.interface import Interface
from zope.schema import Choice

from pyams_content.features.search import ISearchFolder
from pyams_portal.interfaces import PORTAL_TEMPLATES_VOCABULARY


__docformat__ = 'restructuredtext'

from onf_website import _


class DisplayMode(Enum):
    """Display mode"""

    FOREST_MAP = 'fm'
    FOREST_LIST = 'fl'
    ACTIVITY_MAP = 'am'
    ACTIVITY_LIST = 'al'


DISPLAY_MODE_TEMPLATE = {
    DisplayMode.FOREST_MAP.value: 'forests_map_template',
    DisplayMode.FOREST_LIST.value: 'forests_list_template',
    DisplayMode.ACTIVITY_MAP.value: 'activities_map_template',
    DisplayMode.ACTIVITY_LIST.value: 'activities_list_template'
}


class IForestHubSearchFolder(ISearchFolder):
    """Forest hub search folder"""

    forests_map_template = Choice(title=_("Forests map template"),
                                  description=_("Presentation template used to display "
                                                "forests search results as map"),
                                  vocabulary=PORTAL_TEMPLATES_VOCABULARY,
                                  required=False)

    forests_list_template = Choice(title=_("Forests list template"),
                                   description=_("Presentation template used to display "
                                                 "forests search results as list"),
                                   vocabulary=PORTAL_TEMPLATES_VOCABULARY,
                                   required=False)

    activities_map_template = Choice(title=_("Activities map template"),
                                     description=_("Presentation template used to display "
                                                   "activities search results as map"),
                                     vocabulary=PORTAL_TEMPLATES_VOCABULARY,
                                     required=False)

    activities_list_template = Choice(title=_("Activities list template"),
                                      description=_("Presentation template used to display "
                                                    "activities search results as list"),
                                      vocabulary=PORTAL_TEMPLATES_VOCABULARY,
                                      required=False)


class IForestHubSearchFolderQuery(Interface):
    """Forest hub search folder query adapter interface"""

    def get_results(self, context, sort_index=None, reverse=None, limit=None,
                    start=0, length=None, ignore_cache=False, get_count=False, request=None,
                    aggregates=None, settings=None, **kwargs):
        """Get search results"""
