#
# Copyright (c) 2015-2021 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

"""ONF_WebSite.shared.forest.zmi.manager module

"""

from z3c.form import field

from onf_website.shared.forest.interfaces import IForestManager, IForestManagerInfo
from onf_website.shared.forest.zmi.widget import ForestManagerTemplatesSelectWidgetFactory
from pyams_content.component.illustration import IIllustration
from pyams_content.component.illustration.zmi import IllustrationPropertiesInnerEditForm
from pyams_content.shared.common.zmi.manager import SharedToolPropertiesEditForm
from pyams_form.interfaces.form import IInnerSubForm
from pyams_skin.layer import IPyAMSLayer
from pyams_utils.adapter import adapter_config
from pyams_zmi.form import InnerAdminEditForm
from pyams_zmi.interfaces import IPropertiesEditForm


__docformat__ = 'restructuredtext'

from onf_website import _


@adapter_config(name='dom-illustration',
                context=(IForestManager, IPyAMSLayer, IPropertiesEditForm),
                provides=IInnerSubForm)
class DOMIllustrationPropertiesInnerEditForm(IllustrationPropertiesInnerEditForm):
    """DOM illustration properties inner edit form"""

    prefix = 'dom_illustration_form.'

    legend = _("DOM illustration")
    weight = 11

    def getContent(self):
        registry = self.request.registry
        return registry.queryAdapter(self.context, IIllustration, name='dom')


@adapter_config(name='owner-settings',
                context=(IForestManager, IPyAMSLayer, SharedToolPropertiesEditForm),
                provides=IInnerSubForm)
class ForestManagerOwnerSettingsEditForm(InnerAdminEditForm):
    """Forest manager owner settings edit form"""

    prefix = 'baseline_properties.'

    legend = _("Baseline settings")
    fieldset_class = 'bordered no-x-margin margin-y-10'

    fields = field.Fields(IForestManagerInfo).select('baseline_help', 'baseline_max_length',
                                                     'gallery_help', 'default_owner')

    weight = 15


@adapter_config(name='hearing-settings',
                context=(IForestManager, IPyAMSLayer, SharedToolPropertiesEditForm),
                provides=IInnerSubForm)
class ForestManagerHearingSettingsEditForm(InnerAdminEditForm):
    """Forest manager hearing settings edit form"""

    prefix = 'hearing_properties.'

    legend = _("Hearing settings")
    fieldset_class = 'bordered no-x-margin margin-y-10'

    fields = field.Fields(IForestManagerInfo).select('default_hearing_source',
                                                     'default_source_folder')

    weight = 20


@adapter_config(name='template-settings',
                context=(IForestManager, IPyAMSLayer, SharedToolPropertiesEditForm),
                provides=IInnerSubForm)
class ForestManagerTemplateSettingsEditForm(InnerAdminEditForm):
    """Forest manager template settings edit form"""

    prefix = 'template_properties.'

    legend = _("Template settings")
    fieldset_class = 'bordered no-x-margin margin-y-10'

    fields = field.Fields(IForestManagerInfo).select('templates')
    fields['templates'].widgetFactory = ForestManagerTemplatesSelectWidgetFactory

    weight = 30
