#
# Copyright (c) 2015-2021 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

"""PyAMS_*** module

"""

from zope.interface import Interface
from zope.schema import Int


__docformat__ = 'restructuredtext'

from onf_website import _


class IDefaultBaselinePortletRendererSettings(Interface):
    """Default baseline portlet renderer settings interface"""

    nb_lines = Int(title=_("Maximum lines count"),
                   description=_("Maximum number of displayed lines; set to 0 to disable this "
                                 "limit"),
                   required=False,
                   default=15)
