#
# Copyright (c) 2015-2021 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

"""PyAMS_*** module

"""

from persistent import Persistent
from zope.container.contained import Contained
from zope.interface import Interface
from zope.schema.fieldproperty import FieldProperty

from onf_website.shared.forest.interfaces import IWfRealForest
from onf_website.shared.forest.portlet.interfaces import IBaselinePortletSettings
from onf_website.shared.forest.portlet.skin.interfaces import \
    IDefaultBaselinePortletRendererSettings
from pyams_i18n.interfaces import II18n
from pyams_portal.interfaces import IPortalContext, IPortletRenderer
from pyams_portal.portlet import PortletRenderer
from pyams_skin.layer import IPyAMSLayer
from pyams_template.template import template_config
from pyams_utils.adapter import adapter_config
from pyams_utils.factory import factory_config


__docformat__ = 'restructuredtext'

from onf_website import _


@factory_config(IDefaultBaselinePortletRendererSettings)
class DefaultBaselinePortletRendererSettings(Persistent, Contained):
    """Default baseline portlet renderer settings"""

    nb_lines = FieldProperty(IDefaultBaselinePortletRendererSettings['nb_lines'])


@adapter_config(context=(IPortalContext, IPyAMSLayer, Interface, IBaselinePortletSettings),
                provides=IPortletRenderer)
@template_config(template='templates/baseline.pt', layer=IPyAMSLayer)
class BaselinePortletDefaultRenderer(PortletRenderer):
    """Baseline portlet default renderer"""

    label = _("Default baseline portlet")

    settings_interface = IDefaultBaselinePortletRendererSettings

    def get_baseline(self, request=None):
        forest = IWfRealForest(self.context, None)
        if forest is None:
            return None
        return II18n(forest).get_attribute('baseline_published', request=request)
