#
# Copyright (c) 2008-2018 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

from zope.schema.fieldproperty import FieldProperty

from onf_website.shared.expengine.portlet.interfaces import IExpEnginePortletSettings
from pyams_content.component.links import InternalReferenceMixin
from pyams_portal.portlet import Portlet, PortletSettings, portlet_config
from pyams_utils.factory import factory_config
from pyams_utils.interfaces import VIEW_PERMISSION

from onf_website import _


EXPENGINE_PORTLET_NAME = 'onf_website.portlet.expengine'


@factory_config(provided=IExpEnginePortletSettings)
class ExpEnginePortletSettings(PortletSettings, InternalReferenceMixin):
    """Experiential engine portlet settings"""

    title = FieldProperty(IExpEnginePortletSettings['title'])
    reference = FieldProperty(IExpEnginePortletSettings['reference'])


@portlet_config(permission=VIEW_PERMISSION)
class ExpEnginePortlet(Portlet):
    """Experiential engine portlet"""

    name = EXPENGINE_PORTLET_NAME
    label = _("Experiential engine")

    toolbar_image = None
    toolbar_css_class = 'fa fa-fw fa-2x fa-life-ring'

    settings_factory = IExpEnginePortletSettings
